/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.java;

import biouml.model.Compartment;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.plugins.simulation.OdeSimulationEngine;
import biouml.standard.diagram.Util;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import ru.biosoft.math.model.AstConstant;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstFunctionDeclaration;
import ru.biosoft.math.model.AstPiece;
import ru.biosoft.math.model.AstPiecewise;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.Node;

public class SimulationEngineWrapper {
    OdeSimulationEngine engine;
    public static final int MAX_BYTE_CODE_PER_METHOD = 64000;
    public static final int BYTE_CODE_PER_CALL = 3;
    public static final int BYTE_CODE_PER_ASSIGNMENT = 8;
    public static final int BYTE_CODE_PER_VARIABLE = 4;
    public static final int BYTE_CODE_PER_CONST = 4;
    public static final int BYTE_CODE_PER_FUNCTION = 3;
    public static final int BYTE_CODE_PER_EMBEDDED_OPERATION = 1;
    public static final int BYTE_CODE_PER_CONDITION = 7;
    public static final int BYTE_CODE_PER_ARRAY_VARIABLE = 5;

    public SimulationEngineWrapper(OdeSimulationEngine engine) {
        this.engine = engine;
    }

    public OdeSimulationEngine getEngine() {
        return this.engine;
    }

    public int getEMODEL_ODE_TYPE() {
        return 2;
    }

    public int getEMODEL_ODE_DELAY_TYPE() {
        return 4;
    }

    public int getEMODEL_ALGEBRAIC_TYPE() {
        return 8;
    }

    public int getEMODEL_EVENT_TYPE() {
        return 16;
    }

    public int getEMODEL_STATE_TRANSITION_TYPE() {
        return 32;
    }

    public boolean isOfType(int type, int suggestedType) {
        return (type & suggestedType) != 0;
    }

    public boolean isEQUATION_TYPE_SCALAR_DELAYED(String type) {
        return type.equals("scalar_delayed");
    }

    public boolean isEQUATION_TYPE_SCALAR_INTERNAL(String type) {
        return type.equals("scalar_internal");
    }

    public boolean isEQUATION_TYPE_SCALAR(String type) {
        return type.equals("scalar");
    }

    public boolean isEQUATION_TYPE_INITIAL_VALUE(String type) {
        return type.equals("initial value assignment");
    }

    public boolean istEQUATION_TYPE_CONST(String type) {
        return type.equals("const");
    }

    public boolean isDelayedEvent(Event event) {
        String val = event.getDiagramElement().getAttributes().getValueAsString("eventType");
        return "assignment".equals(val);
    }

    public boolean isTriggerForDelayedEvent(Event event) {
        String val = event.getDiagramElement().getAttributes().getValueAsString("eventType");
        return "trigger".equals(val);
    }

    public boolean isSpecieReference(Edge edge) {
        return edge.getKernel() != null && edge.getKernel() instanceof SpecieReference;
    }

    public boolean isVariable(biouml.model.Node node) {
        return node.getRole() != null && node.getRole() instanceof Variable;
    }

    public boolean isRate(Equation equation) {
        return Equation.isRate((String)equation.getType());
    }

    public boolean isFast(Equation equation) {
        if (equation.getDiagramElement() instanceof Edge) {
            return ((Edge)equation.getDiagramElement()).nodes().map(n -> n.getKernel()).select(Reaction.class).anyMatch(r -> r.isFast());
        }
        return false;
    }

    public boolean hasFastReactions() {
        return this.engine.getDiagram().recursiveStream().anyMatch(de -> Util.isFastReaction((DiagramElement)de));
    }

    public boolean isScalar(Equation equation) {
        return Equation.isScalar((String)equation.getType());
    }

    public boolean isCompartment(Variable var) {
        return var instanceof VariableRole && ((VariableRole)var).getDiagramElement() instanceof Compartment;
    }

    public boolean isInitialConcentration(Variable var) {
        return var instanceof VariableRole && ((VariableRole)var).getInitialQuantityType() == 1;
    }

    public boolean isOutputConcentration(Variable var) {
        return var instanceof VariableRole && ((VariableRole)var).getOutputQuantityType() == 1;
    }

    public VariableRole getCompartmentVariable(Variable var) {
        Compartment compartment;
        if (var instanceof VariableRole && (compartment = ((VariableRole)var).getDiagramElement().getCompartment()).getRole() instanceof VariableRole) {
            return (VariableRole)compartment.getRole();
        }
        return null;
    }

    public String getCode(double value) {
        if (value == Double.NEGATIVE_INFINITY) {
            return "Double.NEGATIVE_INFINITY";
        }
        if (value == Double.POSITIVE_INFINITY) {
            return "Double.POSITIVE_INFINITY";
        }
        if (Double.isNaN(value)) {
            return "Double.NaN";
        }
        return String.valueOf(value);
    }

    public int estimateByteCodeLength(Node node) {
        return this.estimateByteCodeLength(node, 0);
    }

    public int estimateByteCodeLength(Node node, int additionalVariableBytes) {
        if (node instanceof AstVarNode) {
            String variableName = ((AstVarNode)node).getName();
            return this.estimateVariableByteCodeLength(variableName) + additionalVariableBytes;
        }
        if (node instanceof AstConstant) {
            return this.estimateConstantByteCodeLength(((AstConstant)node).getValue());
        }
        if (node instanceof AstFunNode) {
            int whole_length;
            if (((AstFunNode)node).getFunction().getPriority() == 7 || ((AstFunNode)node).getFunction().getPriority() == 6) {
                whole_length = 3;
                if (((AstFunNode)node).getFunction() instanceof AstFunctionDeclaration) {
                    whole_length += additionalVariableBytes;
                }
            } else {
                whole_length = 1;
            }
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                whole_length += this.estimateByteCodeLength(node.jjtGetChild(i), additionalVariableBytes);
            }
            return whole_length;
        }
        if (node instanceof AstPiecewise) {
            int whole_length = 3;
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                whole_length += this.estimateByteCodeLength(node.jjtGetChild(i), additionalVariableBytes);
            }
            return whole_length;
        }
        if (node instanceof AstStart) {
            int whole_length = 0;
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                whole_length += this.estimateByteCodeLength(node.jjtGetChild(i), additionalVariableBytes);
            }
            return whole_length;
        }
        if (node instanceof AstPiece) {
            return 7;
        }
        return 0;
    }

    public int estimateVariableByteCodeLength(String variableName) {
        String codeName = this.engine.getVariableCodeName(variableName);
        if (codeName.contains("[")) {
            int pos1 = codeName.indexOf("[");
            int pos2 = codeName.indexOf("]");
            return this.estimateConstantByteCodeLength(Integer.parseInt(codeName.substring(pos1 + 1, pos2))) + 5;
        }
        return 4;
    }

    public int estimateConstantByteCodeLength(Object constant) {
        if (constant instanceof Integer) {
            Integer intConstant = (Integer)constant;
            if (-1 <= intConstant && intConstant <= 5) {
                return 1;
            }
            if (-128 <= intConstant && intConstant <= 127) {
                return 2;
            }
            return 3;
        }
        if (constant instanceof Double) {
            Double doubleConstant = (Double)constant;
            if (doubleConstant == 0.0 || doubleConstant == 1.0) {
                return 1;
            }
            return 3;
        }
        return 4;
    }

    public StringBuilder createStringBuilder() {
        return new StringBuilder();
    }

    public boolean isTerminal(Event event) {
        return Boolean.TRUE.equals(event.getDiagramElement().getAttributes().getValue("Terminal"));
    }
}

