/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.java;

import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import ru.biosoft.access.security.CodePrivilege;
import ru.biosoft.access.security.CodePrivilegeType;

@CodePrivilege(value={CodePrivilegeType.REFLECTION})
public class RunTimeCompiler {
    protected static final Logger log = Logger.getLogger(RunTimeCompiler.class.getName());
    protected String classpath = ".";
    protected String srcDir;
    protected String outDir;
    protected String[] files;
    protected ErrorOutputStream outStream = new ErrorOutputStream();

    public RunTimeCompiler(String classpath, String srcDir, String[] files) {
        this.classpath = classpath;
        this.srcDir = srcDir;
        this.outDir = srcDir;
        this.files = files;
    }

    public boolean execute() {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        for (int i = 0; i < this.files.length; ++i) {
            int results = compiler.run(null, null, this.outStream, "-d", this.outDir, "-classpath", this.classpath, this.files[i]);
            if (results == 0) continue;
            log.log(Level.SEVERE, "can not compile model");
            return false;
        }
        return true;
    }

    public String getMessages() {
        return this.outStream.toString();
    }

    public static class ErrorOutputStream
    extends ByteArrayOutputStream {
        public void clear() {
            try {
                this.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.buf = new byte[32];
            this.count = 0;
        }
    }
}

