/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.java;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.Role;
import biouml.model.dynamics.VariableRole;
import biouml.plugins.simulation.ArraySpan;
import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.OdeSimulationEngine;
import biouml.plugins.simulation.OdeSimulatorOptions;
import biouml.plugins.simulation.Options;
import biouml.plugins.simulation.ResultWriter;
import biouml.plugins.simulation.SimulationEngineLogger;
import biouml.plugins.simulation.SimulatorSupport;
import biouml.plugins.simulation.Span;
import biouml.plugins.simulation.UniformSpan;
import biouml.plugins.simulation.ae.AeConjugateGradientSolver;
import biouml.plugins.simulation.ae.AeLevenbergMarquardSolver;
import biouml.plugins.simulation.ae.AeNelderMeadSolver;
import biouml.plugins.simulation.ae.AeSolver;
import biouml.plugins.simulation.ae.KinSolverWrapper;
import biouml.plugins.simulation.ae.NewtonSolverWrapperEx;
import biouml.plugins.simulation.java.EventLoopSimulator;
import biouml.plugins.simulation.java.JavaBaseModel;
import biouml.plugins.simulation.java.JavaLargeModel;
import biouml.plugins.simulation.java.MessageBundle;
import biouml.plugins.simulation.java.SimulationEngineWrapper;
import biouml.plugins.simulation.ode.jvode.JVodeSolver;
import biouml.standard.diagram.Util;
import biouml.standard.simulation.ResultListener;
import biouml.standard.simulation.SimulationResult;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import one.util.streamex.EntryStream;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.math.model.Formatter;
import ru.biosoft.math.model.JavaFormatter;

@PropertyName(value="Java simulation engine")
@PropertyDescription(value="Deterministic simulation engine to solve system of odinary differential equations.")
public class JavaSimulationEngine
extends OdeSimulationEngine {
    private static final long serialVersionUID = -8518921040812722254L;
    public static final String STIFF_PROBLEM = "Problem is too stiff for this solver";
    public static final String UNSTABLE_PROBLEM = "Problem is unstable";
    public static final int DIAGRAM_SIZE_LIMIT = 1000;
    public static final String TEMPLATE_AUTO = "Auto";
    public static final String TEMPLATE_NORMAL_ONLY = "Normal model";
    public static final String TEMPLATE_LARGE_ONLY = "Large model";
    public static final String TEMPLATE_PARALLEL = "Parallel";
    protected String templateType = "Auto";
    protected AeSolver algebraicSolver = new NewtonSolverWrapperEx();
    protected String algebraicSolverName = "NewtonSolver";
    protected Template velocityTemplate;
    private File modelFile;
    private String customClassPath = null;
    protected static String NORMAL_TEMPLATE = "resources/odeModelTemplate.vm";
    protected static String LARGE_TEMPLATE = "resources/odeLargeModelTemplate.vm";
    protected static String LARGE_DELAY_TEMPLATE = "resources/odeDelayLargeModelTemplate.vm";
    protected static String PARALLEL_LARGE_TEMPLATE = "resources/odeParallelLargeModelTemplate.vm";
    public static final String KIN_SOLVER = "KinSolver";
    public static final String NEWTON_SOLVER = "NewtonSolver";
    public static final String CONJUGATE_GRADIENT = "ConjugateGradient";
    public static final String NELDER_MEAD = "NelderMead";
    public static final String LEVENBERG_MARQUARD = "LevenbergMarquard";
    static final String[] availableSolvers = new String[]{"LevenbergMarquard", "ConjugateGradient", "NelderMead", "NewtonSolver", "KinSolver"};
    private boolean largeTemplate = false;
    private boolean hasDelays = false;
    private boolean parallel = false;
    private int threads = 4;
    protected Span span = null;
    private static final Set<String> javaKeywords = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));

    public JavaSimulationEngine() {
        this.simulatorType = "JAVA";
        this.log = new SimulationEngineLogger(MessageBundle.class.getName(), this.getClass());
        EventLoopSimulator javaSimulator = new EventLoopSimulator();
        javaSimulator.setSolver(new JVodeSolver());
        this.simulator = javaSimulator;
    }

    @Override
    public Formatter getFormatter() {
        return new JavaFormatter(this.varHistoricalIndexMapping);
    }

    @Override
    public Object getSolver() {
        return this.simulator instanceof EventLoopSimulator ? ((EventLoopSimulator)this.simulator).getSolver() : this.simulator;
    }

    @Override
    public void setSolver(Object solver) {
        Object oldValue = this.getSolver();
        Options oldOptions = this.getSimulatorOptions();
        SimulatorSupport newSimulator = (SimulatorSupport)solver;
        if (newSimulator instanceof EventLoopSimulator) {
            this.solverName = ((EventLoopSimulator)newSimulator).getSolver().getInfo().name;
            this.simulator = newSimulator;
        } else if (newSimulator.getInfo().eventsSupport) {
            this.solverName = newSimulator.getInfo().name;
            EventLoopSimulator eventSimulator = new EventLoopSimulator();
            eventSimulator.setSolver(newSimulator);
            this.simulator = eventSimulator;
        } else {
            this.solverName = newSimulator.getInfo().name;
            this.simulator = newSimulator;
        }
        this.firePropertyChange("simulatorOptions", (Object)oldOptions, this.simulator.getDefaultOptions());
        this.firePropertyChange("solver", oldValue, solver);
    }

    @Override
    public double getAbsTolerance() {
        return ((OdeSimulatorOptions)this.getSimulatorOptions()).getAtol();
    }

    @Override
    public void setAbsTolerance(double absTolerance) {
        ((OdeSimulatorOptions)this.getSimulatorOptions()).setAtol(absTolerance);
    }

    @Override
    public double getRelTolerance() {
        return ((OdeSimulatorOptions)this.getSimulatorOptions()).getRtol();
    }

    @Override
    public void setRelTolerance(double relTolerance) {
        ((OdeSimulatorOptions)this.getSimulatorOptions()).setRtol(relTolerance);
    }

    @Override
    public void clearContext() {
        this.setAbsTolerance(1.0E-10);
        this.setRelTolerance(1.0E-11);
    }

    public Span getSpan() {
        return this.span;
    }

    @Override
    public void setSpan(Span span) {
        super.setSpan(span);
        this.span = span;
    }

    public void resetSpan() {
        double t0 = this.getInitialTime();
        double tf = this.getCompletionTime();
        double inc = this.getTimeIncrement();
        this.span = inc != 0.0 ? new UniformSpan(t0, tf, inc) : new ArraySpan(t0, tf);
    }

    @Override
    public void setInitialTime(double initialTime) {
        super.setInitialTime(initialTime);
        this.resetSpan();
    }

    @Override
    public void setCompletionTime(double completionTime) {
        super.setCompletionTime(completionTime);
        this.resetSpan();
    }

    @Override
    public void setTimeIncrement(double timeIncrement) {
        super.setTimeIncrement(timeIncrement);
        this.resetSpan();
    }

    @Override
    public String getEngineDescription() {
        return "Java-" + this.simulator.getInfo().name;
    }

    @PropertyName(value="Code generation type")
    @PropertyDescription(value="Type of code generation: if auto then BioUML will try to choose by itself.")
    public String getTemplateType() {
        return this.templateType;
    }

    public void setTemplateType(String templateType) {
        if (!templateType.equals(this.templateType)) {
            this.templateType = templateType;
            this.diagramModified = true;
        }
    }

    @Override
    public String simulate(File[] files, ResultListener[] listeners) throws Exception {
        return this.simulate(files, true, listeners);
    }

    public String simulate(File[] files, boolean compile, ResultListener[] listeners) throws Exception {
        Object[] objs = this.compileModel(files, compile, this.outputDir);
        if (objs.length == 0 || !(objs[0] instanceof Model)) {
            throw new Exception("Can not find model");
        }
        return this.simulate((Model)objs[0], listeners);
    }

    public void disableLog() {
        this.setLogLevel(Level.OFF);
    }

    public SimulationResult simulateSimple(Model model) throws Exception {
        SimulationResult result = new SimulationResult(null, "");
        this.initSimulationResult(result);
        this.simulate(model, new ResultListener[]{new ResultWriter(result)});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String simulate(Model model, ResultListener[] listeners) throws Exception {
        if (model == null) {
            throw new IllegalArgumentException("Model was not generated");
        }
        if (!(model instanceof JavaBaseModel)) {
            throw new IllegalArgumentException("Incorrect model class for JavaSimulationEngine " + model.getClass() + ". Only JavaBaseModel allowed");
        }
        this.simulator.setLogLevel(this.log.getLogger().getLevel());
        this.log.info("Model " + this.diagram.getName() + ": simulation started.");
        if (listeners != null) {
            for (ResultListener listener : listeners) {
                listener.start((Object)model);
            }
        }
        if (this.span == null) {
            this.resetSpan();
        }
        if (this.simulator instanceof SimulatorSupport) {
            ((SimulatorSupport)this.simulator).setPresimulateFastReactions(this.fastReactions.equals("ODE system") && Util.hasFastReactions((Diagram)this.diagram));
        }
        ((JavaBaseModel)model).setAeSolver(this.getAlgebraicSolver());
        try {
            this.simulator.start(model, this.span, listeners, this.jobControl);
        }
        catch (Throwable t) {
            this.log.info("Model " + this.diagram.getName() + ": simulation terminated with error.");
            this.log.info(t.getMessage());
            this.log.info("");
            String string = "Simulation error: " + t.getMessage();
            return string;
        }
        finally {
            this.restoreOriginalDiagram();
        }
        this.checkVariables(((JavaBaseModel)model).getCurrentState(), EntryStream.of((Map)this.varIndexMapping).invert().toMap());
        this.log.info("Model " + this.diagram.getName() + ": simulation finished.");
        this.log.info("");
        if (this.simulator.getProfile().isStiff()) {
            return STIFF_PROBLEM;
        }
        if (this.simulator.getProfile().isUnstable()) {
            return UNSTABLE_PROBLEM;
        }
        return this.simulator.getProfile().getErrorMessage();
    }

    @Override
    public void stopSimulation() {
        if (this.modelType == 0 || this.modelType == 1) {
            this.log.info("Model " + this.diagram.getName() + ": simulation finished.");
            return;
        }
        super.stopSimulation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model createModel() throws Exception {
        try {
            if (TEMPLATE_NORMAL_ONLY.equals(this.getTemplateType())) {
                Model model = this.doGetModel();
                return model;
            }
            if (TEMPLATE_LARGE_ONLY.equals(this.getTemplateType())) {
                this.setLargeTemplate();
                JavaLargeModel model = (JavaLargeModel)this.doGetModel();
                model.setNameToIndex(this.getGlobalIndexMap());
                JavaLargeModel javaLargeModel = model;
                return javaLargeModel;
            }
            if (TEMPLATE_PARALLEL.equals(this.getTemplateType())) {
                this.setParallelTemplate();
                JavaLargeModel model = (JavaLargeModel)this.doGetModel();
                model.setNameToIndex(this.getGlobalIndexMap());
                JavaLargeModel javaLargeModel = model;
                return javaLargeModel;
            }
            if (this.isLarge(this.diagram)) {
                this.log.info("Model " + this.diagram.getName() + " is too large, Template for large models will be used.");
                this.setLargeTemplate();
                JavaLargeModel model = (JavaLargeModel)this.doGetModel();
                model.setNameToIndex(this.getGlobalIndexMap());
                JavaLargeModel javaLargeModel = model;
                return javaLargeModel;
            }
            Model model = this.doGetModel();
            return model;
        }
        catch (Exception ex) {
            this.log.error("Attempt to generate model failed: " + ExceptionRegistry.log((Throwable)ex));
            this.modelFile = null;
            Model model = null;
            return model;
        }
        finally {
            this.resetTemplate();
        }
    }

    public void setClassPath(String customPath) {
        this.customClassPath = customPath;
    }

    protected Model doGetModel() throws Exception {
        Object[] objs;
        File[] files = this.generateModel(false);
        if (this.model != null) {
            return this.model;
        }
        if (files == null) {
            throw new Exception("Model " + this.diagram.getName() + ": Error during code generation.");
        }
        Object[] objectArray = objs = this.customClassPath != null ? this.compileModel(files, this.customClassPath) : this.compileModel(files, true, this.outputDir);
        if (objs == null || objs.length == 0 || !(objs[0] instanceof Model)) {
            throw new Exception("Model " + this.diagram.getName() + ": Error during code compilation.");
        }
        return (Model)objs[0];
    }

    public void setLargeTemplate() {
        this.largeTemplate = true;
        this.velocityTemplate = null;
    }

    public void setParallelTemplate() {
        this.largeTemplate = true;
        this.parallel = true;
        this.velocityTemplate = null;
    }

    protected void resetTemplate() {
        this.largeTemplate = false;
        this.parallel = false;
        this.velocityTemplate = null;
    }

    protected InputStream getTemplateInputStream() {
        String templatePath = NORMAL_TEMPLATE;
        if (this.largeTemplate) {
            templatePath = this.parallel ? PARALLEL_LARGE_TEMPLATE : (this.hasDelays ? LARGE_DELAY_TEMPLATE : LARGE_TEMPLATE);
        }
        this.log.info("Generating code with template " + templatePath);
        return OdeSimulationEngine.class.getResourceAsStream(templatePath);
    }

    private void doGenerateModel() throws Exception {
        String name = this.executableModel.getDiagramElement().getName();
        File dir = new File(this.outputDir);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new Exception("Failed to create directory '" + this.outputDir + "'.");
        }
        this.modelFile = new File(dir, this.normalize(name) + ".java");
        if (this.velocityTemplate == null) {
            RuntimeServices runtimeServices = RuntimeSingleton.getRuntimeServices();
            SimpleNode node = runtimeServices.parse((Reader)new InputStreamReader(this.getTemplateInputStream()), "ODE template");
            this.velocityTemplate = new Template();
            this.velocityTemplate.setRuntimeServices(runtimeServices);
            this.velocityTemplate.setData((Object)node);
            this.velocityTemplate.initDocument();
            Velocity.init();
        }
        VelocityContext context = new VelocityContext();
        context.put("de", (Object)new SimulationEngineWrapper(this));
        String pattern = "yyyy.MM.dd HH:mm:ss";
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        String creationTime = format.format(date);
        context.put("creationTime", (Object)creationTime);
        try (BufferedWriter bw = ApplicationUtils.utfWriter((File)this.modelFile);){
            this.velocityTemplate.merge((Context)context, (Writer)bw);
        }
    }

    @Override
    @Nonnull
    public File[] generateModel(boolean forceRewrite) throws Exception {
        if (!this.diagramModified && !forceRewrite && this.modelFile != null) {
            return new File[]{this.modelFile};
        }
        this.restoreOriginalDiagram();
        this.setGenerateVariableAsArray(this.largeTemplate ? "array_on" : "array_off");
        this.init();
        this.hasDelays = (this.modelType & 4) != 0;
        this.log.info("Model " + this.diagram.getName() + ": Java code generating...");
        if (this.model == null) {
            this.doGenerateModel();
        }
        this.diagramModified = false;
        return new File[]{this.modelFile};
    }

    @Override
    public String generateVariableCodeName(int n) {
        return "x_values[" + n + "]";
    }

    @Override
    protected String getAsArrayName(int index) {
        return "var[" + index + "]";
    }

    public String createFunctionBody(String declarations, String result) {
        int splitIndex = result.lastIndexOf("return");
        return result.substring(0, splitIndex) + declarations + result.substring(splitIndex);
    }

    public String getCompartmentRoleName(Compartment compartment) {
        Role role = compartment.getRole();
        return role instanceof VariableRole ? ((VariableRole)role).getName() : "";
    }

    public boolean checkShouldBeFind(String variableName) {
        return this.isAlgebraic(variableName);
    }

    @Override
    public String normalize(String name) {
        name = super.normalize(name);
        while (javaKeywords.contains(name) || this.varNames.contains(name)) {
            name = name + "_";
        }
        return name;
    }

    @Override
    public boolean isForbidden(String name) {
        return javaKeywords.contains(name);
    }

    @Override
    public String normalizeFunction(String name) {
        while (javaKeywords.contains(name) || this.functionNames.contains(name)) {
            name = name + "_";
        }
        return name;
    }

    private boolean isLarge(Diagram diagram) {
        return diagram.getSize() > 1000;
    }

    @PropertyName(value="Fast reactions handling")
    @PropertyDescription(value="Method to handle fast reactions: either as separate ODE system with very fast rate or as algebraic system.")
    public String getFastReactions() {
        return this.fastReactions;
    }

    public void setFastReactions(String fastReactions) {
        this.diagramModified = true;
        this.fastReactions = fastReactions;
    }

    @PropertyName(value="Algebraic solver name")
    @PropertyDescription(value="Name of algebraic solver which will be used")
    public String getAlgebraicSolverName() {
        return this.algebraicSolverName;
    }

    public void setAlgebraicSolverName(String solverName) {
        String oldValue = this.algebraicSolverName;
        this.algebraicSolverName = solverName;
        switch (solverName) {
            case "LevenbergMarquard": {
                this.setAlgebraicSolver(new AeLevenbergMarquardSolver());
                break;
            }
            case "ConjugateGradient": {
                this.setAlgebraicSolver(new AeConjugateGradientSolver());
                break;
            }
            case "NelderMead": {
                this.setAlgebraicSolver(new AeNelderMeadSolver());
                break;
            }
            case "NewtonSolver": {
                this.setAlgebraicSolver(new NewtonSolverWrapperEx());
                break;
            }
            case "KinSolver": {
                this.setAlgebraicSolver(new KinSolverWrapper());
                break;
            }
        }
        this.firePropertyChange("algebraicSolverName", oldValue, solverName);
    }

    @PropertyName(value="Algebraic Solver parameters")
    @PropertyDescription(value="Parameters of algebraic solver which will be used")
    public AeSolver getAlgebraicSolver() {
        return this.algebraicSolver;
    }

    public void setAlgebraicSolver(AeSolver solver) {
        AeSolver oldValue = this.algebraicSolver;
        this.algebraicSolver = solver;
        this.firePropertyChange("algebraicSolver", oldValue, solver);
        this.firePropertyChange("*", null, null);
    }

    private Map<String, Integer> getGlobalIndexMap() {
        return ((EntryStream)EntryStream.of((Map)this.varNameMapping).filter(e -> ((String)e.getValue()).startsWith("var"))).mapValues(val -> Integer.parseInt(val.substring(4, val.length() - 1))).toMap();
    }

    public static String[] getTemplateMethods() {
        return new String[]{TEMPLATE_AUTO, TEMPLATE_NORMAL_ONLY, TEMPLATE_LARGE_ONLY, TEMPLATE_PARALLEL};
    }

    @PropertyName(value="Threads number")
    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public String[] getFloatingSpecies() {
        return (String[])this.varNameRateIndexMapping.keySet().stream().filter(n -> n.startsWith("$")).map(s -> {
            if ((s = s.substring(s.lastIndexOf(".") + 1)).startsWith("$")) {
                s = s.substring(1);
            }
            return s;
        }).toArray(String[]::new);
    }
}

