/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.java;

import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.ae.AeModel;
import biouml.plugins.simulation.ae.AeSolver;
import biouml.plugins.simulation.ae.NewtonSolverWrapper;
import biouml.plugins.simulation.ode.OdeModel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import one.util.streamex.EntryStream;

public abstract class JavaBaseModel
implements OdeModel,
AeModel {
    public boolean fastRegime;
    public double[] x_values;
    public double time;
    public static double pi = Math.PI;
    public static double exponentiale = Math.E;
    public static double avogadro = 6.02214179E23;
    public double[] initialValues;
    protected double CONSTRAINTS__VIOLATED = 0.0;
    protected AeSolver aeSolver = new NewtonSolverWrapper();
    protected List<double[]> simulationResultHistory = new ArrayList<double[]>();
    protected List<Double> simulationResultTimes = new ArrayList<Double>();
    protected boolean isInit = false;
    protected HashMap<Integer, DelayedEventPriorityQueue> delayedEvents = new HashMap();

    @Override
    public double[] dy_dt(double time, double[] x) throws Exception {
        return this.fastRegime ? this.dy_dt_fast(time, x) : this.dy_dt_slow(time, x);
    }

    public double[] dy_dt_slow(double time, double[] x) throws Exception {
        return null;
    }

    public double[] dy_dt_fast(double time, double[] x) throws Exception {
        return null;
    }

    @Override
    public double[] getY() {
        return this.x_values;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    public void setAeSolver(AeSolver aeSolver) {
        this.aeSolver = aeSolver;
    }

    @Override
    public double[] solveAlgebraic(double[] z) {
        return null;
    }

    @Override
    public double[] getConstraints() {
        return null;
    }

    @Override
    public double[] checkEvent(double time, double[] x) throws Exception {
        return new double[0];
    }

    @Override
    public void processEvent(int i) {
    }

    @Override
    public boolean getEventsInitialValue(int i) throws IndexOutOfBoundsException {
        return true;
    }

    @Override
    public boolean isEventTriggerPersistent(int i) throws IndexOutOfBoundsException {
        return true;
    }

    @Override
    public double[] getEventsPriority(double time, double[] x) throws Exception {
        return null;
    }

    @Override
    public double[] getPrehistory(double time) {
        return null;
    }

    @Override
    public double getPrehistory(double time, int i) {
        double[] result = this.getPrehistory(time);
        if (result != null && i < result.length - 1) {
            return result[i];
        }
        return 0.0;
    }

    @Override
    public double[] getCurrentHistory() {
        return null;
    }

    @Override
    public double[] extendResult(double time, double[] x) throws Exception {
        return x;
    }

    @Override
    public double[] getCurrentValues() throws Exception {
        return this.extendResult(this.time, this.x_values);
    }

    @Override
    public double[] getCurrentState() {
        return null;
    }

    @Override
    public void setCurrentValues(double[] values) throws Exception {
    }

    @Override
    public void updateHistory(double t) {
        double[] z = this.getCurrentHistory();
        if (z != null) {
            this.simulationResultHistory.add(z);
            this.simulationResultTimes.add(t);
        }
    }

    public void clear() {
        this.simulationResultHistory.clear();
        this.simulationResultTimes.clear();
    }

    public double[] getTimes() {
        double[] times = new double[this.simulationResultTimes.size()];
        for (int i = 0; i < times.length; ++i) {
            times[i] = this.simulationResultTimes.get(i);
        }
        return times;
    }

    public double[] getResults(double time) throws Exception {
        return EntryStream.zip(this.simulationResultTimes, this.simulationResultHistory).filterKeys(t -> t == time).values().findFirst().orElse(null);
    }

    private int firstPart(double t) {
        int i;
        for (i = this.simulationResultTimes.size() - 1; i >= 0 && !(t > this.simulationResultTimes.get(i)); --i) {
        }
        return i + 1;
    }

    private double interpolate(double t1, double t2, double x1, double x2, double t) {
        return (x2 - x1) / (t2 - t1) * (t - t1) + x1;
    }

    public double delay(int index, double t) {
        double t1;
        double x1;
        if (this.simulationResultTimes.size() == 0 || t < this.simulationResultTimes.get(0)) {
            return this.getPrehistory(t, index);
        }
        int i = this.firstPart(t);
        if (i == 0) {
            return this.simulationResultHistory.get(0)[index];
        }
        if (i == this.simulationResultHistory.size()) {
            x1 = this.getCurrentHistory()[index];
            t1 = this.time;
        } else {
            x1 = this.simulationResultHistory.get(i)[index];
            t1 = this.simulationResultTimes.get(i);
        }
        double x2 = this.simulationResultHistory.get(i - 1)[index];
        double t2 = this.simulationResultTimes.get(i - 1);
        return this.interpolate(t1, t2, x1, x2, t);
    }

    @Override
    public void init() throws Exception {
        this.simulationResultHistory.clear();
        this.simulationResultTimes.clear();
        this.CONSTRAINTS__VIOLATED = 0.0;
        this.initialValues = this.getInitialValues();
        this.isInit = true;
    }

    @Override
    public double[] getInitialValues() throws Exception {
        return this.initialValues;
    }

    @Override
    public void init(double[] initialValues, Map<String, Double> parameters) throws Exception {
        Field[] fields;
        this.initialValues = Arrays.copyOf(initialValues, initialValues.length);
        this.simulationResultHistory.clear();
        this.simulationResultTimes.clear();
        this.x_values = Arrays.copyOf(initialValues, initialValues.length);
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            String name = field.getName();
            double value = 0.0;
            boolean isChanged = false;
            if (parameters.containsKey(name)) {
                value = parameters.get(name);
                isChanged = true;
            } else if (name.startsWith("rate")) {
                isChanged = true;
            }
            if (!isChanged) continue;
            try {
                field.setDouble(this, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new Exception("Error during parameter " + name + "value setting to " + value);
            }
        }
        this.isInit = true;
    }

    @Override
    public boolean isInit() {
        return this.isInit;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    protected void addDelayedEvent(int i, double executionTime, double ... assignment) {
        DelayedEventPriorityQueue queue = this.delayedEvents.containsKey(i) ? this.delayedEvents.get(i) : new DelayedEventPriorityQueue();
        queue.add(new DelayedEvent(i, executionTime, assignment));
        this.delayedEvents.put(i, queue);
    }

    protected DelayedEvent getNextDelayedEvent(int i) {
        DelayedEventPriorityQueue queue = this.delayedEvents.get(i);
        return queue != null ? (DelayedEvent)queue.peek() : null;
    }

    protected Double getNextExecutionTime(int i) {
        DelayedEvent de = this.getNextDelayedEvent(i);
        return de != null ? de.executionTime : Double.POSITIVE_INFINITY;
    }

    protected double[] getNextAssignments(int i) {
        DelayedEvent de = this.getNextDelayedEvent(i);
        return de != null ? de.assignments : null;
    }

    protected void removeDelayedEvent(int i) {
        DelayedEventPriorityQueue queue = this.delayedEvents.get(i);
        if (queue != null) {
            queue.poll();
        }
    }

    @Override
    public String getEventMessage(int i) {
        return null;
    }

    @Override
    public Model clone() {
        try {
            JavaBaseModel result = (JavaBaseModel)super.clone();
            result.simulationResultHistory = new ArrayList<double[]>();
            for (double[] val : this.simulationResultHistory) {
                result.simulationResultHistory.add((double[])val.clone());
            }
            result.simulationResultTimes = new ArrayList<Double>(this.simulationResultTimes);
            return result;
        }
        catch (Exception ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public void setFastRegime(boolean fastRegime) {
        this.fastRegime = fastRegime;
    }

    public static double NUMERIC_AND(double a, double b) {
        return a != 0.0 && b != 0.0 ? 1.0 : 0.0;
    }

    public static double NUMERIC_OR(double a, double b) {
        return a != 0.0 || b != 0.0 ? 1.0 : 0.0;
    }

    public static double NUMERIC_NOT(double a) {
        return a == 0.0 ? 1.0 : 0.0;
    }

    public static double NUMERIC_XOR(double a, double b) {
        return a != 0.0 ^ b != 0.0 ? 1.0 : 0.0;
    }

    public static double implies(double a, double b) {
        return b != 0.0 || a == 0.0 ? 1.0 : 0.0;
    }

    public static double NUMERIC_LT(double a, double b) {
        return a < b ? 1.0 : 0.0;
    }

    public static double NUMERIC_GT(double a, double b) {
        return a > b ? 1.0 : 0.0;
    }

    public static double NUMERIC_EQ(double a, double b) {
        return a == b ? 1.0 : 0.0;
    }

    public static double NUMERIC_LEQ(double a, double b) {
        return a <= b ? 1.0 : 0.0;
    }

    public static double NUMERIC_GEQ(double a, double b) {
        return a >= b ? 1.0 : 0.0;
    }

    public static double NUMERIC_NEQ(double a, double b) {
        return a != b ? 1.0 : 0.0;
    }

    protected static double max(double ... args) {
        double result = args[0];
        for (int i = 1; i < args.length; ++i) {
            result = Math.max(result, args[i]);
        }
        return result;
    }

    protected static double min(double ... args) {
        double result = args[0];
        for (int i = 1; i < args.length; ++i) {
            result = Math.min(result, args[i]);
        }
        return result;
    }

    @Override
    public boolean isConstraintViolated() {
        return this.CONSTRAINTS__VIOLATED != 0.0;
    }

    @Override
    public boolean hasFastOde() {
        return false;
    }

    public double getInitialValue(int i) {
        return this.initialValues[i];
    }

    public static class DelayedEventPriorityQueue
    extends PriorityQueue<DelayedEvent> {
    }

    protected static class DelayedEvent
    implements Comparable<DelayedEvent> {
        public Double executionTime;
        public double[] assignments;
        public int eventIndex;

        protected DelayedEvent(int eventIndex, double executionTime, double ... assignments) {
            this.executionTime = executionTime;
            this.assignments = assignments;
            this.eventIndex = eventIndex;
        }

        @Override
        public int compareTo(DelayedEvent o) {
            return this.executionTime.compareTo(o.executionTime);
        }
    }
}

