/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.java;

import biouml.plugins.simulation.ArraySpan;
import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.Options;
import biouml.plugins.simulation.Simulator;
import biouml.plugins.simulation.SimulatorInfo;
import biouml.plugins.simulation.SimulatorProfile;
import biouml.plugins.simulation.SimulatorSupport;
import biouml.plugins.simulation.Span;
import biouml.plugins.simulation.java.JavaBaseModel;
import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.jvode.JVodeSolver;
import biouml.standard.simulation.ResultListener;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import one.util.streamex.IntStreamEx;
import ru.biosoft.jobcontrol.FunctionJobControl;

public class EventLoopSimulator
extends SimulatorSupport {
    private SimulatorSupport solver = new JVodeSolver();
    private boolean modelHasEvents = true;
    private double curTime;
    private double restTime;
    private double[] x;
    private Uniform uniform = new Uniform((RandomEngine)new MersenneTwister(new Date()));

    public EventLoopSimulator() {
    }

    public EventLoopSimulator(SimulatorSupport solver) {
        this.setSolver(solver);
    }

    public Simulator getSolver() {
        return this.solver;
    }

    public void setSolver(Simulator solver) {
        this.solver = (SimulatorSupport)solver;
    }

    @Override
    public SimulatorInfo getInfo() {
        return this.solver.getInfo();
    }

    @Override
    public void setStatisticsMode(String mode) {
        this.solver.setStatisticsMode(mode);
        this.statisticsMode = mode;
    }

    @Override
    public void setFireInitialValues(boolean val) {
        this.solver.setFireInitialValues(val);
        this.fireInitialValues = val;
    }

    @Override
    public SimulatorProfile getProfile() {
        return this.solver.getProfile();
    }

    @Override
    public Object getDefaultOptions() {
        return this.solver.getDefaultOptions();
    }

    @Override
    public Options getOptions() {
        return this.solver.getOptions();
    }

    @Override
    public void setOptions(Options options) {
        this.solver.setOptions(options);
    }

    @Override
    public int[] getEvents() {
        return this.solver.getEvents();
    }

    @Override
    public void stop() {
        this.terminated = true;
        this.solver.stop();
    }

    @Override
    public void init(Model model, double[] initialValues, Span tspan, ResultListener[] listeners, FunctionJobControl jobControl) throws Exception {
        this.jobControl = jobControl;
        this.odeModel = (OdeModel)model;
        if (!this.odeModel.isInit()) {
            this.odeModel.init();
        }
        this.span = tspan;
        this.resultListeners = listeners;
        this.curTime = this.span.getTimeStart();
        this.restTime = this.span.getTimeFinal() - this.span.getTimeStart();
        this.x = Arrays.copyOf(initialValues, initialValues.length);
        this.solver.init(model, initialValues, tspan, listeners, jobControl);
        this.solver.setFireInitialValues(true);
        this.checkInitialEvents(this.span.getTimeStart(), initialValues);
    }

    @Override
    public void start(Model model, double[] initialValues, Span timeSpan, ResultListener[] listeners, FunctionJobControl jobControl) throws Exception {
        this.setStarted();
        super.start(model, initialValues, timeSpan, listeners, jobControl);
    }

    @Override
    public boolean doStep() throws Exception {
        boolean flag = this.solver.doStep();
        if (this.terminated || this.jobControl != null && this.jobControl.getStatus() == 4) {
            return false;
        }
        if (!this.modelHasEvents) {
            return flag;
        }
        this.profile = this.getProfile();
        if (this.profile.isUnstable() || this.profile.isStiff()) {
            return false;
        }
        System.arraycopy(this.profile.getX(), 0, this.x, 0, this.x.length);
        this.curTime = this.profile.getTime();
        this.span = this.solver.getSpan();
        this.restTime = this.span.getTimeFinal() - this.curTime;
        if (this.restTime <= 0.0) {
            return false;
        }
        int[] triggeredEvents = this.solver.getEvents();
        if (triggeredEvents != null) {
            ArrayList<Integer> pendingEvents = new ArrayList<Integer>();
            for (int i = 0; i < triggeredEvents.length; ++i) {
                if (triggeredEvents[i] != 1) continue;
                pendingEvents.add(i);
            }
            if (!pendingEvents.isEmpty()) {
                this.executeEvents(pendingEvents);
                this.recalculateSpan();
                this.solver.init(this.odeModel, this.x, this.span, this.resultListeners, this.jobControl);
                this.odeModel.updateHistory(this.curTime);
                this.solver.setFireInitialValues(false);
                this.solver.getProfile().setX(this.x);
            }
            if (this.odeModel.isConstraintViolated()) {
                log.info("Constraints were violated, simulation halted");
                return false;
            }
        }
        return this.restTime > 0.0;
    }

    private void recalculateSpan() {
        Span newSpan = this.span.getRestrictedSpan(this.curTime, this.span.getTimeFinal());
        this.span = newSpan != null ? newSpan : new ArraySpan(this.curTime, this.span.getTimeFinal());
    }

    private void checkInitialEvents(double t, double[] x) throws Exception {
        double[] initialEvents = this.odeModel.checkEvent(t, x);
        if (initialEvents == null || initialEvents.length == 0) {
            this.modelHasEvents = false;
            return;
        }
        this.modelHasEvents = true;
        ArrayList<Integer> pendingEvents = new ArrayList<Integer>();
        for (int i = 0; i < initialEvents.length; ++i) {
            if (initialEvents[i] != 1.0 || this.odeModel.getEventsInitialValue(i)) continue;
            pendingEvents.add(i);
        }
        if (!pendingEvents.isEmpty()) {
            this.executeEvents(pendingEvents);
            this.solver.init(this.odeModel, this.x, this.span, this.resultListeners, this.jobControl);
            this.solver.getProfile().setX(this.x);
        }
    }

    private void executeEvents(List<Integer> pendingEvents) throws Exception {
        ArrayList<Integer> switchedOffEvents = new ArrayList<Integer>();
        while (!pendingEvents.isEmpty()) {
            double[] eventsBeforeFiring = this.odeModel.checkEvent(this.curTime, this.x);
            this.outStatistics("Triggered events: " + IntStreamEx.of(pendingEvents).joining((CharSequence)","));
            Integer eventToFire = this.chooseEvent(pendingEvents);
            this.outStatistics("Fire event: " + eventToFire);
            this.odeModel.processEvent(eventToFire);
            String message = this.odeModel.getEventMessage(eventToFire);
            if (message != null) {
                log.info("At time " + this.curTime + " : " + message);
            }
            if (this.odeModel.isConstraintViolated()) {
                return;
            }
            double[] eventsAfterFiring = this.odeModel.checkEvent(this.curTime, this.x);
            switchedOffEvents.clear();
            for (int i = 0; i < eventsAfterFiring.length; ++i) {
                if (!this.odeModel.isEventTriggerPersistent(i) && eventsAfterFiring[i] < eventsBeforeFiring[i]) {
                    this.outStatistics("Event was switched off: " + i);
                    switchedOffEvents.add(i);
                    continue;
                }
                if (!(eventsAfterFiring[i] > eventsBeforeFiring[i])) continue;
                this.outStatistics("Event was switched on: " + i);
                pendingEvents.add(i);
            }
            for (Integer switchedOff : switchedOffEvents) {
                ((JavaBaseModel)this.odeModel).removeDelayedEvent(switchedOff);
            }
            pendingEvents.removeAll(switchedOffEvents);
            pendingEvents.remove(eventToFire);
        }
    }

    private Integer chooseEvent(List<Integer> pendingEvents) throws Exception {
        double[] priorities = this.odeModel.getEventsPriority(this.curTime, this.x);
        if (priorities == null) {
            return pendingEvents.get(0);
        }
        double maxVal = Double.NEGATIVE_INFINITY;
        for (int i : pendingEvents) {
            maxVal = Math.max(maxVal, priorities[i]);
        }
        HashSet<Integer> candidadeEvents = new HashSet<Integer>();
        for (int i : pendingEvents) {
            if (priorities[i] != maxVal) continue;
            candidadeEvents.add(i);
        }
        return this.getRandom(candidadeEvents);
    }

    private Integer getRandom(HashSet<Integer> objects) {
        int size = objects.size();
        Object[] array = objects.toArray(new Integer[size]);
        if (size == 1) {
            return array[0];
        }
        Arrays.sort(array);
        int index = this.uniform.nextIntFromTo(0, objects.size() - 1);
        return array[index];
    }

    @Override
    public void setInitialValues(double[] x0) throws Exception {
        if (!this.modelHasEvents) {
            this.solver.setInitialValues(x0);
            this.x = (double[])this.odeModel.getY().clone();
            return;
        }
        double[] before = this.odeModel.checkEvent(this.curTime, this.x);
        this.solver.setInitialValues(x0);
        this.x = (double[])this.odeModel.getY().clone();
        double[] after = this.odeModel.checkEvent(this.curTime, this.x);
        this.executeEvents(this.curTime, before, this.curTime, after);
    }

    private void executeEvents(double t1, double[] e1, double t2, double[] e2) throws Exception {
        ArrayList<Integer> pendingEvents = new ArrayList<Integer>();
        for (int i = 0; i < e1.length; ++i) {
            if (e2[i] != 1.0 || e1[i] == 1.0) continue;
            pendingEvents.add(i);
        }
        if (!pendingEvents.isEmpty()) {
            this.executeEvents(pendingEvents);
            this.recalculateSpan();
            this.solver.init(this.odeModel, this.x, this.span, this.resultListeners, this.jobControl);
            this.odeModel.updateHistory(this.curTime);
            this.solver.setFireInitialValues(false);
            this.solver.getProfile().setX(this.x);
        }
    }

    @Override
    public void setStarted() {
        this.solver.setStarted();
        this.terminated = false;
    }

    @Override
    public void setPresimulateFastReactions(boolean preprocess) {
        super.setPresimulateFastReactions(preprocess);
        this.solver.setPresimulateFastReactions(preprocess);
    }
}

