/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.document;

import biouml.model.Diagram;
import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.document.InteractiveSimulation;
import biouml.plugins.simulation.document.MessageBundle;
import biouml.standard.diagram.DiagramUtility;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.action.ActionInitializer;
import com.developmentontheedge.application.action.ActionManager;
import com.developmentontheedge.beans.swing.PropertyInspectorEx;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.EditorPartSupport;

public class SimulationOptionsEditorPart
extends EditorPartSupport {
    private final PropertyInspectorEx inspector = new PropertyInspectorEx();
    private InteractiveSimulation simulation;
    private RecompileAction recompileAction;
    private SaveEngineAction saveAction;
    private RunSimulationAction runSimulationAction;

    public boolean canExplore(Object model) {
        return model instanceof InteractiveSimulation;
    }

    public JComponent getView() {
        return this.inspector;
    }

    public void explore(Object model, Document document) {
        this.model = model;
        this.document = document;
        this.simulation = (InteractiveSimulation)((Object)model);
        this.inspector.explore((Object)this.simulation.getEngine());
    }

    public Action[] getActions() {
        ActionManager actionManager = Application.getActionManager();
        if (this.recompileAction == null) {
            this.recompileAction = new RecompileAction();
            actionManager.addAction("Recompile model", (Action)this.recompileAction);
            new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.recompileAction, "Recompile model");
            this.recompileAction.setEnabled(true);
        }
        if (this.saveAction == null) {
            this.saveAction = new SaveEngineAction();
            actionManager.addAction("Save engine", (Action)this.saveAction);
            new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.saveAction, "Save engine");
            this.saveAction.setEnabled(true);
        }
        if (this.runSimulationAction == null) {
            this.runSimulationAction = new RunSimulationAction();
            actionManager.addAction("Run simulation", (Action)this.runSimulationAction);
            new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.runSimulationAction, "Run simulation");
            this.runSimulationAction.setEnabled(true);
        }
        return new Action[]{this.recompileAction, this.runSimulationAction, this.saveAction};
    }

    public class SaveEngineAction
    extends AbstractAction {
        public static final String KEY = "Save engine";

        public SaveEngineAction() {
            super(KEY);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Diagram diagram = SimulationOptionsEditorPart.this.simulation.getDiagram();
                DiagramUtility.setPreferredEngine((Diagram)diagram, (SimulationEngine)SimulationOptionsEditorPart.this.simulation.getEngine());
                diagram.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class RunSimulationAction
    extends AbstractAction {
        public static final String KEY = "Run simulation";

        public RunSimulationAction() {
            super(KEY);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimulationOptionsEditorPart.this.simulation.updateValues();
            this.setEnabled(false);
            SimulationOptionsEditorPart.this.simulation.doSimulation();
            this.setEnabled(true);
        }
    }

    public class RecompileAction
    extends AbstractAction {
        public static final String KEY = "Recompile model";

        public RecompileAction() {
            super(KEY);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                SimulationOptionsEditorPart.this.simulation.recompile();
            }
            catch (Exception ex) {
                throw ExceptionRegistry.translateException((Throwable)ex);
            }
        }
    }
}

