/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.document;

import biouml.model.dynamics.plot.Curve;
import biouml.model.dynamics.plot.PlotInfo;
import biouml.plugins.simulation.ResultPlotPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.AbstractSeriesDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class SimplePlotPane
extends JPanel {
    protected static final Logger log = Logger.getLogger(SimplePlotPane.class.getName());
    protected JFreeChart chart;
    private PlotInfo plotInfo;
    private String xVariable;

    public SimplePlotPane(int ix, int iy, PlotInfo plotInfo, double timeLimit) {
        super(new BorderLayout());
        try {
            this.chart = ChartFactory.createXYLineChart((String)"", (String)"Axis (X)", (String)"Axis (Y)", null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            this.plotInfo = plotInfo;
            this.xVariable = this.plotInfo.getXVariable().getName();
            this.chart.getXYPlot().setBackgroundPaint((Paint)Color.white);
            this.chart.setBackgroundPaint((Paint)Color.white);
            XYSeriesCollection dataset = new XYSeriesCollection();
            this.chart.getXYPlot().setDataset((XYDataset)dataset);
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            renderer.setDrawSeriesLineAsPath(true);
            ChartPanel chartPanel = new ChartPanel(this.chart);
            chartPanel.setPreferredSize(new Dimension(ix, iy));
            this.add((Component)chartPanel);
            if (plotInfo.getExperiments() != null) {
                ResultPlotPane.addExperiments(plotInfo.getExperiments(), renderer, (AbstractSeriesDataset)dataset, timeLimit);
            }
            int counter = this.chart.getXYPlot().getDataset().getSeriesCount();
            for (Curve c : plotInfo.getYVariables()) {
                renderer.setSeriesPaint(counter, (Paint)c.getPen().getColor());
                renderer.setSeriesStroke(counter, (Stroke)c.getPen().getStroke());
                renderer.setSeriesShapesVisible(counter, false);
                renderer.setSeriesLinesVisible(counter, true);
                renderer.setSeriesShape(counter, null);
                dataset.addSeries(new XYSeries((Comparable)((Object)c.getCompleteName()), false, true));
                ++counter;
            }
            this.chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error occured while creating chart panel: " + ex);
        }
    }

    public void redrawChart(Map<String, double[]> values) {
        double[] x = values.get(this.xVariable);
        XYSeriesCollection xyDataset = (XYSeriesCollection)this.chart.getXYPlot().getDataset();
        for (Curve c : this.plotInfo.getYVariables()) {
            double[] y = values.get(c.getCompleteName());
            XYSeries series = xyDataset.getSeries((Comparable)((Object)c.getCompleteName()));
            series.clear();
            for (int i = 0; i < x.length; ++i) {
                series.add(x[i], y[i]);
            }
        }
    }
}

