/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.document;

import biouml.model.Diagram;
import biouml.model.dynamics.plot.PlotsInfo;
import biouml.plugins.simulation.document.InteractiveSimulation;
import biouml.plugins.simulation.document.MessageBundle;
import biouml.standard.diagram.DiagramUtility;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.action.ActionInitializer;
import com.developmentontheedge.application.action.ActionManager;
import com.developmentontheedge.beans.swing.PropertyInspectorEx;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.EditorPartSupport;

public class PlotsEditorPart
extends EditorPartSupport {
    public static final String PLOTS = "Variables to plot";
    private final PropertyInspectorEx inspector = new PropertyInspectorEx();
    private InteractiveSimulation simulation;
    private UpdatePlotAction updateAction;
    private SavePlotAction saveAction;
    private RunSimulationAction runSimulationAction;

    public boolean canExplore(Object model) {
        return model instanceof InteractiveSimulation;
    }

    public JComponent getView() {
        return this.inspector;
    }

    public void explore(Object model, Document document) {
        this.model = model;
        this.document = document;
        this.simulation = (InteractiveSimulation)((Object)model);
        this.inspector.explore((Object)this.simulation.getPlots());
    }

    public Action[] getActions() {
        ActionManager actionManager = Application.getActionManager();
        if (this.updateAction == null) {
            this.updateAction = new UpdatePlotAction();
            actionManager.addAction("Update plot", (Action)this.updateAction);
            new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.updateAction, "Update plot");
            this.updateAction.setEnabled(true);
        }
        if (this.saveAction == null) {
            this.saveAction = new SavePlotAction();
            actionManager.addAction("Save plot", (Action)this.saveAction);
            new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.saveAction, "Save plot");
            this.saveAction.setEnabled(true);
        }
        if (this.runSimulationAction == null) {
            this.runSimulationAction = new RunSimulationAction();
            actionManager.addAction("Run simulation", (Action)this.runSimulationAction);
            new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.runSimulationAction, "Run simulation");
            this.runSimulationAction.setEnabled(true);
        }
        return new Action[]{this.updateAction, this.saveAction, this.runSimulationAction};
    }

    public class RunSimulationAction
    extends AbstractAction {
        public static final String KEY = "Run simulation";

        public RunSimulationAction() {
            super(KEY);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlotsEditorPart.this.simulation.updateValues();
            this.setEnabled(false);
            PlotsEditorPart.this.simulation.doSimulation();
            this.setEnabled(true);
        }
    }

    public class UpdatePlotAction
    extends AbstractAction {
        public static final String KEY = "Update plot";

        public UpdatePlotAction() {
            super(KEY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlotsEditorPart.this.simulation.updatePlots();
        }
    }

    public class SavePlotAction
    extends AbstractAction {
        public static final String KEY = "Save plot";

        public SavePlotAction() {
            super(KEY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Diagram diagram = PlotsEditorPart.this.simulation.getDiagram();
                DiagramUtility.setPlotsInfo((Diagram)diagram, (PlotsInfo)PlotsEditorPart.this.simulation.getPlots());
                diagram.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

