/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.document;

import biouml.plugins.simulation.document.InputParameter;
import biouml.plugins.simulation.document.InteractiveSimulation;
import biouml.plugins.simulation.document.MessageBundle;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.action.ActionInitializer;
import com.developmentontheedge.application.action.ActionManager;
import com.developmentontheedge.beans.swing.table.RowModel;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import ru.biosoft.access.support.DataCollectionRowModelAdapter;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.TabularPropertiesEditor;

public class ParametersEditorPart
extends TabularPropertiesEditor {
    protected Object template = new InputParameter("parameters", "parameters", "type", 0.0);
    private static final Logger log = Logger.getLogger(ParametersEditorPart.class.getName());
    private InteractiveSimulation simulation;
    protected IncreaseParameterAction increaseParameterAction;
    protected DecreaseParameterAction decreaseParameterAction;
    protected RunSimulationAction runSimulationAction;
    protected SaveParametersAction saveToDiagramAction;
    protected ResetParametersAction resetParametersAction;

    public boolean canExplore(Object model) {
        return model instanceof InteractiveSimulation;
    }

    public void explore(Object model, Document document) {
        this.model = model;
        this.simulation = (InteractiveSimulation)((Object)model);
        this.document = document;
        try {
            this.setDefaultNumberFormat(null);
            this.explore(this.getRowModel(), this.template, 0);
            this.getTable().setAutoResizeMode(4);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Can not explore Simulation, error: " + ex.getMessage(), ex);
            this.explore(null);
        }
    }

    protected RowModel getRowModel() {
        return new DataCollectionRowModelAdapter(this.simulation.getInputParameters());
    }

    public Action[] getActions() {
        ActionManager actionManager = Application.getActionManager();
        if (this.increaseParameterAction == null) {
            this.increaseParameterAction = new IncreaseParameterAction();
            actionManager.addAction("Increase parameters value", (Action)this.increaseParameterAction);
            new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.increaseParameterAction, "Increase parameters value");
            this.increaseParameterAction.setEnabled(true);
        }
        if (this.decreaseParameterAction == null) {
            this.decreaseParameterAction = new DecreaseParameterAction();
            actionManager.addAction("Decrease parameters value", (Action)this.decreaseParameterAction);
            new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.decreaseParameterAction, "Decrease parameters value");
            this.decreaseParameterAction.setEnabled(true);
        }
        if (this.runSimulationAction == null) {
            this.runSimulationAction = new RunSimulationAction();
            actionManager.addAction("Run simulation", (Action)this.runSimulationAction);
            new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.runSimulationAction, "Run simulation");
            this.runSimulationAction.setEnabled(true);
        }
        if (this.resetParametersAction == null) {
            this.resetParametersAction = new ResetParametersAction();
            actionManager.addAction("Reset parameters", (Action)this.resetParametersAction);
            new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.resetParametersAction, "Reset parameters");
            this.resetParametersAction.setEnabled(true);
        }
        if (this.saveToDiagramAction == null) {
            this.saveToDiagramAction = new SaveParametersAction();
            actionManager.addAction("Save parameters", (Action)this.saveToDiagramAction);
            new ActionInitializer(new Class[]{MessageBundle.class}).initAction((Action)this.saveToDiagramAction, "Save parameters");
            this.saveToDiagramAction.setEnabled(true);
        }
        return new Action[]{this.resetParametersAction, this.increaseParameterAction, this.decreaseParameterAction, this.runSimulationAction, this.saveToDiagramAction};
    }

    private void simulate() {
        this.setSimulationActions(false);
        this.simulation.doSimulation();
        this.setSimulationActions(true);
    }

    private void setSimulationActions(boolean enabled) {
        this.resetParametersAction.setEnabled(enabled);
        this.runSimulationAction.setEnabled(enabled);
        this.increaseParameterAction.setEnabled(enabled);
        this.decreaseParameterAction.setEnabled(enabled);
    }

    private int getSelectedRow() {
        JTable table = this.getTable();
        int[] rows = table.getSelectedRows();
        if (rows.length == 0) {
            return -1;
        }
        return rows[0];
    }

    private InputParameter getParameter(int row) {
        return (InputParameter)this.getModelForRow(row);
    }

    private void updateRow(int row) {
        this.table.tableChanged(new TableModelEvent((TableModel)this.tableModel, row));
    }

    private void updateTable() {
        this.table.tableChanged(new TableModelEvent((TableModel)this.tableModel));
    }

    public class SaveParametersAction
    extends AbstractAction {
        public static final String KEY = "Save parameters";

        public SaveParametersAction() {
            super(KEY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ParametersEditorPart.this.simulation.saveParametersToDiagram();
            ParametersEditorPart.this.updateTable();
        }
    }

    public class ResetParametersAction
    extends AbstractAction {
        public static final String KEY = "Reset parameters";

        public ResetParametersAction() {
            super(KEY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = ParametersEditorPart.this.getSelectedRow();
            if (row == -1) {
                ParametersEditorPart.this.simulation.resetParameters();
                ParametersEditorPart.this.updateTable();
            } else {
                InputParameter selected = ParametersEditorPart.this.getParameter(row);
                ParametersEditorPart.this.updateRow(row);
                ParametersEditorPart.this.simulation.resetParameter(selected);
            }
            ParametersEditorPart.this.simulate();
        }
    }

    public class RunSimulationAction
    extends AbstractAction {
        public static final String KEY = "Run simulation";

        public RunSimulationAction() {
            super(KEY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ParametersEditorPart.this.simulation.updateValues();
            ParametersEditorPart.this.simulate();
        }
    }

    public class DecreaseParameterAction
    extends AbstractAction {
        public static final String KEY = "Decrease parameters value";

        public DecreaseParameterAction() {
            super(KEY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = ParametersEditorPart.this.getSelectedRow();
            if (row == -1) {
                return;
            }
            InputParameter selected = ParametersEditorPart.this.getParameter(row);
            selected.setValue(selected.getValue() - selected.getValueStep());
            ParametersEditorPart.this.updateRow(row);
            ParametersEditorPart.this.simulation.updateValue(selected);
            ParametersEditorPart.this.simulate();
        }
    }

    public class IncreaseParameterAction
    extends AbstractAction {
        public static final String KEY = "Increase parameters value";

        public IncreaseParameterAction() {
            super(KEY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = ParametersEditorPart.this.getSelectedRow();
            if (row == -1) {
                return;
            }
            InputParameter selected = ParametersEditorPart.this.getParameter(row);
            selected.setValue(selected.getValue() + selected.getValueStep());
            ParametersEditorPart.this.updateRow(row);
            ParametersEditorPart.this.simulation.updateValue(selected);
            ParametersEditorPart.this.simulate();
        }
    }
}

