/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.document;

import biouml.model.dynamics.plot.Curve;
import biouml.model.dynamics.plot.PlotInfo;
import biouml.model.dynamics.plot.PlotVariable;
import biouml.model.dynamics.plot.PlotsInfo;
import biouml.plugins.simulation.document.InteractiveSimulation;
import biouml.plugins.simulation.document.SimplePlotPane;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import javax.swing.JTabbedPane;
import ru.biosoft.access.core.ClassIcon;
import ru.biosoft.graphics.editor.ViewPane;
import ru.biosoft.gui.Document;

@ClassIcon(value="resources/simulationDocument.gif")
public class InteractiveSimulationDocument
extends Document
implements PropertyChangeListener {
    private final JTabbedPane tabbedPane;
    private InteractiveSimulation simulation;

    public InteractiveSimulationDocument(InteractiveSimulation simulation) throws IllegalArgumentException {
        super((Object)simulation);
        this.viewPane = new ViewPane();
        this.simulation = simulation;
        simulation.doc = this;
        this.tabbedPane = new JTabbedPane();
        this.updatePlots();
        simulation.addPropertyChangeListener(this);
        simulation.doSimulation();
    }

    public void updatePlots() {
        PlotsInfo plotsInfo = this.simulation.getPlots();
        if (plotsInfo == null) {
            throw new IllegalArgumentException("No plots specified for diagram. Can not create document!");
        }
        PlotInfo[] plotInfos = plotsInfo.getActivePlots();
        if (plotInfos.length == 0) {
            throw new IllegalArgumentException("No plots specified for diagram. Can not create document!");
        }
        HashSet<String> names = new HashSet<String>();
        this.tabbedPane.removeAll();
        for (PlotInfo plotInfo : plotInfos) {
            this.tabbedPane.addTab(plotInfo.getTitle(), new SimplePlotPane(700, 500, plotInfo, this.simulation.getEngine().getCompletionTime()));
            for (Curve c : plotInfo.getYVariables()) {
                names.add(c.getCompleteName());
            }
            PlotVariable xVar = plotInfo.getXVariable();
            names.add(xVar.getCompleteName());
        }
        this.simulation.setOutputNames(names);
        this.viewPane.add((Component)this.tabbedPane);
        if (this.simulation.getResult() != null) {
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                ((SimplePlotPane)this.tabbedPane.getComponentAt(i)).redrawChart(this.simulation.getResult());
            }
        }
    }

    public String getDisplayName() {
        return "Simulation: " + this.simulation.getDiagram().getName();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            ((SimplePlotPane)this.tabbedPane.getComponentAt(i)).redrawChart(this.simulation.getResult());
        }
    }
}

