/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.document;

import biouml.model.Diagram;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.plot.PlotsInfo;
import biouml.plugins.simulation.ArraySpan;
import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.document.InputParameter;
import biouml.plugins.simulation.document.InteractiveSimulationDocument;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.simulation.ResultListener;
import biouml.standard.type.BaseSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.VectorDataCollection;

public class InteractiveSimulation
extends BaseSupport
implements ResultListener {
    private Diagram diagram;
    private VectorDataCollection<InputParameter> inputParameters = new VectorDataCollection("inputParameters");
    private SimulationEngine engine;
    private Model model;
    private Map<String, Integer> parameterMapping;
    private double[] inputValues;
    private Set<String> outputNames;
    private Map<String, double[]> simulatedValues;
    private int spanLength;
    private int spanIndex;
    public InteractiveSimulationDocument doc;
    private static final Logger log = Logger.getLogger(InteractiveSimulation.class.getName());
    private double[] x;
    private PlotsInfo plots;

    public InteractiveSimulation(DataCollection parent, String name, Diagram diagram) throws Exception {
        super(parent, name);
        this.engine = DiagramUtility.getEngine((Diagram)diagram);
        this.engine = this.engine.clone();
        this.engine.setDiagram(diagram);
        this.engine.setLogLevel(Level.SEVERE);
        EModel emodel = (EModel)diagram.getRole(EModel.class);
        emodel.detectVariableTypes();
        for (Variable var : emodel.getVariables()) {
            if (var.getName().startsWith("$$") || var.getType().equals("Calculated")) continue;
            this.inputParameters.put((DataElement)new InputParameter(var.getName(), var.getTitle(), var.getType(), var.getInitialValue()));
        }
        this.diagram = diagram;
        this.plots = DiagramUtility.getPlotsInfo((Diagram)diagram).clone(emodel);
        if (this.plots == null) {
            this.plots = new PlotsInfo(emodel);
        }
        this.model = this.engine.createModel();
        this.model.init();
        this.inputValues = this.model.getCurrentValues();
        this.parameterMapping = this.engine.getVarPathIndexMapping();
    }

    public void doSimulation() {
        this.updateSpan();
        try {
            if (this.model == null) {
                this.model = this.engine.createModel();
            }
            this.model.init();
            this.model.setCurrentValues(this.inputValues);
            this.engine.simulate(this.model, new ResultListener[]{this});
            this.doc.propertyChange(null);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error during simulation " + ex.getMessage(), ex);
        }
    }

    public void updateValue(InputParameter parameter) {
        int index = this.parameterMapping.get(parameter.getName());
        this.inputValues[index] = parameter.getValue();
    }

    public void updateValues() {
        for (InputParameter p : this.inputParameters) {
            if (!this.parameterMapping.containsKey(p.getName())) continue;
            int index = this.parameterMapping.get(p.getName());
            this.inputValues[index] = p.getValue();
        }
    }

    public DataCollection<InputParameter> getInputParameters() {
        return this.inputParameters;
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public SimulationEngine getEngine() {
        return this.engine;
    }

    public void start(Object model) {
        this.simulatedValues = new HashMap<String, double[]>();
        for (String name : this.outputNames) {
            this.simulatedValues.put(name, new double[this.spanLength]);
        }
        this.simulatedValues.put("time", this.x);
        this.spanIndex = 0;
    }

    public void add(double t, double[] y) throws Exception {
        for (String name : this.outputNames) {
            int index = this.parameterMapping.get(name);
            this.simulatedValues.get((Object)name)[this.spanIndex] = y[index];
        }
        ++this.spanIndex;
    }

    public void setOutputNames(Set<String> names) {
        this.outputNames = names;
    }

    public Map<String, double[]> getResult() {
        return this.simulatedValues;
    }

    public PlotsInfo getPlots() {
        return this.plots;
    }

    public void saveParametersToDiagram() {
        EModel emodel = (EModel)this.diagram.getRole(EModel.class);
        for (InputParameter parameter : this.inputParameters) {
            Variable var = emodel.getVariable(parameter.getName());
            if (var == null) {
                log.info("Can not find variable " + parameter.getName() + " in diagram " + this.diagram.getName());
            } else {
                var.setInitialValue(parameter.getValue());
            }
            parameter.setDefaultValue(parameter.getValue());
        }
        try {
            this.diagram.save();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error during diagram saving " + ex.getMessage(), ex);
        }
    }

    public void resetParameters() {
        EModel emodel = (EModel)this.diagram.getRole(EModel.class);
        for (InputParameter inputParameter : this.inputParameters) {
            Variable var = emodel.getVariable(inputParameter.getName());
            double value = var.getInitialValue();
            inputParameter.setValue(value);
            inputParameter.setValueStep(value / 10.0);
            int index = this.parameterMapping.get(inputParameter.getName());
            this.inputValues[index] = inputParameter.getValue();
        }
    }

    public void resetParameter(InputParameter parameter) {
        EModel emodel = (EModel)this.diagram.getRole(EModel.class);
        Variable var = emodel.getVariable(parameter.getName());
        double value = var.getInitialValue();
        parameter.setValue(value);
        parameter.setValueStep(value / 10.0);
        int index = this.parameterMapping.get(parameter.getName());
        this.inputValues[index] = parameter.getValue();
    }

    public InputParameter getParameter(String parameterName) {
        return (InputParameter)this.inputParameters.get(parameterName);
    }

    public void updatePlots() {
        this.doc.updatePlots();
    }

    public void updateSpan() {
        ArraySpan span = new ArraySpan(0.0, this.engine.getCompletionTime(), this.engine.getTimeIncrement());
        this.spanLength = span.getLength();
        this.x = span.getTimes();
    }

    public void recompile() throws Exception {
        this.diagram = (Diagram)this.diagram.getCompletePath().getDataElement(Diagram.class);
        this.model = this.engine.createModel();
        this.model.init();
        this.inputParameters = new VectorDataCollection("inputParameters");
        this.engine.setDiagram(this.diagram);
        this.engine.setLogLevel(Level.SEVERE);
        EModel emodel = (EModel)this.diagram.getRole(EModel.class);
        emodel.detectVariableTypes();
        for (Variable var : emodel.getVariables()) {
            if (var.getName().startsWith("$$") || var.getType().equals("Calculated")) continue;
            this.inputParameters.put((DataElement)new InputParameter(var.getName(), var.getTitle(), var.getType(), var.getInitialValue()));
        }
        this.plots = DiagramUtility.getPlotsInfo((Diagram)this.diagram).clone(emodel);
        if (this.plots == null) {
            this.plots = new PlotsInfo(emodel);
        }
        this.model = this.engine.createModel();
        this.model.init();
        this.inputValues = this.model.getCurrentValues();
        this.parameterMapping = this.engine.getVarPathIndexMapping();
    }
}

