/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ae;

import biouml.plugins.simulation.Options;
import biouml.plugins.simulation.ae.AeModel;
import biouml.plugins.simulation.ae.AeSolver;
import biouml.plugins.simulation.ae.NewtonSolver;
import com.developmentontheedge.beans.annot.PropertyName;
import ru.biosoft.util.bean.JSONBean;

public class NewtonSolverWrapperEx
extends Options
implements AeSolver,
JSONBean {
    private boolean isSuccess = false;
    private double maxIts = 20000.0;
    private double tolF = 1.0E-10;
    private double tolMin = 1.0E-12;
    private double tolX = 1.0E-13;

    @Override
    public double[] solve(double[] initialGuess, AeModel model) throws Exception {
        this.isSuccess = true;
        try {
            NewtonSolver.solve(initialGuess, model, this.maxIts, this.tolF, this.tolMin, this.tolX);
        }
        catch (Exception e) {
            this.isSuccess = false;
        }
        return initialGuess;
    }

    @Override
    public boolean isSuccess() {
        return this.isSuccess;
    }

    @Override
    public String getMessage() {
        return this.isSuccess ? "" : "Newton solver can't find solution.";
    }

    @PropertyName(value="Maximum iterations")
    public double getMaxIts() {
        return this.maxIts;
    }

    public void setMaxIts(double maxIts) {
        double oldValue = this.maxIts;
        this.maxIts = maxIts;
        this.firePropertyChange("maxIts", oldValue, maxIts);
    }

    @PropertyName(value="Function tolerance")
    public double getTolF() {
        return this.tolF;
    }

    public void setTolF(double tolF) {
        double oldValue = this.tolF;
        this.tolF = tolF;
        this.firePropertyChange("tolF", oldValue, tolF);
    }

    @PropertyName(value="Minimal gradient tolerance")
    public double getTolMin() {
        return this.tolMin;
    }

    public void setTolMin(double tolMin) {
        double oldValue = this.tolMin;
        this.tolMin = tolMin;
        this.firePropertyChange("tolMin", oldValue, tolMin);
    }

    @PropertyName(value="Points tolerance")
    public double getTolX() {
        return this.tolX;
    }

    public void setTolX(double tolX) {
        double oldValue = this.tolX;
        this.tolX = tolX;
        this.firePropertyChange("tolX", oldValue, tolX);
    }
}

