/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ae;

import biouml.plugins.simulation.Options;
import biouml.plugins.simulation.ae.AeModel;
import biouml.plugins.simulation.ae.AeSolver;
import biouml.plugins.simulation.ae.KinSolver;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;

public class KinSolverWrapper
extends Options
implements AeSolver {
    private static final String ETACHOICE1 = "choice 1";
    private static final String ETACHOICE2 = "choice 2";
    private static final String ETACONSTANT = "constant";
    private static final String LINE_SEARCH = "Line search";
    private static final String NEWTON = "Newton";
    private int status = 0;
    private KinSolver solver = null;
    private double ftolerance = KinSolver.FTOL_DEFAULT;
    private double tolerance = KinSolver.STOL_DEFAULT;
    private int maxIter = 200;
    private int maxSetups = 10;
    private String strategy = "Newton";
    private String etaFlag = "choice 1";
    private static final String[] availableStrategies = new String[]{"Newton", "Line search"};
    private static final String[] availableEtaFlags = new String[]{"choice 1", "choice 2", "constant"};

    @Override
    public double[] solve(double[] initialGuess, AeModel model) throws Exception {
        this.solver = new KinSolver(model, initialGuess);
        this.solver.setFtol(this.ftolerance);
        this.solver.setStol(this.tolerance);
        this.solver.setMaximumIterations(this.maxIter);
        this.solver.setMaxSetups(this.maxSetups);
        this.solver.setEtaFlag(this.getEtaFlagType());
        this.status = this.solver.start(initialGuess, this.getStrategyType());
        initialGuess = this.solver.getY();
        return initialGuess;
    }

    @Override
    public boolean isSuccess() {
        return this.status >= 0;
    }

    @Override
    public String getMessage() {
        if (this.solver == null) {
            return "";
        }
        return (String)this.solver.flagToMessage.get(this.status);
    }

    private int getEtaFlagType() {
        switch (this.etaFlag) {
            case "constant": {
                return 3;
            }
            case "choice 2": {
                return 2;
            }
        }
        return 1;
    }

    private int getStrategyType() {
        return LINE_SEARCH.equals(this.strategy) ? 1 : 0;
    }

    @PropertyName(value="Function tolerance")
    @PropertyDescription(value="stopping tolerance on L2-norm of function value")
    public double getFtolerance() {
        return this.ftolerance;
    }

    public void setFtolerance(double ftol) {
        Double oldValue = this.ftolerance;
        this.ftolerance = ftol;
        this.firePropertyChange("ftolerance", oldValue, ftol);
    }

    @PropertyName(value="Step tolerance")
    @PropertyDescription(value="scaled step length tolerance")
    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        Double oldValue = this.tolerance;
        this.tolerance = tolerance;
        this.firePropertyChange("ftolerance", oldValue, tolerance);
    }

    @PropertyName(value="Max iterations")
    @PropertyDescription(value="maximum number of nonlinear iterations")
    public int getMaxIter() {
        return this.maxIter;
    }

    public void setMaxIter(int maxIter) {
        Integer oldValue = this.maxIter;
        this.maxIter = maxIter;
        this.firePropertyChange("maxIter", oldValue, maxIter);
    }

    @PropertyName(value="Max setups")
    @PropertyDescription(value="maximum number of nonlinear iterations that may be performed between calls to the linear solver setup routine (setup)")
    public int getMaxSetups() {
        return this.maxSetups;
    }

    public void setMaxSetups(int maxSetups) {
        Integer oldValue = this.maxSetups;
        this.maxSetups = maxSetups;
        this.firePropertyChange("maxSetups", oldValue, maxSetups);
    }

    @PropertyName(value="Solving strategy")
    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        String oldValue = this.strategy;
        this.strategy = strategy;
        this.firePropertyChange("strategy", oldValue, this.strategy);
    }

    @PropertyName(value="Eta flag")
    public String getEtaFlag() {
        return this.etaFlag;
    }

    public void setEtaFlag(String etaFlag) {
        String oldValue = this.etaFlag;
        this.etaFlag = etaFlag;
        this.firePropertyChange("etaFlag", oldValue, this.etaFlag);
    }

    public String[] getAvailableStrategies() {
        return (String[])availableStrategies.clone();
    }

    public String[] getAvailableEtaFlags() {
        return (String[])availableEtaFlags.clone();
    }
}

