/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ae;

import biouml.plugins.simulation.ae.AeModel;
import biouml.plugins.simulation.ae.KinSolEngine;
import biouml.plugins.simulation.ode.jvode.Matrix;
import biouml.plugins.simulation.ode.jvode.MatrixUtils;
import biouml.plugins.simulation.ode.jvode.VectorUtils;

public class KinSolver
extends KinSolEngine {
    protected boolean jacDQ = true;
    protected Matrix jacobianMatrix;
    protected int[] pivots;
    public long nje;
    public long nfeDQ;

    public KinSolver(AeModel f, double[] initialGuess) throws Exception {
        super(f, initialGuess, 0);
        this.setupNonNull = true;
        this.jacobianMatrix = new Matrix(this.n, this.n);
        this.pivots = new int[this.n];
        this.inexactLs = false;
    }

    @Override
    protected int init() {
        return 0;
    }

    @Override
    protected int setup() {
        ++this.nje;
        if (this.jac(this.u, this.fValue, this.jacobianMatrix) != 0) {
            return -1;
        }
        if (MatrixUtils.DenseGETRF(this.jacobianMatrix, this.pivots) > 0) {
            return -1;
        }
        return 0;
    }

    @Override
    protected int solve(double[] x, double[] b) {
        VectorUtils.copy(b, x);
        MatrixUtils.DenseGETRS(this.jacobianMatrix, this.pivots, x);
        this.sJpnorm = VectorUtils.l2Norm(b, this.fscale);
        VectorUtils.prod(b, this.fscale, b);
        VectorUtils.prod(b, this.fscale, b);
        this.sfdotJp = VectorUtils.dotProd(this.fValue, b);
        return 0;
    }

    int jac(double[] u, double[] f, Matrix Jac) {
        int retval = 0;
        double[] ftemp = new double[this.n];
        double[] utemp = new double[this.n];
        VectorUtils.copy(u, utemp);
        for (int j = 0; j < this.n; ++j) {
            double ujsaved = utemp[j];
            double sign = ujsaved >= 0.0 ? 1.0 : -1.0;
            double inc = this.sqrtRelfunc * Math.max(Math.abs(ujsaved), 1.0 / this.uscale[j]) * sign;
            int n = j;
            utemp[n] = utemp[n] + inc;
            retval = this.func(utemp, ftemp);
            ++this.nfeDQ;
            if (retval != 0) break;
            utemp[j] = ujsaved;
            VectorUtils.scaleDiff(1.0 / inc, ftemp, f, Jac.cols[j]);
        }
        return retval;
    }
}

