/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ae;

import biouml.plugins.simulation.ae.AeModel;
import biouml.plugins.simulation.ode.jvode.VectorUtils;
import java.util.Arrays;
import java.util.HashMap;

public abstract class KinSolSupport {
    public static final int RETRY_ITERATION = -998;
    public static final int CONTINUE_ITERATIONS = -999;
    public static final int STEP_TOO_SMALL = -997;
    public static final int CONSTR_VIOLATED = -996;
    public static final int MAX_RECVR = 5;
    public static final int DEBAG_DEFAULT = 0;
    public static final int MXITER_DEFAULT = 200;
    public static final int MXNBCF_DEFAULT = 10;
    public static final int MSBSET_DEFAULT = 10;
    public static final int MSBSET_SUB_DEFAULT = 5;
    public static final double OMEGA_MIN = 1.0E-5;
    public static final double OMEGA_MAX = 0.9;
    public static final double UNIT_ROUNDOFF = 2.220446049250313E-16;
    public static final double FTOL_DEFAULT = Math.pow(2.220446049250313E-16, 0.3333333333333333);
    public static final double STOL_DEFAULT = Math.pow(2.220446049250313E-16, 0.6666666666666667);
    public static final int ETACHOICE1 = 1;
    public static final int ETACHOICE2 = 2;
    public static final int ETACONSTANT = 3;
    public static final int NONE = 0;
    public static final int LINESEARCH = 1;
    protected AeModel func;
    protected double fTolerance = FTOL_DEFAULT;
    protected double stepTolerance = STOL_DEFAULT;
    protected int strategy = 0;
    protected int debagLevel = 0;
    protected int mxiter = 200;
    protected int msbset = 10;
    protected int msbset_sub = 5;
    protected int mxnbcf = 10;
    protected int etaflag = 1;
    protected boolean noMinEps = false;
    protected boolean setupNonNull = false;
    protected boolean constraintsSet = false;
    protected boolean jacCurrent;
    protected boolean callForcingTerm;
    protected boolean noResMon = false;
    protected boolean retryIteration;
    protected boolean updateFnormSub;
    protected double mxnewtstep;
    protected double sqrtRelfunc = Math.sqrt(2.220446049250313E-16);
    protected double stepl;
    protected double stepmul;
    protected double eps;
    protected double eta;
    protected double etaGamma;
    protected double etaAlpha;
    protected boolean noInitSetup = false;
    protected double sthrsh;
    protected long iterationsNumber;
    protected long modelFunctionCallNumber;
    protected long nnilset;
    protected long nnilset_sub;
    protected long nbcf;
    protected long backTrackNumber;
    protected long conseqStepsOfMaxSize;
    protected double[] u;
    protected double[] uDelta;
    protected double[] uNew;
    protected double[] fValue;
    protected double[] uscale;
    protected double[] fscale;
    protected double[] constraints;
    protected boolean inexactLs;
    protected double fnorm;
    protected double f1norm;
    protected double res_norm;
    protected double sfdotJp;
    protected double sJpnorm;
    protected double fnormSub;
    protected boolean evalOmega = true;
    protected double omega;
    protected double omega_min = 1.0E-5;
    protected double omega_max = 0.9;
    protected int n;
    protected double fnormp = -1.0;
    protected double f1normp = -1.0;
    protected boolean maxStepTaken = false;
    HashMap<Integer, String> flagToMessage;
    public static final int SUCCESS = 0;
    public static final int INITIAL_GUESS_OK = 1;
    public static final int STEP_LT_STPTOL = 2;
    public static final int LINESEARCH_NONCONV = -1;
    public static final int MAXITER_REACHED = -2;
    public static final int MXNEWT_5X_EXCEEDED = -3;
    public static final int LINESEARCH_BCFAIL = -4;
    public static final int LINSOLV_NO_RECOVERY = -5;
    public static final int LINIT_FAIL = -6;
    public static final int LSETUP_FAIL = -7;
    public static final int LSOLVE_FAIL = -8;
    public static final int SYSFUNC_FAIL = -9;
    public static final int FIRST_SYSFUNC_ERR = -10;
    public static final int REPTD_SYSFUNC_ERR = -11;

    public KinSolSupport(AeModel f, double[] initialGuess) {
        if (f == null) {
            throw new IllegalArgumentException("Righ hand side function is null.");
        }
        try {
            f.solveAlgebraic(initialGuess);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Probably right hand side function and initial guess are not compatible.");
        }
        this.func = f;
        this.n = initialGuess.length;
        this.u = Arrays.copyOf(initialGuess, this.n);
        this.sthrsh = 2.0;
        this.mxnewtstep = 0.0;
        this.eta = 0.1;
        this.etaAlpha = 2.0;
        this.etaGamma = 0.9;
        this.omega = 0.0;
        this.uNew = new double[this.n];
        this.fValue = new double[this.n];
        this.uDelta = new double[this.n];
        this.setFlagToMessageMap();
    }

    public double[] getY() {
        return this.u;
    }

    public long getNonLinearIterationsNumber() {
        return this.iterationsNumber;
    }

    public long getRHSFunctionCallNumbers() {
        return this.modelFunctionCallNumber;
    }

    public void setStol(double tolerance) {
        if (tolerance < 0.0) {
            throw new IllegalArgumentException("Step tolerance must not be negative");
        }
        this.stepTolerance = tolerance;
    }

    public void setFtol(double tolerance) {
        if (tolerance < 0.0) {
            throw new IllegalArgumentException("Function tolerance must not be negative");
        }
        this.fTolerance = tolerance;
    }

    public void setConstraints(double[] constraints) {
        if (constraints.length != this.n) {
            throw new IllegalArgumentException("Constarints length must equals to right hand side dimension = " + this.n);
        }
        for (int i = 0; i < this.n; ++i) {
            if (constraints[i] == 1.0 || constraints[i] == 0.0 || constraints[i] == -1.0) continue;
            throw new IllegalArgumentException("Illegal values in constraints vector: " + constraints[i] + ". Must be: 1, 0 or -1");
        }
        this.constraints = Arrays.copyOf(constraints, this.n);
        this.constraintsSet = true;
    }

    public void removeConstraints() {
        this.constraints = null;
        this.constraintsSet = false;
    }

    public void setIntitalGuess(double[] initialGuess) {
        if (initialGuess.length != this.n) {
            throw new IllegalArgumentException("Initial guess length must equals to right hand side dimension = " + this.n);
        }
        this.u = Arrays.copyOf(initialGuess, this.n);
    }

    public void setMaximumIterations(int maxIterations) {
        if (maxIterations <= 0) {
            throw new IllegalArgumentException("Maximum iterations illegally negative: " + maxIterations);
        }
        this.mxiter = maxIterations;
    }

    public void setMaxSetups(int max) {
        if (max > 0) {
            this.msbset = max;
        }
    }

    public void setEtaFlag(int etaflag) {
        switch (etaflag) {
            case 3: {
                this.etaflag = 3;
                break;
            }
            case 2: {
                this.etaflag = 2;
                break;
            }
            default: {
                this.etaflag = 1;
            }
        }
    }

    public void setStartegy(int strategy) {
        if (strategy != 0 && strategy != 1) {
            throw new IllegalArgumentException("Illegal value for global strategy. Must be KinSol.LINESEARHC or KinSol.NONE");
        }
        this.strategy = strategy;
    }

    public void setUScale(double[] usacle) {
        if (usacle.length != this.n) {
            throw new IllegalArgumentException("U scale array length length must equals to right hand side dimension = " + this.n);
        }
        if (VectorUtils.getMin(this.uscale) <= 0.0) {
            throw new IllegalArgumentException("Uscale has nonpositive elements.");
        }
        this.uscale = Arrays.copyOf(this.uscale, this.n);
    }

    public void setFScale(double[] fsacle) {
        if (fsacle.length != this.n) {
            throw new IllegalArgumentException("F scale array length must equals to right hand side dimension = " + this.n);
        }
        if (VectorUtils.getMin(this.uscale) <= 0.0) {
            throw new IllegalArgumentException("Uscale has nonpositive elements.");
        }
        this.fscale = Arrays.copyOf(this.fscale, this.n);
    }

    public void setFlagToMessageMap() {
        this.flagToMessage = new HashMap();
        this.flagToMessage.put(0, "Problem solved successfully");
        this.flagToMessage.put(1, "Inital guess already satisfies stopping criterion");
        this.flagToMessage.put(2, "The stopping tolerance on scaled step length was satisfied");
        this.flagToMessage.put(-1, "The line search algorithm was unable to find an iterate sufficiently distinct from the current iterate.");
        this.flagToMessage.put(-2, "The maximum number of iterations was reached before convergence.");
        this.flagToMessage.put(-3, "Five consecutive steps have been taken that satisfy a scaled step length test.");
        this.flagToMessage.put(-4, "The line search algorithm was unable to satisfy the beta-condition for nbcfails iterations.");
        this.flagToMessage.put(-5, "The linear solver's solve function failed recoverably, but the Jacobian data is already current.");
        this.flagToMessage.put(-6, "The linear solver's init function failed in an unrecoverable manner.");
        this.flagToMessage.put(-7, "The linear solver's setup function failed in an unrecoverable manner. Probably jacobian is degenerate.");
        this.flagToMessage.put(-8, "The linear solver's solve function failed in an unrecoverable manner.");
        this.flagToMessage.put(-9, "The system function failed in an unrecoverable manner.");
        this.flagToMessage.put(-10, "The system function failed at the first call.");
    }

    protected int init() {
        return 0;
    }

    protected int solve(double[] x, double[] y) {
        return 0;
    }

    protected int setup() {
        return 0;
    }

    protected int func(double[] u, double[] f) {
        try {
            double[] result = this.func.solveAlgebraic(u);
            VectorUtils.copy(result, f);
        }
        catch (Exception ex) {
            return 1;
        }
        return 0;
    }
}

