/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ae;

import biouml.plugins.simulation.ae.AeModel;
import biouml.plugins.simulation.ae.KinSolSupport;
import biouml.plugins.simulation.ode.jvode.VectorUtils;

public abstract class KinSolEngine
extends KinSolSupport {
    public KinSolEngine(AeModel f, double[] initialGuess, int strategy) throws Exception {
        super(f, initialGuess);
    }

    public int start(double[] initialGuess, int strategy) {
        this.setIntitalGuess(initialGuess);
        this.setStartegy(strategy);
        return this.start();
    }

    public int start() {
        int flag = this.initSolver();
        if (flag != 0) {
            this.processFlag(flag);
            return flag;
        }
        this.sthrsh = this.noInitSetup ? 1.0 : 2.0;
        double epsmin = this.inexactLs && !this.noMinEps ? 0.01 * this.fTolerance : 0.0;
        this.evalOmega = this.omega == 0.0;
        do {
            ++this.iterationsNumber;
            if (this.inexactLs) {
                this.eps = (this.eta + 2.220446049250313E-16) * this.fnorm;
                if (!this.noMinEps) {
                    this.eps = Math.max(epsmin, this.eps);
                }
            }
            this.retryIteration = false;
            do {
                flag = this.doIteration();
            } while (this.retryIteration);
            VectorUtils.copy(this.uNew, this.u);
            this.f1norm = this.f1normp;
            if (this.debagLevel <= 0) continue;
            this.printInfo("nni = " + this.iterationsNumber + " nfe = " + this.modelFunctionCallNumber + "fnorm = " + this.fnorm);
        } while (flag == -999);
        if (this.debagLevel > 0) {
            this.printInfo("flag = " + flag);
        }
        this.processFlag(flag);
        return flag;
    }

    private int doIteration() {
        int flag = this.approxSolution();
        if (flag != 0) {
            return flag;
        }
        int sflag = 0;
        if (this.strategy == 0) {
            sflag = this.newton();
            if (sflag == -9 || sflag == -11) {
                return sflag;
            }
        } else if (this.strategy == 1) {
            sflag = this.lineSearch();
            if (sflag == -9) {
                return sflag;
            }
            if (this.nbcf > (long)this.mxnbcf) {
                return -4;
            }
        }
        if (this.callForcingTerm) {
            this.forcingTerms();
        }
        this.fnorm = this.fnormp;
        return this.checkSolution(sflag);
    }

    private int initSolver() {
        int i;
        if (this.uscale == null) {
            this.uscale = new double[this.n];
            for (i = 0; i < this.n; ++i) {
                this.uscale[i] = 1.0;
            }
        }
        if (this.fscale == null) {
            this.fscale = new double[this.n];
            for (i = 0; i < this.n; ++i) {
                this.fscale[i] = 1.0;
            }
        }
        this.conseqStepsOfMaxSize = 0L;
        boolean bl = this.constraintsSet = this.constraints != null;
        if (this.constraintsSet && !VectorUtils.constrMask(this.constraints, this.u, new double[this.n])) {
            throw new IllegalArgumentException("Initial guess does not meet constraints.");
        }
        if (this.debagLevel > 0) {
            this.printInfo("scsteptol = " + this.stepTolerance + "fnormtol = " + this.fTolerance);
        }
        if (this.mxnewtstep == 0.0) {
            this.mxnewtstep = 1000.0 * VectorUtils.l2Norm(this.u, this.uscale);
        }
        if (this.mxnewtstep < 1.0) {
            this.mxnewtstep = 1.0;
        }
        if (this.inexactLs) {
            boolean bl2 = this.callForcingTerm = this.etaflag != 3;
            if (this.etaflag == 1) {
                this.etaAlpha = (1.0 + Math.sqrt(5.0)) * 0.5;
            }
            if (this.etaflag != 3) {
                this.eta = 0.5;
            }
            this.noResMon = true;
        } else {
            this.callForcingTerm = false;
        }
        this.backTrackNumber = 0L;
        this.nbcf = 0L;
        this.iterationsNumber = 0L;
        this.nnilset_sub = 0L;
        this.nnilset = 0L;
        this.modelFunctionCallNumber = 0L;
        int flag = this.func(this.u, this.fValue);
        ++this.modelFunctionCallNumber;
        if (flag < 0) {
            return -9;
        }
        if (flag > 0) {
            return -10;
        }
        double fmax = this.cFNorm(this.fValue, this.fscale);
        if (this.debagLevel > 1) {
            this.printInfo("fmax = " + fmax);
        }
        if (fmax <= this.fTolerance) {
            return 1;
        }
        this.fnorm = VectorUtils.l2Norm(this.fValue, this.fscale);
        this.f1norm = 0.5 * this.fnorm * this.fnorm;
        this.fnormSub = this.fnorm;
        if (this.debagLevel > 0) {
            this.printInfo("nni = " + this.iterationsNumber + " nfe = " + this.modelFunctionCallNumber + "fnorm = " + this.fnorm);
        }
        return 0;
    }

    private int approxSolution() {
        if (this.iterationsNumber - this.nnilset >= (long)this.msbset) {
            this.sthrsh = 2.0;
            this.updateFnormSub = true;
        }
        while (true) {
            int retval;
            this.jacCurrent = false;
            if (this.sthrsh > 1.5 && this.setupNonNull) {
                retval = this.setup();
                this.jacCurrent = true;
                this.nnilset = this.iterationsNumber;
                this.nnilset_sub = this.iterationsNumber;
                if (retval != 0) {
                    return -7;
                }
            }
            VectorUtils.scale(-1.0, this.fValue, this.uNew);
            retval = this.solve(this.uDelta, this.uNew);
            if (retval == 0) {
                return 0;
            }
            if (retval < 0) {
                return -8;
            }
            if (!this.setupNonNull || this.jacCurrent) {
                return -5;
            }
            this.sthrsh = 2.0;
        }
    }

    private int newton() {
        int retval;
        this.maxStepTaken = false;
        double pnorm = VectorUtils.l2Norm(this.uDelta, this.uscale);
        double ratio = 1.0;
        if (pnorm > this.mxnewtstep) {
            ratio = this.mxnewtstep / pnorm;
            VectorUtils.scale(ratio, this.uDelta);
            pnorm = this.mxnewtstep;
        }
        if (this.debagLevel > 0) {
            this.printInfo("pnorm = " + pnorm);
        }
        this.stepl = pnorm;
        this.stepmul = 1.0;
        if (this.constraintsSet && (retval = this.checkConstraint()) == -996) {
            ratio *= this.stepmul;
            VectorUtils.scale(this.stepmul, this.uDelta);
            this.stepl = pnorm *= this.stepmul;
            if (this.debagLevel > 0) {
                this.printInfo("pnorm = " + pnorm);
            }
            if (pnorm <= this.stepTolerance) {
                return -997;
            }
        }
        boolean fOK = false;
        for (int ircvr = 1; ircvr <= 5; ++ircvr) {
            VectorUtils.linearSum(this.u, this.uDelta, this.uNew);
            retval = this.func(this.uNew, this.fValue);
            ++this.modelFunctionCallNumber;
            if (retval == 0) {
                fOK = true;
                break;
            }
            if (retval < 0) {
                return -9;
            }
            ratio *= 0.5;
            VectorUtils.scale(0.5, this.uDelta);
            this.stepl = pnorm *= 0.5;
        }
        if (!fOK) {
            return -11;
        }
        this.fnormp = VectorUtils.l2Norm(this.fValue, this.fscale);
        this.f1normp = 0.5 * this.fnormp * this.fnormp;
        this.sfdotJp *= ratio;
        this.sJpnorm *= ratio;
        if (this.debagLevel > 1) {
            this.printInfo("fnormp = " + this.fnormp);
        }
        if (pnorm > 0.99 * this.mxnewtstep) {
            this.maxStepTaken = true;
        }
        return 0;
    }

    private int lineSearch() {
        double alpha_cond;
        double rl;
        double rlmin;
        double slpi;
        int retval;
        double rlmax;
        double pnorm;
        double rlprev;
        double f1nprv;
        double beta;
        double alpha;
        double ratio;
        int nbktrk_l;
        block27: {
            nbktrk_l = 0;
            ratio = 1.0;
            alpha = 1.0E-4;
            beta = 0.9;
            boolean firstBacktrack = true;
            this.maxStepTaken = false;
            f1nprv = 0.0;
            rlprev = 0.0;
            pnorm = VectorUtils.l2Norm(this.uDelta, this.uscale);
            rlmax = this.mxnewtstep / pnorm;
            this.stepl = pnorm;
            if (pnorm > this.mxnewtstep) {
                ratio = this.mxnewtstep / pnorm;
                VectorUtils.scale(ratio, this.uDelta);
                pnorm = this.mxnewtstep;
                rlmax = 1.0;
                this.stepl = pnorm;
            }
            this.stepmul = 1.0;
            if (this.constraintsSet && (retval = this.checkConstraint()) == -996) {
                VectorUtils.scale(this.stepmul, this.uDelta);
                ratio *= this.stepmul;
                rlmax = 1.0;
                this.stepl = pnorm *= this.stepmul;
                if (this.debagLevel > 0) {
                    this.printInfo("pnorm = " + pnorm);
                }
                if (pnorm <= this.stepTolerance) {
                    return -997;
                }
            }
            boolean fOK = false;
            for (int ircvr = 1; ircvr <= 5; ++ircvr) {
                VectorUtils.linearSum(this.u, this.uDelta, this.uNew);
                retval = this.func(this.uNew, this.fValue);
                ++this.modelFunctionCallNumber;
                if (retval == 0) {
                    fOK = true;
                    break;
                }
                if (retval < 0) {
                    return -9;
                }
                VectorUtils.scale(0.5, this.uDelta);
                ratio *= 0.5;
                rlmax = 1.0;
                this.stepl = pnorm *= 0.5;
            }
            if (!fOK) {
                return -11;
            }
            this.fnormp = VectorUtils.l2Norm(this.fValue, this.fscale);
            this.f1normp = 0.5 * this.fnormp * this.fnormp;
            slpi = this.sfdotJp * ratio;
            double rlength = this.cSNorm(this.uDelta, this.u);
            rlmin = this.stepTolerance / rlength;
            rl = 1.0;
            if (this.debagLevel > 2) {
                this.printInfo("rlmin = " + rlmin + " f1norm = " + this.f1norm + " pnorm = " + pnorm);
            }
            do {
                double rltmp;
                alpha_cond = this.f1norm + alpha * slpi * rl;
                if (this.debagLevel > 2) {
                    this.printInfo("fnormp = " + this.fnormp + " f1normp = " + this.f1normp + " alpha_cond = " + alpha_cond + " r1 = " + rl);
                }
                if (this.f1normp <= alpha_cond) break block27;
                if (firstBacktrack) {
                    rltmp = -slpi / (2.0 * (this.f1normp - this.f1norm - slpi));
                    firstBacktrack = false;
                } else {
                    double tmp1 = this.f1normp - this.f1norm - rl * slpi;
                    double tmp2 = f1nprv - this.f1norm - rlprev * slpi;
                    double rl_a = 1.0 / (rl * rl) * tmp1 - 1.0 / (rlprev * rlprev) * tmp2;
                    double rl_b = -rlprev / (rl * rl) * tmp1 + rl / (rlprev * rlprev) * tmp2;
                    tmp1 = 1.0 / (rl - rlprev);
                    double disc = (rl_b *= tmp1) * rl_b - 3.0 * (rl_a *= tmp1) * slpi;
                    rltmp = Math.abs(rl_a) < 2.220446049250313E-16 ? -slpi / (2.0 * rl_b) : (-rl_b + Math.sqrt(disc)) / (3.0 * rl_a);
                    rltmp = Math.min(rltmp, 0.5 * rl);
                }
                rlprev = rl;
                f1nprv = this.f1normp;
                double pt1trl = 0.1 * rl;
                rl = Math.max(pt1trl, rltmp);
                ++nbktrk_l;
                VectorUtils.linearSum(this.u, rl, this.uDelta, this.uNew);
                retval = this.func(this.uNew, this.fValue);
                ++this.modelFunctionCallNumber;
                if (retval != 0) {
                    return -9;
                }
                this.fnormp = VectorUtils.l2Norm(this.fValue, this.fscale);
                this.f1normp = 0.5 * this.fnormp * this.fnormp;
            } while (!(rl < rlmin));
            VectorUtils.copy(this.u, this.uNew);
            return -997;
        }
        double beta_cond = this.f1norm + beta * slpi * rl;
        if (this.f1normp < beta_cond) {
            if (rl == 1.0 && pnorm < this.mxnewtstep) {
                do {
                    rlprev = rl;
                    f1nprv = this.f1normp;
                    rl = Math.min(2.0 * rl, rlmax);
                    ++nbktrk_l;
                    VectorUtils.linearSum(this.u, rl, this.uDelta, this.uNew);
                    retval = this.func(this.uNew, this.fValue);
                    ++this.modelFunctionCallNumber;
                    if (retval != 0) {
                        return -9;
                    }
                    this.fnormp = VectorUtils.l2Norm(this.fValue, this.fscale);
                    this.f1normp = 0.5 * this.fnormp * this.fnormp;
                    alpha_cond = this.f1norm + alpha * slpi * rl;
                    beta_cond = this.f1norm + beta * slpi * rl;
                    if (this.debagLevel <= 2) continue;
                    this.printInfo("f1normp = " + this.f1normp + " beta_cond = " + beta_cond + " r1 = " + rl);
                } while (this.f1normp <= alpha_cond && this.f1normp < beta_cond && rl < rlmax);
            }
            if (rl < 1.0 || rl > 1.0 && this.f1normp > alpha_cond) {
                double rllo = Math.min(rl, rlprev);
                double rldiff = Math.abs(rlprev - rl);
                do {
                    double rlinc = 0.5 * rldiff;
                    rl = rllo + rlinc;
                    ++nbktrk_l;
                    VectorUtils.linearSum(this.u, rl, this.uDelta, this.uNew);
                    retval = this.func(this.uNew, this.fValue);
                    ++this.modelFunctionCallNumber;
                    if (retval != 0) {
                        return -9;
                    }
                    this.fnormp = VectorUtils.l2Norm(this.fValue, this.fscale);
                    this.f1normp = 0.5 * this.fnormp * this.fnormp;
                    alpha_cond = this.f1norm + alpha * slpi * rl;
                    beta_cond = this.f1norm + beta * slpi * rl;
                    if (this.debagLevel > 2) {
                        this.printInfo("f1normp = " + this.f1normp + " alpha_cond = " + alpha_cond + " beta_cond = " + beta_cond + " r1 = " + rl);
                    }
                    if (this.f1normp > alpha_cond) {
                        rldiff = rlinc;
                        continue;
                    }
                    if (!(this.f1normp < beta_cond)) continue;
                    rllo = rl;
                    rldiff -= rlinc;
                } while (this.f1normp > alpha_cond || this.f1normp < beta_cond && rldiff >= rlmin);
                if (this.f1normp < beta_cond) {
                    VectorUtils.linearSum(this.u, rllo, this.uDelta, this.uNew);
                    retval = this.func(this.uNew, this.fValue);
                    ++this.modelFunctionCallNumber;
                    if (retval != 0) {
                        return -9;
                    }
                    this.fnormp = VectorUtils.l2Norm(this.fValue, this.fscale);
                    this.f1normp = 0.5 * this.fnormp * this.fnormp;
                    ++this.nbcf;
                }
            }
        }
        this.backTrackNumber += (long)nbktrk_l;
        if (this.debagLevel > 1) {
            this.printInfo("nbktrk_l = " + nbktrk_l);
        }
        double f = rl * ratio;
        this.sfdotJp *= f;
        this.sJpnorm *= f;
        if (rl * pnorm > 0.99 * this.mxnewtstep) {
            this.maxStepTaken = true;
        }
        return 0;
    }

    private int checkConstraint() {
        double[] vtemp1 = new double[this.n];
        double[] vtemp2 = new double[this.n];
        VectorUtils.linearSum(this.u, this.uDelta, vtemp1);
        if (VectorUtils.constrMask(this.constraints, vtemp1, vtemp2)) {
            return 0;
        }
        VectorUtils.abs(this.uDelta, vtemp1);
        VectorUtils.prod(vtemp2, vtemp1, vtemp1);
        VectorUtils.abs(this.u, vtemp2);
        this.stepmul = 0.9 * VectorUtils.minQuotient(vtemp2, vtemp1);
        return -996;
    }

    private int checkSolution(int sflag) {
        long l;
        this.retryIteration = false;
        if (sflag == -997) {
            if (this.setupNonNull && !this.jacCurrent) {
                this.sthrsh = 2.0;
                return -999;
            }
            if (this.strategy == 0) {
                return 2;
            }
            return -1;
        }
        double fmax = this.cFNorm(this.fValue, this.fscale);
        if (this.debagLevel > 1) {
            this.printInfo("fmax = " + fmax);
        }
        if (fmax <= this.fTolerance) {
            return 0;
        }
        double[] delta = this.uDelta;
        VectorUtils.linearDiff(this.uNew, this.u, delta);
        double rlength = this.cSNorm(delta, this.uNew);
        if (rlength <= this.stepTolerance) {
            if (this.setupNonNull && !this.jacCurrent) {
                this.sthrsh = 2.0;
                return -999;
            }
            return 2;
        }
        if (this.iterationsNumber >= (long)this.mxiter) {
            return -2;
        }
        if (this.maxStepTaken) {
            long l2 = this.conseqStepsOfMaxSize;
            l = l2;
            this.conseqStepsOfMaxSize = l2 + 1L;
        } else {
            l = this.conseqStepsOfMaxSize = 0L;
        }
        if (this.conseqStepsOfMaxSize == 5L) {
            return -3;
        }
        if (this.inexactLs) {
            this.sthrsh = rlength;
        } else if (!this.noResMon) {
            if (this.iterationsNumber - this.nnilset_sub >= (long)this.msbset_sub) {
                this.nnilset_sub = this.iterationsNumber;
                if (this.evalOmega) {
                    this.omega = Math.min(this.omega_min * Math.exp(Math.max(0.0, this.fnorm / this.fTolerance - 1.0)), this.omega_max);
                }
                if (this.fnorm > this.omega * this.fnormSub) {
                    if (this.setupNonNull && !this.jacCurrent) {
                        this.sthrsh = 2.0;
                        this.retryIteration = true;
                        return -998;
                    }
                } else {
                    this.fnormSub = this.fnorm;
                    this.sthrsh = 1.0;
                }
            } else {
                if (this.retryIteration || this.updateFnormSub) {
                    this.fnormSub = this.fnorm;
                }
                if (this.updateFnormSub) {
                    this.updateFnormSub = false;
                }
                this.sthrsh = 1.0;
            }
        }
        return -999;
    }

    private void forcingTerms() {
        double eta_max = 0.9;
        double eta_min = 1.0E-4;
        double eta_safe = 0.5;
        if (this.etaflag == 1) {
            double linmodel_norm = Math.sqrt(this.fnorm * this.fnorm + 2.0 * this.sfdotJp + this.sJpnorm * this.sJpnorm);
            eta_safe = Math.pow(this.eta, this.etaAlpha);
            this.eta = Math.abs(this.fnormp - linmodel_norm) / this.fnorm;
        }
        if (this.etaflag == 2) {
            eta_safe = this.etaGamma * Math.pow(this.eta, this.etaAlpha);
            this.eta = this.etaGamma * Math.pow(this.fnormp / this.fnorm, this.etaAlpha);
        }
        if (eta_safe < 0.1) {
            eta_safe = 0.0;
        }
        this.eta = Math.max(this.eta, eta_safe);
        this.eta = Math.max(this.eta, eta_min);
        this.eta = Math.min(this.eta, eta_max);
    }

    private double cFNorm(double[] v, double[] scale) {
        double[] vtemp1 = new double[this.n];
        VectorUtils.prod(scale, v, vtemp1);
        return VectorUtils.maxNorm(vtemp1);
    }

    private double cSNorm(double[] v, double[] u) {
        double[] vtemp1 = new double[this.n];
        double[] vtemp2 = new double[this.n];
        VectorUtils.inv(this.uscale, vtemp1);
        VectorUtils.abs(u, vtemp2);
        VectorUtils.linearSum(vtemp1, vtemp2, vtemp1);
        VectorUtils.divide(v, vtemp1, vtemp1);
        return VectorUtils.maxNorm(vtemp1);
    }

    private void printInfo(String msg) {
        System.out.println("Algebraic KinSolver info: " + msg);
    }

    private void processFlag(int flag) {
        this.printInfo((String)this.flagToMessage.get(flag));
    }
}

