/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ae;

import biouml.plugins.simulation.ae.AeApacheSolver;
import biouml.plugins.simulation.ae.AeModel;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.MaxIter;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.SimpleValueChecker;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.LeastSquaresConverter;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.NelderMeadSimplex;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.SimplexOptimizer;

public class AeNelderMeadSolver
extends AeApacheSolver {
    @Override
    public double[] solve(double[] initialGuess, AeModel model) throws Exception {
        this.model = model;
        double[] currentFunctionValues = model.solveAlgebraic(initialGuess);
        if (this.normOf(currentFunctionValues) <= this.ftol) {
            return initialGuess;
        }
        int equationNumber = currentFunctionValues.length;
        double[] observations = new double[equationNumber];
        LeastSquaresConverter convert = new LeastSquaresConverter((MultivariateVectorFunction)new AeApacheSolver.VectorFunction(), observations);
        NelderMeadSimplex simplex = new NelderMeadSimplex(initialGuess.length);
        SimplexOptimizer solver = new SimplexOptimizer((ConvergenceChecker)new SimpleValueChecker(1.0E-13, 1.0E-13));
        InitialGuess initialValue = new InitialGuess(initialGuess);
        PointValuePair result = solver.optimize(new OptimizationData[]{simplex, new ObjectiveFunction((MultivariateFunction)convert), initialValue, new MaxIter(this.maxIter), new MaxEval(this.maxEval), GoalType.MINIMIZE});
        this.lastResidualNorm = (Double)result.getValue();
        for (int i = 0; i < initialGuess.length; ++i) {
            initialGuess[i] = result.getPoint()[i];
        }
        return initialGuess;
    }
}

