/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ae;

import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Variable;
import biouml.plugins.simulation.ae.AeApacheSolver;
import biouml.plugins.simulation.ae.AeModel;
import biouml.plugins.simulation.java.JavaSimulationEngine;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresBuilder;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LevenbergMarquardtOptimizer;
import org.apache.commons.math3.linear.DiagonalMatrix;
import org.apache.commons.math3.linear.RealMatrix;

public class AeLevenbergMarquardSolver
extends AeApacheSolver {
    private Map<Integer, Set<Integer>> influenceMap = null;

    @Override
    public double[] solve(double[] initialGuess, AeModel model) throws Exception {
        this.model = model;
        double[] currentFunctionValues = model.solveAlgebraic(initialGuess);
        if (this.normOf(currentFunctionValues) <= this.ftol) {
            return initialGuess;
        }
        LevenbergMarquardtOptimizer solver = new LevenbergMarquardtOptimizer();
        int equationNumber = currentFunctionValues.length;
        double[] observations = new double[equationNumber];
        LeastSquaresBuilder builder = new LeastSquaresBuilder();
        builder.model((MultivariateVectorFunction)new AeApacheSolver.VectorFunction(), (MultivariateMatrixFunction)new JacobianFunction());
        builder.maxIterations(this.maxIter);
        builder.maxEvaluations(this.maxEval);
        builder.start(initialGuess);
        builder.target(observations);
        double[] weight = new double[equationNumber];
        for (int i = 0; i < weight.length; ++i) {
            weight[i] = 1.0;
        }
        builder.weight((RealMatrix)new DiagonalMatrix(weight));
        LeastSquaresOptimizer.Optimum result = solver.optimize(builder.build());
        this.lastResidualNorm = this.normOf(result.getResiduals().toArray());
        for (int i = 0; i < initialGuess.length; ++i) {
            initialGuess[i] = result.getPoint().toArray()[i];
        }
        return initialGuess;
    }

    public void createInfluenceMap(JavaSimulationEngine engine) {
        this.influenceMap = new HashMap<Integer, Set<Integer>>();
        try {
            Map<Integer, Set<String>> equationToVarIndexMap = AeLevenbergMarquardSolver.createEquationInfluenceMap(engine);
            Map<String, Integer> varIndexMap = AeLevenbergMarquardSolver.createVarIndexMap(engine);
            for (Map.Entry<Integer, Set<String>> entry : equationToVarIndexMap.entrySet()) {
                for (String varName : entry.getValue()) {
                    this.influenceMap.computeIfAbsent(varIndexMap.get(varName), k -> new HashSet()).add(entry.getKey());
                }
            }
        }
        catch (Throwable t) {
            this.influenceMap = null;
        }
    }

    public static Map<String, Integer> createVarIndexMap(JavaSimulationEngine engine) {
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        int i = 0;
        for (Variable var : engine.getExecutableModel().getVariables()) {
            if (!engine.isAlgebraic(var.getName())) continue;
            indexMap.put(var.getName(), i);
            ++i;
        }
        return indexMap;
    }

    public static Map<Integer, Set<String>> createEquationInfluenceMap(JavaSimulationEngine engine) {
        HashMap<Integer, Set<String>> equationToVarIndexMap = new HashMap<Integer, Set<String>>();
        int i = 0;
        Map<String, Integer> varIndexMapping = engine.getVarIndexMapping();
        for (Equation eq : engine.getExecutableModel().getAlgebraic()) {
            String delimiters = " ()+-/%*^";
            StringTokenizer tokens = new StringTokenizer(eq.getFormula().trim(), delimiters, false);
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (varIndexMapping.get(token) == null) continue;
                equationToVarIndexMap.computeIfAbsent(i, k -> new HashSet()).add(token);
            }
            ++i;
        }
        return equationToVarIndexMap;
    }

    private class JacobianFunction
    implements MultivariateMatrixFunction {
        private static final double EPS = 1.0E-4;

        private JacobianFunction() {
        }

        public double[][] value(double[] x) {
            AeApacheSolver.VectorFunction function = new AeApacheSolver.VectorFunction();
            double[] f = function.value(x);
            double[][] jacobian = new double[f.length][x.length];
            for (int j = 0; j < x.length; ++j) {
                double temp = x[j];
                double h = 1.0E-4 * Math.abs(temp);
                if (h < 1.0E-4) {
                    h = 1.0E-4;
                }
                x[j] = temp + h;
                double[] fResult = function.value(x);
                x[j] = temp;
                if (AeLevenbergMarquardSolver.this.influenceMap != null && AeLevenbergMarquardSolver.this.influenceMap.get(j) != null) {
                    for (Integer index : (Set)AeLevenbergMarquardSolver.this.influenceMap.get(j)) {
                        jacobian[index.intValue()][j] = (fResult[index] - f[index]) / h;
                    }
                    continue;
                }
                for (int i = 0; i < f.length; ++i) {
                    jacobian[i][j] = (fResult[i] - f[i]) / h;
                }
            }
            return jacobian;
        }
    }
}

