/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ae;

import biouml.plugins.simulation.ae.AeApacheSolver;
import biouml.plugins.simulation.ae.AeModel;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.MaxIter;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.SimpleValueChecker;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.LeastSquaresConverter;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunctionGradient;
import org.apache.commons.math3.optim.nonlinear.scalar.gradient.NonLinearConjugateGradientOptimizer;

public class AeConjugateGradientSolver
extends AeApacheSolver {
    @Override
    public double[] solve(double[] initialGuess, AeModel model) throws Exception {
        this.model = model;
        double[] currentFunctionValues = model.solveAlgebraic(initialGuess);
        if (this.normOf(currentFunctionValues) <= this.ftol) {
            return initialGuess;
        }
        int equationNumber = currentFunctionValues.length;
        double[] observations = new double[equationNumber];
        LeastSquaresConverter convert = new LeastSquaresConverter((MultivariateVectorFunction)new AeApacheSolver.VectorFunction(), observations);
        NonLinearConjugateGradientOptimizer solver = new NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer.Formula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-13, 1.0E-13));
        InitialGuess initialValue = new InitialGuess(initialGuess);
        ObjectiveFunctionGradient objectiveFunctionGradient = new ObjectiveFunctionGradient((MultivariateVectorFunction)new JacobianFunction((MultivariateFunction)convert));
        PointValuePair result = solver.optimize(new OptimizationData[]{new ObjectiveFunction((MultivariateFunction)convert), initialValue, objectiveFunctionGradient, new MaxIter(this.maxIter), new MaxEval(this.maxEval), GoalType.MINIMIZE});
        this.lastResidualNorm = (Double)result.getValue();
        for (int i = 0; i < initialGuess.length; ++i) {
            initialGuess[i] = result.getPoint()[i];
        }
        return initialGuess;
    }

    private static class JacobianFunction
    implements MultivariateVectorFunction {
        private static final double EPS = 1.0E-7;
        private final MultivariateFunction function;

        public JacobianFunction(MultivariateFunction function) {
            this.function = function;
        }

        public double[] value(double[] x) {
            double f = this.function.value(x);
            double[] jacobian = new double[x.length];
            for (int j = 0; j < x.length; ++j) {
                double temp = x[j];
                double h = 1.0E-7 * Math.abs(temp);
                if (h < 1.0E-7) {
                    h = 1.0E-7;
                }
                x[j] = temp + h;
                double fResult = this.function.value(x);
                x[j] = temp;
                jacobian[j] = (fResult - f) / h;
            }
            return jacobian;
        }
    }
}

