/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ae;

import biouml.plugins.simulation.Options;
import biouml.plugins.simulation.ae.AeModel;
import biouml.plugins.simulation.ae.AeSolver;
import com.developmentontheedge.beans.annot.PropertyName;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;

public abstract class AeApacheSolver
extends Options
implements AeSolver {
    protected double ftol = 1.0E-6;
    protected int maxIter = 1000;
    protected int maxEval = 1000;
    protected double lastResidualNorm = 0.0;
    protected AeModel model;

    @Override
    public boolean isSuccess() {
        return this.lastResidualNorm <= this.ftol;
    }

    @Override
    public String getMessage() {
        if (this.isSuccess()) {
            return "";
        }
        return "Problem is unsolvable or function value (" + this.lastResidualNorm + ") is bigger than permissible function tolerance (" + this.ftol + ").";
    }

    protected double normOf(double[] residual) {
        double norm = 0.0;
        for (double r : residual) {
            norm += r * r;
        }
        norm = Math.sqrt(norm);
        return norm;
    }

    @PropertyName(value="Function tolerance")
    public double getFtol() {
        return this.ftol;
    }

    public void setFtol(double ftol) {
        Double oldValue = this.ftol;
        this.ftol = ftol;
        this.firePropertyChange("ftol", oldValue, ftol);
    }

    @PropertyName(value="Max iterations")
    public int getMaxIter() {
        return this.maxIter;
    }

    public void setMaxIter(int maxIter) {
        Integer oldValue = this.maxIter;
        this.maxIter = maxIter;
        this.firePropertyChange("maxIter", oldValue, maxIter);
    }

    @PropertyName(value="Max evaluations")
    public int getMaxEval() {
        return this.maxEval;
    }

    public void setMaxEval(int maxIter) {
        Integer oldValue = this.maxEval;
        this.maxEval = maxIter;
        this.firePropertyChange("maxEval", oldValue, maxIter);
    }

    protected class VectorFunction
    implements MultivariateVectorFunction {
        protected VectorFunction() {
        }

        public double[] value(double[] x) {
            return AeApacheSolver.this.model.solveAlgebraic(x);
        }
    }
}

