/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.plugins.simulation.Span;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class UniformSpan
implements Span {
    private final TreeMap<Integer, Double> additionalPoints;
    private final TreeMap<Integer, Integer> smallerPointsNumber;
    private final double t0;
    private final double tf;
    private final double incN;
    private final double incD;
    private int length;
    private final boolean proper;
    private final int uniformLength;

    public UniformSpan(double a, double b, double inc) {
        this(a, b, inc, 0.0);
    }

    public UniformSpan(double a, double b, double incN, double incD) {
        if (incD == 0.0) {
            double length = (b - a) / incN;
            if ((length - Math.floor(length + 0.5)) / length < 1.0E-5) {
                incN = b - a;
                incD = Math.floor(length + 0.5);
            } else {
                incD = 1.0;
            }
        }
        this.t0 = a;
        this.tf = b;
        this.incN = incN;
        this.incD = incD;
        this.proper = b >= a && incN / incD >= 0.0;
        this.length = (int)Math.floor((b - a) * incD / incN) + 1;
        this.additionalPoints = new TreeMap();
        this.smallerPointsNumber = new TreeMap();
        if (this.t0 + this.incN * (double)(this.length - 1) / this.incD != this.tf) {
            ++this.length;
        }
        this.uniformLength = this.length = Math.max(this.length, 0);
    }

    @Override
    public double getTimeStart() {
        return this.getTime(0);
    }

    @Override
    public double getTimeFinal() {
        return this.getTime(this.length - 1);
    }

    public double getTimeIncrement() {
        return this.incN / this.incD;
    }

    @Override
    public double getTime(int i) throws IndexOutOfBoundsException {
        if (i >= this.length) {
            throw new IndexOutOfBoundsException("ArraySpan index " + i + "> " + this.getLength());
        }
        if (this.additionalPoints.containsKey(i)) {
            return this.additionalPoints.get(i);
        }
        if (i == 0) {
            return this.t0;
        }
        if (i == this.length - 1) {
            return this.tf;
        }
        int smallerAdditionalPoints = 0;
        Integer key = this.smallerPointsNumber.floorKey(i);
        if (key != null) {
            smallerAdditionalPoints = this.smallerPointsNumber.get(key);
        }
        return this.t0 + this.incN * (double)(i - smallerAdditionalPoints) / this.incD;
    }

    private double getUniformPoint(int i) {
        return this.t0 + this.incN * (double)i / this.incD;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public boolean isProper() {
        return this.proper;
    }

    @Override
    public Span getRestrictedSpan(double a, double b) {
        if (b < a) {
            return new UniformSpan(a, b, this.incN, this.incD);
        }
        double endValue = b >= this.tf ? this.tf : this.getUniformPoint((int)Math.floor((b - this.t0) * this.incD / this.incN));
        double startValue = a < this.t0 ? this.t0 : this.getUniformPoint((int)Math.ceil((a - this.t0) * this.incD / this.incN));
        boolean startFromA = startValue == a;
        boolean endWithB = endValue == b;
        UniformSpan result = new UniformSpan(startValue, endValue, this.getTimeIncrement());
        HashSet<Double> newPoints = new HashSet<Double>();
        if (!startFromA) {
            newPoints.add(a);
        }
        if (!endWithB) {
            newPoints.add(b);
        }
        for (Double additionalValue : this.additionalPoints.values()) {
            if (!(additionalValue > a) || !(additionalValue < b)) continue;
            newPoints.add(additionalValue);
        }
        result.addPoints(newPoints);
        return result;
    }

    @Override
    public void addPoints(double[] points) {
        HashSet<Double> PointsSet = new HashSet<Double>();
        for (double point : points) {
            PointsSet.add(point);
        }
        this.addPoints(PointsSet);
    }

    public void addPoints(HashSet<Double> points) {
        TreeSet<Double> newPoints = new TreeSet<Double>(points);
        if (!this.additionalPoints.isEmpty()) {
            newPoints.addAll(this.additionalPoints.values());
            this.additionalPoints.clear();
        }
        int i = 0;
        for (Double point : newPoints) {
            int uniformSpanPoints;
            if (point > this.tf) {
                uniformSpanPoints = this.uniformLength;
            } else {
                uniformSpanPoints = Math.max(0, (int)Math.ceil((point - this.t0) * this.incD / this.incN));
                if (this.equals(this.getUniformPoint(uniformSpanPoints), point, 1.0E-7)) continue;
            }
            this.additionalPoints.put(uniformSpanPoints + i, point);
            this.smallerPointsNumber.put(uniformSpanPoints + i, i + 1);
            ++i;
        }
        this.length += i;
    }

    private boolean equals(double a, double b, double accuracy) {
        return Math.abs(a - b) < accuracy * (a + b);
    }

    @Override
    public UniformSpan clone() {
        return new UniformSpan(this.t0, this.tf, this.incN, this.incD);
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        result.add("t0", this.t0);
        result.add("tf", this.tf);
        result.add("incN", this.incN);
        result.add("incD", this.incD);
        JsonArray values = new JsonArray();
        for (Double value : this.additionalPoints.values()) {
            values.add(value.doubleValue());
        }
        result.add("additionalPoints", (JsonValue)values);
        return result;
    }

    public void fromJson(JsonObject json) {
    }

    public String toString() {
        return this.toJson().toString();
    }

    public static UniformSpan createInstance(String str) {
        JsonObject json = JsonObject.readFrom((String)str);
        double t0 = json.getDouble("t0", 0.0);
        double tf = json.getDouble("tf", 1.0);
        double incN = json.getDouble("incN", 1.0);
        double incD = json.getDouble("incD", 1.0);
        UniformSpan result = new UniformSpan(t0, tf, incN, incD);
        JsonValue values = json.get("additionalPoints");
        if (values != null && values instanceof JsonArray) {
            HashSet<Double> valueSet = new HashSet<Double>();
            JsonArray valuesArray = (JsonArray)values;
            for (JsonValue value : valuesArray) {
                valueSet.add(value.asDouble());
            }
            result.addPoints(valueSet);
        }
        return result;
    }
}

