/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Node;
import biouml.model.SemanticController;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.SimpleTableElement;
import biouml.model.dynamics.TableElement;
import biouml.model.dynamics.util.EModelHelper;
import biouml.plugins.simulation.Preprocessor;
import javax.annotation.Nonnull;
import ru.biosoft.access.exception.BiosoftCustomException;
import ru.biosoft.analysis.Util;
import ru.biosoft.table.TableDataCollection;
import ru.biosoft.table.TableDataCollectionUtils;
import ru.biosoft.util.TextUtil;

public class TableElementPreprocessor
extends Preprocessor {
    SemanticController controller;

    @Override
    public Diagram preprocess(Diagram diagram) {
        if (!this.accept(diagram)) {
            return diagram;
        }
        this.controller = diagram.getType().getSemanticController();
        this.processTableElements((Compartment)diagram);
        return diagram;
    }

    public void processTableElements(Compartment compartment) {
        for (Node node : compartment.getNodes()) {
            if (node.getRole() instanceof TableElement) {
                try {
                    compartment.remove(node.getName());
                    this.processTableElement(compartment, node);
                    continue;
                }
                catch (Exception ex) {
                    throw new BiosoftCustomException((Throwable)ex, "Error during node " + node.getName() + " preprocessing: " + ex.getMessage());
                }
            }
            if (node.getRole() instanceof SimpleTableElement) {
                try {
                    compartment.remove(node.getName());
                    TableElementPreprocessor.processSimpleTableElement(compartment, node);
                    continue;
                }
                catch (Exception ex) {
                    throw new BiosoftCustomException((Throwable)ex, "Error during node " + node.getName() + " preprocessing: " + ex.getMessage());
                }
            }
            if (!(node instanceof Compartment)) continue;
            this.processTableElements((Compartment)node);
        }
    }

    public static void processSimpleTableElement(@Nonnull Compartment compartment, Node node) throws Exception {
        SimpleTableElement tableElement = (SimpleTableElement)node.getRole(SimpleTableElement.class);
        TableDataCollection table = tableElement.getTable();
        if (table == null) {
            throw new Exception("Please specufy table data collection for element " + node.getTitle());
        }
        SimpleTableElement.VarColumn argColumn = tableElement.getArgColumn();
        SimpleTableElement.VarColumn[] columns = tableElement.getColumns();
        String argName = argColumn.getVariable();
        String argColumnName = argColumn.getColumn();
        double[] arg = TableDataCollectionUtils.getColumn((TableDataCollection)table, (String)argColumnName);
        SemanticController controller = Diagram.getDiagram((DiagramElement)compartment).getType().getSemanticController();
        for (int i = 0; i < columns.length; ++i) {
            SimpleTableElement.VarColumn var = columns[i];
            String varName = var.getVariable();
            String columnName = var.getColumn();
            double[] values = TableDataCollectionUtils.getColumn((TableDataCollection)table, (String)columnName);
            String rightHandSide = TableElementPreprocessor.generatePiecewise(argName, arg, values);
            Equation eq = new Equation(null, "scalar", varName);
            eq.setFormula(rightHandSide);
            DiagramElement de = controller.createInstance(compartment, Equation.class, node.getLocation(), (Object)eq).getElement();
            compartment.put(de);
        }
    }

    private void processTableElement(@Nonnull Compartment compartment, Node node) throws Exception {
        TableElement.Variable[] tableVars;
        TableElement tableElement = (TableElement)node.getRole(TableElement.class);
        TableDataCollection table = tableElement.getTable();
        if (table == null) {
            throw new Exception("Please specufy table data collection for element " + node.getTitle());
        }
        String formula = tableElement.getFormula();
        String leftCol = null;
        String rightCol = null;
        String[] vars = TextUtil.split((String)formula, (char)'~');
        if (vars.length != 2) {
            throw new Exception("Illegal formula in table element " + node.getName() + " : " + formula);
        }
        vars[0] = vars[0].trim();
        vars[1] = vars[1].trim();
        for (TableElement.Variable var : tableVars = tableElement.getVariables()) {
            if (var.getName().equals(vars[0])) {
                leftCol = var.getColumnName();
                continue;
            }
            if (!var.getName().equals(vars[1])) continue;
            rightCol = var.getColumnName();
        }
        if (leftCol == null || rightCol == null) {
            throw new Exception("Illegal formula in table element " + node.getName() + " : " + formula);
        }
        double[] timeValues = TableDataCollectionUtils.getColumn((TableDataCollection)table, rightCol);
        double[] values = TableDataCollectionUtils.getColumn((TableDataCollection)table, leftCol);
        if (timeValues == null || values == null) {
            throw new Exception("Error during data from table = " + table.getName() + " processing, probbaly data is missing");
        }
        int[] pos = Util.sort((double[])timeValues);
        double[] newValues = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            newValues[i] = values[pos[i]];
        }
        if (tableElement.isCycled()) {
            double maxValue = timeValues[values.length - 1];
            double minValue = timeValues[0];
            double length = maxValue - minValue;
            EModel emodel = (EModel)compartment.getRole(EModel.class);
            String newArg = EModelHelper.generateUniqueVariableName((EModel)emodel, (String)vars[1]);
            Equation addiditonalEquation = new Equation(null, "scalar", newArg);
            addiditonalEquation.setFormula("mod( " + vars[1] + " - " + minValue + "+ (Math.round(" + minValue + "/" + length + ")+1)*" + length + ", " + length + ")");
            vars[1] = newArg;
            DiagramElement de = this.controller.createInstance(compartment, Equation.class, node.getLocation(), (Object)addiditonalEquation).getElement();
            compartment.put(de);
            int i = 0;
            while (i < timeValues.length) {
                int n = i++;
                timeValues[n] = timeValues[n] - minValue;
            }
        }
        Util.CubicSpline spline = new Util.CubicSpline(timeValues, newValues);
        Equation eq = new Equation(null, "scalar", vars[0]);
        eq.setFormula(TableElementPreprocessor.generateFormula(spline, vars[1]));
        DiagramElement de = this.controller.createInstance(compartment, Equation.class, node.getLocation(), (Object)eq).getElement();
        compartment.put(de);
    }

    @Override
    public boolean accept(Diagram diagram) {
        return diagram.stream(Node.class).anyMatch(node -> node.getRole() instanceof TableElement || node.getRole() instanceof SimpleTableElement);
    }

    public static String generateFormula(Util.CubicSpline spline, String argName) {
        double[] x = spline.getArgument();
        double[] a = spline.getA();
        double[] b = spline.getB();
        double[] c = spline.getC();
        double[] d = spline.getD();
        StringBuffer formula = new StringBuffer("piecewise(");
        formula.append("(");
        formula.append(argName);
        formula.append("<");
        formula.append(x[0]);
        formula.append(")=>");
        formula.append(a[0]);
        formula.append(";");
        for (int i = 0; i < x.length; ++i) {
            StringBuffer condition = new StringBuffer();
            condition.append("(");
            condition.append(argName);
            condition.append(">=");
            condition.append(x[i]);
            condition.append(")");
            if (i < x.length - 1) {
                condition.append("&&(");
                condition.append(argName);
                condition.append("<");
                condition.append(x[i + 1]);
                condition.append(")");
            }
            String diff = x[i] == 0.0 ? argName : "(" + argName + "-" + x[i] + ")";
            StringBuffer value = new StringBuffer();
            if (a[i] != 0.0) {
                value.append(a[i]);
            }
            if (b[i] != 0.0) {
                if (b[i] > 0.0) {
                    value.append("+");
                }
                value.append(b[i]);
                value.append("*");
                value.append(diff);
            }
            if (c[i] != 0.0) {
                if (c[i] > 0.0) {
                    value.append("+");
                }
                value.append(c[i]);
                value.append("*");
                value.append(diff);
                value.append("^2");
            }
            if (d[i] != 0.0) {
                if (d[i] > 0.0) {
                    value.append("+");
                }
                value.append(d[i]);
                value.append("*");
                value.append(diff);
                value.append("^3");
            }
            if (value.length() == 0) {
                value.append("0");
            }
            if (i != x.length - 1) {
                value.append(";");
            } else {
                value.append(")");
            }
            formula.append(condition);
            formula.append("=>");
            formula.append(value);
        }
        return formula.toString();
    }

    public static String generatePiecewise(String argName, double[] time, double[] values) {
        StringBuffer result = new StringBuffer();
        result.append("piecewise( ");
        double curValue = Double.NaN;
        for (int i = 0; i < time.length - 1; ++i) {
            double nextValue = values[i];
            if (Double.isNaN(nextValue)) continue;
            if (!Double.isNaN(curValue) && nextValue != curValue) {
                result.append(argName + " < " + time[i] + " => " + curValue + "; ");
            }
            curValue = nextValue;
        }
        result.append(curValue + " );");
        return result.toString();
    }
}

