/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.dynamics.plot.PlotInfo;
import biouml.plugins.simulation.CycledResultListener;
import biouml.plugins.simulation.ResultPlotPane;
import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.UniformSpan;
import biouml.plugins.simulation.plot.PlotPane;
import biouml.standard.simulation.StochasticSimulationResult;
import biouml.standard.simulation.plot.Plot;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import one.util.streamex.StreamEx;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.AbstractSeriesDataset;
import org.jfree.data.general.Series;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import ru.biosoft.analysis.Util;
import ru.biosoft.graphics.Pen;
import ru.biosoft.jobcontrol.FunctionJobControl;

public class StochasticResultPlotPane
extends JPanel
implements CycledResultListener {
    private static final String DEFAULT_Y_AXIS_LABEL = "Quantity or concentration";
    public static final Paint[] POSSIBLE_COLORS = new Paint[]{new Color(255, 85, 85), new Color(85, 85, 255), new Color(0, 255, 0), Color.pink, ChartColor.DARK_RED, ChartColor.DARK_BLUE, ChartColor.DARK_GREEN, ChartColor.DARK_MAGENTA, ChartColor.DARK_CYAN, Color.darkGray, ChartColor.VERY_DARK_RED, ChartColor.VERY_DARK_BLUE, ChartColor.VERY_DARK_GREEN, ChartColor.VERY_DARK_YELLOW, ChartColor.VERY_DARK_MAGENTA, ChartColor.VERY_DARK_CYAN};
    protected YIntervalSeriesCollection dataset;
    protected JFreeChart chart;
    protected List<double[][]> values;
    private Map<Integer, Integer> varIndexInPlot;
    protected ChartPanel chartPanel;
    protected PlotInfo plotInfo = null;
    protected SimulationEngine.Var xVariable;
    protected Map<SimulationEngine.Var, List<Series>> variableIndeces;
    protected FunctionJobControl jobControl;
    protected SimulationEngine simulationEngine;
    protected Dimension paneSize = new Dimension(500, 270);
    protected int currentCycle;
    protected int spanIndex;
    private int spanSize;
    private DeviationRenderer renderer;

    public StochasticResultPlotPane(SimulationEngine simulationEngine, FunctionJobControl jobControl, PlotInfo plotInfo) {
        this.simulationEngine = simulationEngine;
        this.spanSize = new UniformSpan(simulationEngine.getInitialTime(), simulationEngine.getCompletionTime(), simulationEngine.getTimeIncrement()).getLength();
        this.jobControl = jobControl;
        this.plotInfo = plotInfo;
    }

    public SimulationEngine getSimulationEngine() {
        return this.simulationEngine;
    }

    protected void createChartPanel() {
        this.xVariable = this.simulationEngine.getXVariable(this.plotInfo);
        String yAxisLabel = this.variableIndeces.size() == 1 ? StreamEx.of(this.variableIndeces.keySet()).findFirst().map(v -> v.title).get() : DEFAULT_Y_AXIS_LABEL;
        this.chart = ChartFactory.createXYLineChart((String)(this.plotInfo != null ? this.plotInfo.getTitle() : "Simulation result"), (String)this.xVariable.title, (String)yAxisLabel, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chart.setBackgroundPaint((Paint)Color.white);
        this.chart.getLegend().setBorder(1.0, 1.0, 1.0, 1.0);
        this.chartPanel = new ChartPanel(this.chart);
        this.renderer = new DeviationRenderer();
        this.renderer.setDrawSeriesLineAsPath(true);
        XYPlot plot = this.chart.getXYPlot();
        ValueAxis axis = PlotPane.generateAxis(Plot.AxisType.getAxisType((String)this.plotInfo.getXAxisType()));
        if (axis != null) {
            plot.setDomainAxis(axis);
        }
        if (this.plotInfo.getXFrom() != this.plotInfo.getXTo()) {
            plot.getDomainAxis().setLowerBound(this.plotInfo.getXFrom());
            plot.getDomainAxis().setUpperBound(this.plotInfo.getXTo());
        } else {
            plot.getDomainAxis().setLowerBound(this.simulationEngine.getInitialTime());
            plot.getDomainAxis().setUpperBound(this.simulationEngine.getCompletionTime());
        }
        plot.getDomainAxis().setAutoRange(this.plotInfo.isXAutoRange());
        axis = PlotPane.generateAxis(Plot.AxisType.getAxisType((String)this.plotInfo.getYAxisType()));
        if (axis != null) {
            plot.setRangeAxis(axis);
        }
        if (this.plotInfo.getYFrom() != this.plotInfo.getYTo()) {
            plot.getRangeAxis().setLowerBound(this.plotInfo.getYFrom());
            plot.getRangeAxis().setUpperBound(this.plotInfo.getYTo());
        }
        plot.getRangeAxis().setAutoRange(this.plotInfo.isYAutoRange());
        plot.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(POSSIBLE_COLORS, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
        this.dataset = new YIntervalSeriesCollection();
        this.initSeries((XYLineAndShapeRenderer)this.renderer, this.dataset);
        if (this.plotInfo.getExperiments() != null) {
            ResultPlotPane.addExperiments(this.plotInfo.getExperiments(), (XYLineAndShapeRenderer)this.renderer, (AbstractSeriesDataset)this.dataset, this.simulationEngine.getCompletionTime());
        }
        this.chart.getXYPlot().setBackgroundPaint((Paint)Color.white);
        this.chart.getXYPlot().setRenderer((XYItemRenderer)this.renderer);
        this.chart.getXYPlot().setDataset((XYDataset)this.dataset);
    }

    protected void initSeries(XYLineAndShapeRenderer renderer, YIntervalSeriesCollection dataset) {
        int counter = 0;
        for (Map.Entry<SimulationEngine.Var, List<Series>> e : this.variableIndeces.entrySet()) {
            SimulationEngine.Var var = e.getKey();
            List<Series> seriesList = e.getValue();
            if (seriesList == null) continue;
            for (int i = 0; i < seriesList.size(); ++i) {
                YIntervalSeries series = (YIntervalSeries)seriesList.get(i);
                Pen spec = var.pen;
                if (spec != null) {
                    renderer.setSeriesPaint(counter, (Paint)spec.getColor());
                    renderer.setSeriesStroke(counter, (Stroke)spec.getStroke());
                    renderer.setSeriesFillPaint(counter, (Paint)spec.getColor());
                    renderer.setSeriesVisibleInLegend(counter, Boolean.valueOf(i == 0));
                }
                renderer.setSeriesShapesVisible(counter, false);
                ++counter;
                dataset.addSeries(series);
            }
        }
    }

    protected Map<SimulationEngine.Var, List<Series>> getVariables() {
        return this.simulationEngine.getVariablesToPlot(this.plotInfo);
    }

    protected void createUI() {
        this.createChartPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbl.setConstraints(this, gbc);
        this.setLayout(gbl);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)this.chartPanel, new GridBagConstraints(0, 0, 1, 5, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        if (this.jobControl != null) {
            JPanel buttonPanel = new JPanel(new BorderLayout());
            this.add((Component)buttonPanel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            JButton stopButton = new JButton("Stop");
            buttonPanel.add((Component)stopButton, "East");
            buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            stopButton.addActionListener(ae -> {
                this.simulationEngine.stopSimulation();
                this.jobControl.terminate();
            });
        }
        JFrame frame = new JFrame(this.chartPanel.getChart().getTitle().getText());
        frame.setSize(700, 700);
        frame.getContentPane().setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        frame.getContentPane().add((Component)mainPanel, "Center");
        mainPanel.add((Component)this, "Center");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StochasticResultPlotPane.this.simulationEngine.stopSimulation();
                if (StochasticResultPlotPane.this.jobControl != null) {
                    StochasticResultPlotPane.this.jobControl.terminate();
                }
            }
        });
    }

    public void add(double t, double[] y) {
        if (this.currentCycle == 0) {
            this.addAsFirst(t, y);
        } else {
            this.update(t, y);
        }
        ++this.spanIndex;
    }

    public void start(Object model) {
        this.currentCycle = 0;
        this.spanIndex = 0;
        this.variableIndeces = this.getVariables();
        this.varIndexInPlot = new HashMap<Integer, Integer>();
        int i = 0;
        for (Map.Entry<SimulationEngine.Var, List<Series>> e : this.variableIndeces.entrySet()) {
            this.varIndexInPlot.put(e.getKey().index, i);
            ++i;
        }
        this.values = new ArrayList<double[][]>();
        this.values.add(new double[this.variableIndeces.size()][this.spanSize]);
        this.createUI();
    }

    @Override
    public final void startCycle() {
        ++this.currentCycle;
        this.spanIndex = 0;
        for (List<Series> list : this.variableIndeces.values()) {
            for (Series s : list) {
                ((YIntervalSeries)s).clear();
            }
        }
        this.values.add(new double[this.variableIndeces.size()][this.spanSize]);
    }

    @Override
    public void addAsFirst(double t, double[] y) {
        double[][] vals = this.values.get(0);
        for (Map.Entry<SimulationEngine.Var, List<Series>> e : this.variableIndeces.entrySet()) {
            int varIndex = e.getKey().index;
            int index = this.varIndexInPlot.get(varIndex);
            vals[index][this.spanIndex] = y[varIndex];
            Series s = e.getValue().get(0);
            ((YIntervalSeries)s).add(y[this.xVariable.index], y[varIndex], y[varIndex], y[varIndex]);
        }
    }

    @Override
    public void update(double t, double[] y) {
        double[][] vals = this.values.get(this.currentCycle);
        for (Map.Entry<SimulationEngine.Var, List<Series>> e : this.variableIndeces.entrySet()) {
            int varIndex = e.getKey().index;
            int xIndex = this.xVariable.index;
            int index = this.varIndexInPlot.get(varIndex);
            vals[index][this.spanIndex] = y[varIndex];
            Series s = e.getValue().get(0);
            if (this.currentCycle >= 3) {
                double[] variableValues = new double[this.currentCycle + 1];
                for (int k = 0; k <= this.currentCycle; ++k) {
                    variableValues[k] = this.values.get(k)[index][this.spanIndex];
                }
                Util.sort((double[])variableValues);
                double median = StochasticSimulationResult.median((double[])variableValues);
                double q1 = StochasticSimulationResult.quartile1((double[])variableValues);
                double q3 = StochasticSimulationResult.quartile3((double[])variableValues);
                ((YIntervalSeries)s).add(y[xIndex], median, q1, q3);
                continue;
            }
            ((YIntervalSeries)s).add(y[xIndex], y[varIndex], y[varIndex], y[varIndex]);
        }
    }

    @Override
    public void finish() {
    }
}

