/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.util.EModelHelper;
import biouml.plugins.simulation.Preprocessor;
import java.awt.Point;
import ru.biosoft.access.core.DataElement;

public class StaticModelPreprocessor
extends Preprocessor {
    @Override
    public Diagram preprocess(Diagram diagram) throws Exception {
        if (!this.accept(diagram)) {
            return diagram;
        }
        EModel eModel = (EModel)diagram.getRole(EModel.class);
        String name = EModelHelper.generateUniqueVariableName((EModel)eModel, (String)"t");
        eModel.getVariables().put((DataElement)new Variable(name, eModel, eModel.getVariables()));
        Equation eq = new Equation(null, "rate", name, "1");
        DiagramElement de = diagram.getType().getSemanticController().createInstance((Compartment)diagram, Equation.class, new Point(0, 0), (Object)eq).getElement();
        diagram.put(de);
        return diagram;
    }

    @Override
    public boolean accept(Diagram diagram) {
        Role role = diagram.getRole();
        if (!(role instanceof EModel)) {
            return false;
        }
        EModel eModel = (EModel)role;
        int type = eModel.getModelType();
        return !EModel.isOfType((int)type, (int)2);
    }
}

