/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Role;
import biouml.model.SemanticController;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.State;
import biouml.model.dynamics.Transition;
import biouml.model.dynamics.Variable;
import biouml.plugins.simulation.Preprocessor;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import ru.biosoft.math.model.AstConstant;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.Function;
import ru.biosoft.math.model.LinearFormatter;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.PredefinedFunction;
import ru.biosoft.math.model.Utils;

public class StateTransitionPreprocessor
extends Preprocessor {
    protected static final String CURRENT_STATE_NAME = "currentState";
    protected static final String CURRENT_STATE_TIME_NAME = "currentStateTime";
    protected Map<String, Integer> statesNumbers = new HashMap<String, Integer>();
    protected int stateValue = 0;
    protected double startState = 0.0;

    public Map<String, Integer> getStateIndexMapping() {
        return this.statesNumbers;
    }

    @Override
    public Diagram preprocess(Diagram diagram) throws Exception {
        EModel emodel = (EModel)diagram.getRole(EModel.class);
        for (State state : emodel.getStates()) {
            this.registerState(state);
        }
        Transition[] transitions = emodel.getTransitions();
        if (transitions.length > 0) {
            String stateVarName = StateTransitionPreprocessor.generateUniqueVar(emodel, CURRENT_STATE_NAME);
            String stateTimeVarName = StateTransitionPreprocessor.generateUniqueVar(emodel, CURRENT_STATE_TIME_NAME);
            for (Transition st : transitions) {
                AstStart trigger = emodel.readMath(st.getWhen(), (Role)st);
                if (trigger == null) {
                    trigger = new AstStart(0);
                    Node astVal1 = emodel.readMath(st.getAfter(), (Role)st).jjtGetChild(0);
                    Node plus = Utils.applyPlus((Node[])new Node[]{astVal1, Utils.createVariabl((String)stateTimeVarName)});
                    Node fun = Utils.applyFunction((Node[])new Node[]{Utils.createVariabl((String)"time"), plus}, (Function)new PredefinedFunction(">", 2, -1));
                    trigger.jjtAddChild(fun, 0);
                }
                Node eq = Utils.applyFunction((Node[])new Node[]{Utils.createVariabl((String)stateVarName), Utils.createConstant((Object)this.statesNumbers.get(st.getFrom().getName()))}, (Function)new PredefinedFunction("==", 2, -1));
                Node and = Utils.applyFunction((Node[])new Node[]{eq, trigger.jjtGetChild(0)}, (Function)new PredefinedFunction("&&", 2, -1));
                AstStart updatedTrigger = new AstStart(0);
                updatedTrigger.jjtAddChild(and, 0);
                ArrayList<Assignment> assignments = new ArrayList<Assignment>();
                for (Assignment assignment : st.getFrom().getOnExitAssignment()) {
                    assignments.add(assignment);
                }
                AstConstant constant = Utils.createConstant((Object)this.statesNumbers.get(st.getTo().getName()));
                String line = new LinearFormatter().format(Utils.createStart((Node)constant))[1];
                assignments.add(new Assignment(stateVarName, line));
                AstVarNode timeNode = Utils.createVariabl((String)"time");
                line = new LinearFormatter().format(Utils.createStart((Node)timeNode))[1];
                assignments.add(new Assignment(stateTimeVarName, line));
                for (Assignment assignment3 : st.getTo().getOnEntryAssignment()) {
                    assignments.add(assignment3);
                }
                SemanticController semanticController = diagram.getType().getSemanticController();
                biouml.model.Node eventNode = (biouml.model.Node)semanticController.createInstance((Compartment)diagram, Event.class, new Point(), null).getElement();
                diagram.put((DiagramElement)eventNode);
                semanticController.remove(st.getDiagramElement());
                Event event = (Event)eventNode.getRole(Event.class);
                event.setTrigger(new LinearFormatter().format(updatedTrigger)[1]);
                event.setEventAssignment(assignments.toArray(new Assignment[assignments.size()]));
            }
            Variable variable = new Variable(stateVarName, emodel, null);
            variable.setInitialValue(this.startState);
            emodel.put(variable);
            Variable stateTimeVar = new Variable(stateTimeVarName, emodel, null);
            emodel.put(stateTimeVar);
        }
        return diagram;
    }

    private static String generateUniqueVar(EModel emodel, String varName) {
        emodel.declareVariable(varName, (Object)1.0);
        String result = varName;
        int i = 1;
        while (emodel.containsVariable(result)) {
            result = varName + i++;
        }
        return result;
    }

    protected void registerState(State state) {
        String name = state.getDiagramElement().getName();
        if (!this.statesNumbers.containsKey(name)) {
            this.statesNumbers.put(name, this.stateValue++);
            if (state.isStart()) {
                this.startState = this.stateValue;
            }
        }
    }
}

