/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.Simulator;
import biouml.plugins.simulation.SimulatorProfile;
import biouml.plugins.simulation.Span;
import biouml.plugins.simulation.UniformSpan;
import biouml.plugins.simulation.java.JavaBaseModel;
import biouml.plugins.simulation.ode.OdeModel;
import biouml.standard.simulation.ResultListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.DoubleStream;
import ru.biosoft.jobcontrol.FunctionJobControl;

public abstract class SimulatorSupport
implements Simulator {
    protected ResultListener[] resultListeners = null;
    protected OdeModel odeModel;
    protected static final Logger log = Logger.getLogger(SimulatorSupport.class.getName());
    protected SimulatorProfile profile = new SimulatorProfile();
    protected boolean debug = false;
    protected FunctionJobControl jobControl;
    protected Span span;
    protected String statisticsMode = "Intermediate";
    protected boolean locateEvents;
    protected boolean terminated;
    protected boolean fireInitialValues = true;
    protected boolean eventAtSpanPoint = false;
    protected boolean preprocessFastReactions = true;

    public void setStarted() {
        this.terminated = false;
    }

    public void setFireInitialValues(boolean val) {
        this.fireInitialValues = val;
    }

    public void setStatisticsMode(String mode) {
        this.statisticsMode = mode;
    }

    public SimulatorSupport() {
    }

    public SimulatorSupport(OdeModel odeModel, ResultListener[] resultListeners) throws Exception {
        this.resultListeners = resultListeners;
        this.odeModel = odeModel;
        try {
            this.profile.setX(odeModel.getInitialValues());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Cannot get initial values", e);
        }
    }

    public Span getSpan() {
        return this.span;
    }

    protected void fireSolutionUpdate(double t, double[] x) throws Exception {
        if (this.odeModel != null) {
            double[] y = this.odeModel.extendResult(t, (double[])x.clone());
            this.odeModel.updateHistory(t);
            if (this.resultListeners != null) {
                for (int i = 0; i < this.resultListeners.length; ++i) {
                    this.resultListeners[i].add(t, y);
                }
            }
        }
    }

    @Override
    public SimulatorProfile getProfile() {
        return this.profile;
    }

    @Override
    public void start(Model model, Span tspan, ResultListener[] listeners, FunctionJobControl jobControl) throws Exception {
        if (!model.isInit()) {
            model.init();
        }
        this.start(model, model.getInitialValues(), tspan, listeners, jobControl);
    }

    public void start(Model model, double[] initialValues, Span timeSpan, ResultListener[] listeners, FunctionJobControl jobControl) throws Exception {
        this.init(model, initialValues, timeSpan, listeners, jobControl);
        if (jobControl != null) {
            jobControl.functionStarted();
        }
        this.setStarted();
        while (this.doStep()) {
        }
        if (jobControl != null) {
            jobControl.functionFinished();
        }
    }

    @Override
    public void stop() {
        if (this.terminated) {
            return;
        }
        if (this.jobControl != null) {
            this.jobControl.terminate();
        }
        this.terminated = true;
    }

    public void integrationStep(double[] xNew, double[] xOld, double tOld, double step, double theta) throws Exception {
    }

    protected void outError(String message) {
        log.log(Level.SEVERE, message);
        System.out.println(message);
        System.out.println();
    }

    protected void outStatistics(String ... messages) {
        if (!this.statisticsMode.equals("On")) {
            return;
        }
        for (String message : messages) {
            log.info(message);
            System.out.println(message);
        }
        System.out.println();
    }

    protected void outIntermediate(String ... messages) {
        if (this.statisticsMode.equals("Off")) {
            return;
        }
        for (String message : messages) {
            log.info(message);
            System.out.println(message);
        }
        System.out.println();
    }

    public static boolean checkNaNs(double[] x) {
        return DoubleStream.of(x).anyMatch(v -> Double.isNaN(v) || Double.isInfinite(v));
    }

    public static double[] getNaNs(double[] x) {
        return DoubleStream.of(x).filter(v -> Double.isNaN(v) || Double.isInfinite(v)).toArray();
    }

    @Override
    public boolean doStep() throws Exception {
        throw new UnsupportedOperationException("do Step is not supported for solver: " + this.getClass().getName());
    }

    public abstract int[] getEvents();

    public void setPresimulateFastReactions(boolean preprocess) {
        this.preprocessFastReactions = preprocess;
    }

    protected double[] preprocessFastReactions() throws Exception {
        OdeModel tempModel = (OdeModel)this.odeModel.clone();
        double[] y = tempModel.getY();
        double t = tempModel.getTime();
        double h = 1.0;
        SimulatorSupport simulator = (SimulatorSupport)this.getClass().newInstance();
        ((JavaBaseModel)tempModel).setFastRegime(true);
        simulator.setPresimulateFastReactions(false);
        UniformSpan span = new UniformSpan(t, t + h, h);
        simulator.start(tempModel, y, span, null, null);
        ((JavaBaseModel)tempModel).setFastRegime(false);
        return tempModel.getY();
    }

    @Override
    public void setLogLevel(Level level) {
        log.setLevel(level);
    }
}

