/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Diagram;
import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.ParallelSimulationEngine;
import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.SimulationTaskParameters;
import biouml.plugins.simulation.Simulator;
import biouml.plugins.simulation.SimulatorProfile;
import biouml.plugins.simulation.java.JavaLargeModel;
import biouml.standard.simulation.SimulationResult;
import com.developmentontheedge.application.ApplicationUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import one.util.streamex.DoubleStreamEx;
import one.util.streamex.StreamEx;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.jobcontrol.FunctionJobControl;
import ru.biosoft.util.ObjectPool;
import ru.biosoft.util.TempFiles;

public class SimulationTask {
    protected static final Logger log = Logger.getLogger(SimulationTask.class.getName());
    protected ParallelSimulationEngine parallelEngine;
    protected SimulationTaskParameters parameters;
    protected String[] names;
    protected double[] values;
    protected double[] result;
    private File f = TempFiles.path((String)"simulationTask");
    protected Map<String, Double> parameterValues;
    protected double[] variableValues;
    private boolean firstLine = true;
    private String status;

    public SimulationTask(ParallelSimulationEngine parallelEngine, String[] names) {
        this.parallelEngine = parallelEngine;
        this.names = names;
    }

    public void setValues(double[] values) {
        this.values = values;
    }

    public void run(FunctionJobControl jobControl) throws Exception {
        this.result = this.parallelEngine.processResult(this.getResult(this.values, this.names, jobControl));
    }

    public double[] getResult() {
        return this.result;
    }

    public Object getResult(double[] values, String[] names, FunctionJobControl jobControl) throws Exception {
        try (ObjectPool.PooledObject<ParallelSimulationEngine.ModelEngine> obj = this.parallelEngine.allocModelEngine();){
            ParallelSimulationEngine.ModelEngine modelEngine = (ParallelSimulationEngine.ModelEngine)obj.get();
            if (jobControl != null) {
                modelEngine.getEngine().setJobControl(jobControl);
            }
            this.setValues(modelEngine.getEngine(), modelEngine.getBaseModel(), values, names);
            Object result = this.getResult(modelEngine.getEngine(), modelEngine.getBaseModel());
            modelEngine.getEngine().setJobControl(null);
            Object object = result;
            return object;
        }
    }

    protected Object getResult(SimulationEngine engine, Model baseModel) {
        try {
            SimulationResult sr = new SimulationResult(engine.getDiagram().getOrigin(), "");
            this.status = engine.simulate(baseModel, sr);
            SimulatorProfile profile = ((Simulator)engine.getSolver()).getProfile();
            if (this.status != null && this.status.length() > 0 || profile.isStiff() || profile.isUnstable()) {
                sr = null;
            }
            return sr;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not get simulation results: " + ExceptionRegistry.log((Throwable)e));
            return null;
        }
    }

    protected void setValues(SimulationEngine engine, Model baseModel, double[] values, String[] names) throws Exception {
        baseModel.init();
        double[] currValues = baseModel.getCurrentValues();
        for (int i = 0; i < values.length; ++i) {
            if (!engine.getVarPathIndexMapping().containsKey(names[i])) {
                throw new Exception("Variable " + names[i] + " not found in the model");
            }
            int index = engine.getVarPathIndexMapping().get(names[i]);
            currValues[index] = values[i];
        }
        baseModel.setCurrentValues(currValues);
    }

    public static SimulationEngine initEngine(Diagram diagram, SimulationTaskParameters simulationParameters, Model model) {
        SimulationEngine engineSettings = simulationParameters.getSimulationEngine();
        return SimulationTask.initEngine(diagram, engineSettings, model);
    }

    public static SimulationEngine initEngine(Diagram diagram, SimulationEngine engineSettings, Model model) {
        SimulationEngine engine = null;
        try {
            engine = (SimulationEngine)engineSettings.getClass().newInstance();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not initialize the solver settings: " + e.getMessage());
        }
        if (engine != null) {
            engine.setDiagram(diagram);
            if (model != null) {
                try {
                    Model copy = (Model)model.getClass().newInstance();
                    if (model instanceof JavaLargeModel) {
                        ((JavaLargeModel)copy).setNameToIndex(((JavaLargeModel)model).getNameToIndex());
                        engine.setModel(copy);
                    }
                }
                catch (Exception ex) {
                    engine.setModel(null);
                }
            }
            engine.setTimeIncrement(engineSettings.getTimeIncrement());
            engine.setInitialTime(engineSettings.getInitialTime());
            engine.setCompletionTime(engineSettings.getCompletionTime());
            engine.setLogLevel(Level.SEVERE);
            Simulator solver = SimulationTask.initSolver(engineSettings);
            if (solver != null) {
                engine.setSolver(solver);
            }
        }
        return engine;
    }

    public static Simulator initSolver(SimulationEngine engineSettings) {
        try {
            Simulator solver = (Simulator)engineSettings.getSolver().getClass().newInstance();
            solver.setOptions(((Simulator)engineSettings.getSolver()).getOptions());
            return solver;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not initialize the solver settings: " + e.getMessage());
            return null;
        }
    }

    public void setParameters(SimulationTaskParameters parameters) {
        this.parameters = parameters;
    }

    private void writeToFile(File file, String[] names, double[] values, double deviation, String error) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            try (BufferedWriter bw = ApplicationUtils.utfAppender((File)file);){
                if (this.firstLine) {
                    bw.append(StreamEx.of((Object[])names).prepend((Object)"Result").joining((CharSequence)"\t") + "\n");
                    this.firstLine = false;
                }
                String prefix = this.status != null && !this.status.isEmpty() ? this.status : String.valueOf(deviation);
                String result = DoubleStreamEx.of((double[])values).mapToObj(v -> String.valueOf(v)).prepend((Object)prefix).joining((CharSequence)"\t") + "\n";
                bw.append(result);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

