/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Diagram;
import biouml.model.dynamics.EModel;
import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.SimulationEngineRegistry;
import biouml.plugins.simulation.java.JavaSimulationEngine;
import biouml.standard.diagram.DiagramUtility;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.Property;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import one.util.streamex.StreamEx;

public class SimulationEngineWrapper
extends Option {
    private SimulationEngine engine;
    private String engineName = "NO ENGINE SET";
    private Diagram diagram;
    private PropertyChangeListener engineListener;
    private static final String noEngine = "NO ENGINE SET";

    public SimulationEngineWrapper() {
        this.engine = new JavaSimulationEngine();
        this.engine.setParent(this);
        this.engineListener = this.initEngineListener();
        this.engine.addPropertyChangeListener(this.engineListener);
    }

    public SimulationEngineWrapper(Diagram diagram) {
        this.engineListener = this.initEngineListener();
        if (diagram != null) {
            this.setDiagram(diagram);
        }
    }

    public boolean isEngineHidden() {
        return this.engineName.equals(noEngine);
    }

    private PropertyChangeListener initEngineListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("simulator")) {
                    ComponentFactory.recreateChildProperties((Property)ComponentFactory.getModel((Object)SimulationEngineWrapper.this.getParent()).findProperty(SimulationEngineWrapper.this.getNameInParent()));
                    SimulationEngineWrapper.this.firePropertyChange("*", null, null);
                }
            }
        };
    }

    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
        if (diagram != null) {
            SimulationEngine engine = DiagramUtility.getPreferredEngine((Diagram)diagram);
            if (engine != null) {
                this.setEngine(engine);
            } else if (diagram.getRole() instanceof EModel) {
                Object[] names = SimulationEngineRegistry.getSimulationEngineNames((EModel)diagram.getRole(EModel.class));
                if (StreamEx.of((Object[])names).has((Object)this.engineName)) {
                    this.engine.setDiagram(diagram);
                } else {
                    this.setEngineName((String)(names.length > 0 ? names[0] : noEngine));
                }
            }
        }
    }

    public void setEngine(SimulationEngine engine) {
        if (this.engine == engine) {
            return;
        }
        this.engineName = SimulationEngineRegistry.getSimulationEngineName(engine);
        if (this.engineName != null) {
            SimulationEngine oldValue = this.engine;
            if (this.engine != null) {
                this.engine.removePropertyChangeListener(this.engineListener);
            }
            this.engine = engine;
            this.engine.setParent(this);
            this.engine.addPropertyChangeListener(this.engineListener);
            if (this.diagram != null) {
                engine.setDiagram(this.diagram);
            }
            this.firePropertyChange("engine", oldValue, engine);
        }
    }

    public SimulationEngine getEngine() {
        return this.engine;
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public void setEngineName(String name) {
        if (this.engine != null) {
            this.engine.removePropertyChangeListener(this.engineListener);
        }
        SimulationEngine oldValue = this.engine;
        if (name.equals(noEngine)) {
            this.engine = null;
        } else {
            this.engine = SimulationEngineRegistry.getSimulationEngine(name);
            this.engine.addPropertyChangeListener(this.engineListener);
            this.engine.setDiagram(this.diagram);
            this.engine.setParent(this);
            this.engineName = this.engine != null ? name : noEngine;
        }
        this.firePropertyChange("engine", oldValue, this.engine);
        this.firePropertyChange("*", null, null);
    }

    @PropertyName(value="Selected engine")
    @PropertyDescription(value="Selected simulation engine.")
    public String getEngineName() {
        return this.engineName;
    }

    public String[] getAvailableEngines() {
        if (this.diagram != null && this.diagram.getRole() instanceof EModel) {
            return SimulationEngineRegistry.getSimulationEngineNames((EModel)this.diagram.getRole(EModel.class));
        }
        return new String[]{this.engineName};
    }
}

