/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Module;
import biouml.model.dynamics.EModel;
import biouml.plugins.simulation.SimulationEngine;
import biouml.standard.simulation.SimulationResult;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.util.ApplicationUtils;

public class SimulationEngineUtils {
    protected static final Logger log = Logger.getLogger(SimulationEngineUtils.class.getName());

    public static File[] generateCode(EModel executableModel, SimulationEngine simulationEngine) {
        try {
            return simulationEngine.generateModel(true);
        }
        catch (Throwable t) {
            String st = ApplicationUtils.trimStackAsString((Throwable)t, (int)10);
            simulationEngine.getLogger().error("ERROR_CODE_GENERATION", new String[]{simulationEngine.getDiagram().getName(), st});
            log.log(Level.SEVERE, "ERROR_CODE_GENERATION", t);
            t.printStackTrace();
            return null;
        }
    }

    public static DataCollection getSimulationResultDC(Module module, SimulationEngine simulationEngine) {
        DataCollection resultDC = null;
        try {
            DataCollection simulationDC;
            if (module == null) {
                simulationEngine.getLogger().error("ERROR_GET_DATABASE", new String[]{simulationEngine.getDiagram().getCompletePath().toString()});
                return null;
            }
            if (module.getType().isCategorySupported()) {
                try {
                    resultDC = module.getCategory(SimulationResult.class);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (resultDC == null && (simulationDC = (DataCollection)module.get("Simulation")) != null) {
                resultDC = (DataCollection)simulationDC.get("result");
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Can not find simulation result data collection: ", ex);
        }
        return resultDC;
    }
}

