/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Diagram;
import biouml.model.dynamics.EModel;
import biouml.plugins.simulation.SimulationEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import one.util.streamex.StreamEx;
import org.eclipse.core.runtime.IConfigurationElement;
import ru.biosoft.util.ExtensionRegistrySupport;

public class SimulationEngineRegistry
extends ExtensionRegistrySupport<EngineInfo> {
    private static final SimulationEngineRegistry instance = new SimulationEngineRegistry();
    private static Logger log = Logger.getLogger(SimulationEngineRegistry.class.getName());
    private static final String NAME = "displayName";
    private static final String CLASS = "class";
    private static final String EMODEL_TYPE = "emodelType";
    private static final String PRIORITY = "priority";

    private SimulationEngineRegistry() {
        super("biouml.plugins.simulation.engine", NAME);
    }

    protected EngineInfo loadElement(IConfigurationElement element, String name) throws Exception {
        Class engineClass = this.getClassAttribute(element, CLASS, SimulationEngine.class);
        String type = this.getStringAttribute(element, EMODEL_TYPE);
        String[] priority = this.getStringAttribute(element, PRIORITY).split(",");
        double[] prior = new double[priority.length];
        try {
            for (int j = 0; j < priority.length; ++j) {
                prior[j] = Double.parseDouble(priority[j]);
            }
        }
        catch (Exception ex) {
            throw new Exception("Priority absents or not a number");
        }
        return new EngineInfo(name, engineClass, type.split(","), prior);
    }

    public static String[] getSimulationEngineNames(EModel emodel) {
        List<EngineInfo> infos = SimulationEngineRegistry.getSimulationEngineInfos(emodel.getType());
        ArrayList<String> names = new ArrayList<String>();
        for (EngineInfo info : infos) {
            names.add(info.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public static String[] getAllSimulationEngineNames() {
        return (String[])instance.stream().map(e -> e.getName()).toArray(String[]::new);
    }

    public static String getSimulationEngineName(SimulationEngine engine) {
        Class<?> clazz = engine.getClass();
        Iterator iterator = instance.iterator();
        while (iterator.hasNext()) {
            EngineInfo info = (EngineInfo)iterator.next();
            if (!info.getEngineClass().equals(clazz)) continue;
            return info.getName();
        }
        return null;
    }

    private static List<EngineInfo> getSimulationEngineInfos(String emodelType) {
        try {
            return ((StreamEx)((StreamEx)instance.stream().filter(info -> info.accepts(emodelType))).sorted((Comparator)new EngineComparator(emodelType))).toList();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Simulation engines list can not be created. " + ex);
            return Collections.emptyList();
        }
    }

    public static SimulationEngine getSimulationEngine(String name) {
        try {
            return ((EngineInfo)instance.getExtension(name)).getEngineClass().newInstance();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Simulation engine " + name + " can not be created. " + ex);
            return null;
        }
    }

    public static SimulationEngine getSimulationEngine(Diagram diagram) {
        return SimulationEngineRegistry.getSimulationEngine(SimulationEngineRegistry.getSimulationEngineName((EModel)diagram.getRole()));
    }

    public static String getSimulationEngineName(EModel model) {
        try {
            String emodelType = model.getType();
            List<EngineInfo> engineInfos = SimulationEngineRegistry.getSimulationEngineInfos(emodelType);
            if (engineInfos.isEmpty()) {
                throw new Exception("Simulation engine compatible with model type" + model.getType() + " not found");
            }
            return engineInfos.get(0).getName();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Simulation engine can not be created. " + ex);
            return null;
        }
    }

    protected static class EngineInfo {
        protected HashMap<String, Double> modeltypeToPriority;
        protected Class<? extends SimulationEngine> engineClass;
        protected String name;

        public EngineInfo(String name, Class<? extends SimulationEngine> engineClass, String[] modelType, double[] priority) {
            this.name = name;
            this.engineClass = engineClass;
            this.modeltypeToPriority = new HashMap();
            for (int i = 0; i < modelType.length; ++i) {
                String type = modelType[i];
                Double prior = priority.length > i ? priority[i] : -1.0;
                this.modeltypeToPriority.put(type, prior);
            }
        }

        public Set<String> getEModelTypes() {
            return this.modeltypeToPriority.keySet();
        }

        public boolean accepts(String modelType) {
            return this.modeltypeToPriority.containsKey(modelType);
        }

        public double getPriority(String modelType) {
            try {
                return this.modeltypeToPriority.get(modelType);
            }
            catch (Exception ex) {
                return -1.0;
            }
        }

        public Class<? extends SimulationEngine> getEngineClass() {
            return this.engineClass;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class EngineComparator
    implements Comparator<EngineInfo> {
        private final String modelType;

        public EngineComparator(String modelType) {
            this.modelType = modelType;
        }

        @Override
        public int compare(EngineInfo o1, EngineInfo o2) {
            double p1 = o1.getPriority(this.modelType);
            double p2 = o2.getPriority(this.modelType);
            return (int)Math.signum(p2 - p1);
        }
    }
}

