/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Diagram;
import biouml.model.Module;
import biouml.model.SubDiagram;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.plot.PlotInfo;
import biouml.model.dynamics.plot.PlotsInfo;
import biouml.plugins.simulation.ResultPlotPane;
import biouml.plugins.simulation.ResultWriter;
import biouml.plugins.simulation.SimulationAnalysis;
import biouml.plugins.simulation.SimulationAnalysisParameters;
import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.SimulationEngineRegistry;
import biouml.plugins.simulation.SimulationEngineUtils;
import biouml.plugins.simulation.StochasticResultPlotPane;
import biouml.plugins.simulation.plot.PlotDialog;
import biouml.plugins.simulation.resources.MessageBundle;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.simulation.ResultListener;
import biouml.standard.simulation.SimulationResult;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.action.ActionInitializer;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySetAsMap;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.swing.PropertyInspector;
import com.developmentontheedge.beans.swing.PropertyInspectorEx;
import com.developmentontheedge.log.PatternFormatter;
import com.developmentontheedge.log.TextPaneAppender;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataCollectionEvent;
import ru.biosoft.access.core.DataCollectionListener;
import ru.biosoft.access.core.DataCollectionVetoException;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.analysiscore.AnalysisMethod;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.EditorPartSupport;
import ru.biosoft.gui.PluggedEditorsTabbedPane;
import ru.biosoft.jobcontrol.FunctionJobControl;
import ru.biosoft.jobcontrol.JobControl;
import ru.biosoft.jobcontrol.JobControlEvent;
import ru.biosoft.jobcontrol.JobControlListener;
import ru.biosoft.jobcontrol.JobControlListenerAdapter;
import ru.biosoft.tasks.TaskManager;
import ru.biosoft.util.DPSUtils;
import ru.biosoft.util.PropertiesDialog;

public class SimulationEnginePane
extends EditorPartSupport
implements ItemListener,
PropertyChangeListener {
    private JTabbedPane tabbedPane = new JTabbedPane(2);
    protected EModel emodel;
    public static final String GENERATE_CODE_ACTION = "generate";
    public static final String SIMULATE_ACTION = "simulate";
    public static final String STOP_SIMULATION_ACTION = "stop";
    public static final String SAVE_RESULT_ACTION = "save-result";
    public static final String PLOT_ACTION = "plot";
    public static final String CLEAR_LOG_ACTION = "clear log";
    protected Action[] actions;
    private EngineTab engineTab;
    private PlotTab plotTab;

    public SimulationEnginePane() {
        this.add("Center", this.tabbedPane);
    }

    private void update() {
        Container parent = this.getParent().getParent();
        if (parent instanceof PluggedEditorsTabbedPane) {
            PluggedEditorsTabbedPane pane = (PluggedEditorsTabbedPane)parent;
            pane.updateActions();
        }
    }

    public void explore(Object model, Document document) {
        this.model = model;
        this.document = document;
        this.emodel = (EModel)((Diagram)model).getRole(EModel.class);
        this.emodel.addPropertyChangeListener((PropertyChangeListener)this);
        this.engineTab = new EngineTab(model, document);
        this.plotTab = new PlotTab(model);
        this.initTabbedPane(model, document);
    }

    private void initTabbedPane(Object model, Document document) {
        this.tabbedPane.removeAll();
        this.tabbedPane.addTab("Engine", this.engineTab.getView());
        this.tabbedPane.addTab("Plots", this.plotTab.getView());
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SimulationEnginePane.this.update();
            }
        });
        this.update();
    }

    public Action[] getActions() {
        Component c;
        if (this.actions == null && (c = this.tabbedPane.getSelectedComponent()) instanceof EngineTab) {
            return ((EngineTab)((Object)c)).getActions();
        }
        return new Action[0];
    }

    public boolean canExplore(Object model) {
        return model instanceof Diagram && ((Diagram)model).getRole() instanceof EModel;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Component c = this.tabbedPane.getSelectedComponent();
        if (c instanceof ItemListener) {
            ((ItemListener)((Object)c)).itemStateChanged(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Component c = this.tabbedPane.getSelectedComponent();
        if (c instanceof PropertyChangeListener) {
            ((PropertyChangeListener)((Object)c)).propertyChange(evt);
        }
    }

    public static class EngineTab
    extends EditorPartSupport
    implements ItemListener,
    PropertyChangeListener {
        protected Action[] actions;
        protected Logger log;
        protected String[] categoryList = new String[]{"biouml.plugins.simulation"};
        protected TextPaneAppender appender;
        protected ResultWriter currentResults;
        private FunctionJobControl jobControl;
        protected JComboBox<String> engineBox = new JComboBox();
        private final JLabel engineLabel = new JLabel(MessageBundle.getMessage("SIMULATION_ENGINE"));
        private JSplitPane splitPane = new JSplitPane();
        private final SimulationStatusListener listener = new SimulationStatusListener();
        protected EModel executableModel;
        protected SimulationEngine simulationEngine;
        boolean doSimulate;
        protected PropertyInspector inspector = new PropertyInspectorEx();
        protected DiagramElementsListener diagramListener = new DiagramElementsListener();
        protected JComponent view;
        protected Action generateCodeAction = new GenerateCodeAction("generate");
        protected Action simulateAction = new SimulateAction("simulate");
        protected Action stopSimulationAction = new StopSimulationAction("stop");
        protected Action saveResultAction = new SaveResultAction("save-result");
        protected Action plotAction = new PlotAction("plot");
        protected Action clearLogAction = new ClearLogAction("clear log");
        protected SimulationResult simulationResult = null;

        public EngineTab(Object model, Document document) {
            this.explore(model, document);
            this.log = Logger.getLogger(this.getClass().getName());
            this.jobControl = new FunctionJobControl(this.log);
        }

        public SimulationEngine getSimulationEngine() {
            return this.simulationEngine;
        }

        public void setSimulationEngine(SimulationEngine simulationEngine) {
            simulationEngine.setJobControl(new FunctionJobControl(this.log));
            if (this.simulationEngine != null) {
                this.simulationEngine.releaseDiagram();
                this.simulationEngine.removePropertyChangeListener(this);
            }
            this.simulationEngine = simulationEngine;
            if (this.model instanceof Diagram) {
                this.simulationEngine.setDiagram((Diagram)this.model);
                ((Diagram)this.model).getAttributes().add(DPSUtils.createHiddenReadOnlyTransient((String)"simulationOptions", SimulationEngine.class, (Object)simulationEngine));
            }
            simulationEngine.addPropertyChangeListener(this);
            this.exploreSimulationEngine();
        }

        public void exploreSimulationEngine() {
            this.inspector.explore((Object)this.simulationEngine);
            this.inspector.setComponentModel(ComponentFactory.getModel((Object)this.simulationEngine, (ComponentFactory.Policy)ComponentFactory.Policy.UI, (boolean)true));
        }

        public EModel getExecutableModel() {
            return this.executableModel;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                this.setSimulationEngine(SimulationEngineRegistry.getSimulationEngine(e.getItem().toString()));
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("solver")) {
                this.inspector.setComponentModel(ComponentFactory.getModel((Object)this.simulationEngine, (ComponentFactory.Policy)ComponentFactory.Policy.UI, (boolean)true));
            }
        }

        private void initEngineBox(String[] simulationEngineNames, String selected) {
            this.engineBox.removeItemListener(this);
            this.engineBox.removeAllItems();
            for (String engineName : simulationEngineNames) {
                this.engineBox.addItem(engineName);
            }
            this.engineBox.setVisible(simulationEngineNames.length > 1);
            this.engineLabel.setVisible(simulationEngineNames.length > 1);
            this.engineBox.setSelectedItem(selected);
            this.engineBox.addItemListener(this);
        }

        private JSplitPane initSplitPane() {
            this.appender = new TextPaneAppender((Formatter)new PatternFormatter("%4$s :  %5$s%n"), "Application Log");
            this.appender.setLevel(Level.INFO);
            this.appender.addToCategories(this.categoryList);
            this.splitPane = new JSplitPane(1, false, (Component)this.inspector, (Component)this.appender.getLogTextPanel());
            this.splitPane.setDividerLocation(0.5);
            return this.splitPane;
        }

        public void generateView() {
            GridBagLayout gbag = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.insets = new Insets(5, 5, 5, 5);
            gbag.setConstraints(this.engineLabel, gbc);
            gbc.gridx = 1;
            gbag.setConstraints(this.engineBox, gbc);
            gbc.weightx = 1.0;
            gbc.weighty = 2.0;
            gbc.gridwidth = 4;
            gbc.gridy = 1;
            gbc.gridx = 0;
            this.initSplitPane();
            gbag.setConstraints(this.splitPane, gbc);
            this.setLayout(gbag);
            this.add(this.engineLabel);
            this.add(this.engineBox);
            this.add(this.splitPane);
        }

        public JComponent getView() {
            return this;
        }

        public Object getModel() {
            return this.model;
        }

        public boolean canExplore(Object model) {
            return model instanceof Diagram && ((Diagram)model).getRole() instanceof EModel;
        }

        public void explore(Object model, Document document) {
            if (this.model != null) {
                ((Diagram)this.model).removeDataCollectionListener((DataCollectionListener)this.diagramListener);
            }
            this.model = model;
            this.document = document;
            ((Diagram)model).addDataCollectionListener((DataCollectionListener)this.diagramListener);
            try {
                String selected;
                if (this.executableModel != null) {
                    this.executableModel.removePropertyChangeListener((PropertyChangeListener)this.inspector);
                }
                this.executableModel = (EModel)((Diagram)model).getRole(EModel.class);
                this.executableModel.addPropertyChangeListener((PropertyChangeListener)this.inspector);
                this.inspector.setDefaultNumberFormat(null);
                String[] simulationEngineNames = SimulationEngineRegistry.getSimulationEngineNames(this.executableModel);
                if (simulationEngineNames.length == 0) {
                    this.log.log(Level.SEVERE, "No simulation engines found for current diagram");
                    return;
                }
                SimulationEngine engine = DiagramUtility.getPreferredEngine((Diagram)((Diagram)model));
                if (engine != null) {
                    this.setSimulationEngine(engine);
                    selected = SimulationEngineRegistry.getSimulationEngineName(engine);
                } else {
                    this.setSimulationEngine(SimulationEngineRegistry.getSimulationEngine(simulationEngineNames[0]));
                    selected = simulationEngineNames[0];
                }
                this.initEngineBox(simulationEngineNames, selected);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Can not explore model for simulation.", e);
                this.inspector.explore(null);
            }
            this.resetActions();
            this.generateView();
        }

        private void resetActions() {
            this.simulateAction.setEnabled(true);
            this.generateCodeAction.setEnabled(true);
            this.stopSimulationAction.setEnabled(false);
            this.saveResultAction.setEnabled(false);
            this.plotAction.setEnabled(false);
        }

        public Action[] getActions() {
            if (this.actions == null) {
                ActionInitializer initializer = new ActionInitializer(new Class[]{MessageBundle.class});
                initializer.initAction(this.generateCodeAction, SimulationEnginePane.GENERATE_CODE_ACTION);
                initializer.initAction(this.simulateAction, SimulationEnginePane.SIMULATE_ACTION);
                initializer.initAction(this.stopSimulationAction, SimulationEnginePane.STOP_SIMULATION_ACTION);
                initializer.initAction(this.saveResultAction, SimulationEnginePane.SAVE_RESULT_ACTION);
                initializer.initAction(this.plotAction, SimulationEnginePane.PLOT_ACTION);
                initializer.initAction(this.clearLogAction, SimulationEnginePane.CLEAR_LOG_ACTION);
                this.saveResultAction.setEnabled(false);
                this.plotAction.setEnabled(false);
                this.actions = new Action[]{this.generateCodeAction, this.simulateAction, this.stopSimulationAction, this.saveResultAction, this.plotAction, this.clearLogAction};
            }
            return this.actions;
        }

        protected ResultListener[] getResultListeners(SimulationEngine simulationEngine) throws Exception {
            SimulationResult res = simulationEngine.generateSimulationResult();
            this.currentResults = new ResultWriter(res);
            res.setDiagramPath(this.executableModel.getParent().getCompletePath());
            if (!simulationEngine.needToShowPlot) {
                return new ResultListener[]{this.currentResults};
            }
            PlotInfo[] plotInfos = simulationEngine.getPlots();
            ResultListener[] result = new ResultListener[plotInfos.length + 1];
            for (int i = 0; i < plotInfos.length; ++i) {
                int simulationType = simulationEngine.getSimulationType();
                result[i] = simulationType == SimulationEngine.STOCHASTIC_TYPE ? new StochasticResultPlotPane(simulationEngine, this.jobControl, plotInfos[i]) : new ResultPlotPane(simulationEngine, this.jobControl, plotInfos[i]);
            }
            result[plotInfos.length] = this.currentResults;
            return result;
        }

        protected void doSaveSimulationResult(SimulationResult simulationResult) throws Exception {
            if (simulationResult != null) {
                SimulationResult tmpResult = this.currentResults.getResults().clone(simulationResult.getOrigin(), simulationResult.getName());
                simulationResult.getOrigin().put((DataElement)tmpResult);
            }
        }

        protected void stopSimulation() {
            this.simulationEngine.stopSimulation();
            this.simulateAction.setEnabled(true);
            this.generateCodeAction.setEnabled(true);
        }

        protected void simulate() {
            this.doSimulate = true;
            if (this.simulationEngine.getNeedToShowPlot() && !this.simulationEngine.hasVariablesToPlot()) {
                this.showNoVariablesDialog();
            } else {
                List<Object> incorrect = new ArrayList();
                try {
                    incorrect = this.simulationEngine.getIncorrectPlotVariables();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, ex.getMessage(), MessageBundle.getMessage("WARN_WRONG_VARIABLES_TO_PLOT_TITLE"), 0);
                    return;
                }
                if (incorrect.size() > 0) {
                    String errorMsg = MessageFormat.format(MessageBundle.getMessage("WARN_WRONG_VARIABLES_TO_PLOT"), String.join((CharSequence)", ", incorrect));
                    JOptionPane.showMessageDialog(null, errorMsg, MessageBundle.getMessage("WARN_WRONG_VARIABLES_TO_PLOT_TITLE"), 0);
                    return;
                }
            }
            if (this.doSimulate) {
                SimulationAnalysis method = new SimulationAnalysis((DataCollection<?>)this.simulationEngine.getDiagram(), "Simulation analysis");
                SimulationAnalysisParameters simulationParameters = (SimulationAnalysisParameters)method.getParameters();
                try {
                    for (ResultListener listener : this.getResultListeners(this.simulationEngine)) {
                        method.addResultListenerList(listener);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                simulationParameters.setSimulationEngine(this.simulationEngine);
                SimulationAnalysis.SimulationAnalysisJobControl jobControl = method.getJobControl();
                jobControl.addListener((JobControlListener)this.listener);
                TaskManager.getInstance().addAnalysisTask((AnalysisMethod)method, (JobControl)jobControl, true, "simulate \"" + this.simulationEngine.getDiagram().getName() + "\"");
            }
        }

        private void showNoVariablesDialog() {
            JFrame frame = new JFrame("");
            this.doSimulate = false;
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JLabel(MessageBundle.getMessage("WARN_NO_VARIABLES_TO_PLOT")), "Center");
            panel.setBorder(new EmptyBorder(10, 10, 10, 10));
            OkCancelDialog dialog = new OkCancelDialog(frame, "Warning", panel){

                public void okPressed() {
                    doSimulate = true;
                    super.okPressed();
                }

                public void cancelPressed() {
                    doSimulate = false;
                    super.cancelPressed();
                }
            };
            dialog.doModal();
        }

        protected DataCollection<?> getSimulationResultDC() {
            Module module = Module.getModule((DataElement)this.executableModel.getDiagramElement());
            return SimulationEngineUtils.getSimulationResultDC(module, this.simulationEngine);
        }

        protected void saveSimulationResult() {
            try {
                DynamicPropertySetAsMap dps = new DynamicPropertySetAsMap();
                dps.add(new DynamicProperty("path", DataElementPath.class, (Object)""));
                PropertiesDialog dialog = new PropertiesDialog((JFrame)Application.getApplicationFrame(), "New element", (Object)dps);
                if (dialog.doModal()) {
                    DataElementPath dep = (DataElementPath)dps.getProperty("path").getValue();
                    this.simulationResult = new SimulationResult(dep.getParentCollection(), dep.getName());
                    this.doSaveSimulationResult(this.simulationResult);
                    this.plotAction.setEnabled(true);
                }
            }
            catch (Throwable t) {
                this.simulationEngine.getLogger().error("ERROR_SAVE_RESULT", new String[]{this.simulationEngine.getDiagram().getName(), t.toString()}, t);
            }
        }

        protected void plot() {
            if (this.simulationResult == null) {
                int type = JOptionPane.showConfirmDialog((Component)((Object)this), this.simulationEngine.getLogger().getResourceString("SAVE_RESULT_CONFIRM_MESSAGE"), this.simulationEngine.getLogger().getResourceString("SAVE_RESULT_DIALOG_TITLE"), 2);
                if (type == 0) {
                    this.saveSimulationResult();
                } else {
                    return;
                }
            }
            try {
                new PlotDialog(this.simulationResult).doModal();
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, "Error occured when creating plot for simulation result " + (this.simulationResult != null ? this.simulationResult.getName() + "." : ".") + " : " + ex);
            }
        }

        class SimulationStatusListener
        extends JobControlListenerAdapter {
            SimulationStatusListener() {
            }

            public void jobStarted(JobControlEvent event) {
                EngineTab.this.generateCodeAction.setEnabled(false);
                EngineTab.this.simulateAction.setEnabled(false);
                EngineTab.this.saveResultAction.setEnabled(false);
                EngineTab.this.plotAction.setEnabled(false);
                EngineTab.this.stopSimulationAction.setEnabled(true);
            }

            public void resultsReady(JobControlEvent event) {
                EngineTab.this.generateCodeAction.setEnabled(true);
                EngineTab.this.simulateAction.setEnabled(true);
                EngineTab.this.saveResultAction.setEnabled(true);
                EngineTab.this.plotAction.setEnabled(true);
                EngineTab.this.stopSimulationAction.setEnabled(false);
            }

            public void jobTerminated(JobControlEvent event) {
                EngineTab.this.generateCodeAction.setEnabled(true);
                EngineTab.this.simulateAction.setEnabled(true);
                EngineTab.this.saveResultAction.setEnabled(false);
                EngineTab.this.plotAction.setEnabled(false);
                EngineTab.this.stopSimulationAction.setEnabled(false);
            }
        }

        public class DiagramElementsListener
        implements DataCollectionListener {
            protected boolean refresh = false;

            public void elementAdded(DataCollectionEvent e) throws Exception {
                DataElement de = e.getDataElement();
                if (de instanceof SubDiagram) {
                    EngineTab.this.simulationEngine.propertyChange(null);
                    EngineTab.this.exploreSimulationEngine();
                }
            }

            public void elementChanged(DataCollectionEvent e) throws Exception {
            }

            public void elementRemoved(DataCollectionEvent e) throws Exception {
                if (this.refresh) {
                    EngineTab.this.simulationEngine.propertyChange(null);
                    EngineTab.this.exploreSimulationEngine();
                    this.refresh = false;
                }
            }

            public void elementWillAdd(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
            }

            public void elementWillChange(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
            }

            public void elementWillRemove(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
                this.refresh = e.getDataElement() instanceof SubDiagram;
            }
        }

        class PlotAction
        extends AbstractAction {
            public PlotAction(String name) {
                super(name);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineTab.this.plot();
            }
        }

        class SaveResultAction
        extends AbstractAction {
            public SaveResultAction(String name) {
                super(name);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineTab.this.saveSimulationResult();
            }
        }

        class StopSimulationAction
        extends AbstractAction {
            public StopSimulationAction(String name) {
                super(name);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineTab.this.stopSimulation();
            }
        }

        class ClearLogAction
        extends AbstractAction {
            public ClearLogAction(String name) {
                super(name);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineTab.this.appender.getLogTextPanel().setText("");
            }
        }

        class SimulateAction
        extends AbstractAction {
            public SimulateAction(String name) {
                super(name);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineTab.this.simulate();
            }
        }

        class GenerateCodeAction
        extends AbstractAction {
            public GenerateCodeAction(String name) {
                super(name);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulationEngineUtils.generateCode(EngineTab.this.executableModel, EngineTab.this.simulationEngine);
            }
        }
    }

    public static class PlotTab
    extends EditorPartSupport {
        private final PropertyInspectorEx inspector = new PropertyInspectorEx();
        protected EModel emodel;
        public static final String PLOTS = "Plots";
        PlotsInfo plot;

        public JComponent getView() {
            return this.inspector;
        }

        public PlotTab(Object model) {
            if (model instanceof Diagram) {
                this.emodel = (EModel)((Diagram)model).getRole(EModel.class);
            }
            try {
                Object plotsObj = this.emodel.getParent().getAttributes().getValue(PLOTS);
                if (!(plotsObj instanceof PlotsInfo)) {
                    this.plot = new PlotsInfo(this.emodel);
                    this.emodel.getParent().getAttributes().add(DPSUtils.createHiddenReadOnlyTransient((String)PLOTS, PlotsInfo.class, (Object)this.plot));
                } else {
                    this.plot = (PlotsInfo)plotsObj;
                }
                this.inspector.explore((Object)this.plot);
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, "Can not explore plots for diagram " + model, e);
            }
        }

        public void onClose() {
            try {
                if (this.emodel != null) {
                    this.emodel.getParent().getAttributes().add(DPSUtils.createHiddenReadOnlyTransient((String)PLOTS, PlotsInfo.class, (Object)this.plot));
                }
            }
            catch (Exception ex) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, "Error with plot pane.", ex);
            }
        }
    }
}

