/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.resources.MessageBundle;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimulationEngineLogger {
    private Logger log;
    protected ResourceBundle resources = null;
    protected ResourceBundle childResources = null;
    protected static final ResourceBundle parentResources = ResourceBundle.getBundle(MessageBundle.class.getName());

    public SimulationEngineLogger() {
        this(SimulationEngine.class);
    }

    public SimulationEngineLogger(Class clazz) {
        this.log = Logger.getLogger(clazz.getName());
    }

    public SimulationEngineLogger(String messageBundle, Class clazz) {
        this(clazz);
        this.initResources(messageBundle, clazz);
    }

    public ResourceBundle getResourceBundle() {
        return this.resources;
    }

    public Logger getLogger() {
        return this.log;
    }

    public String getResourceString(String key) {
        try {
            return this.resources.getString(key);
        }
        catch (Throwable t) {
            this.log.log(Level.SEVERE, "Missing resource <" + key + ">.");
            return key;
        }
    }

    protected void initResources(String resourceBundleName, Class<?> c) {
        try {
            if (resourceBundleName == null) {
                this.childResources = this.resources = parentResources;
                return;
            }
            ClassLoader cl = c.getClassLoader();
            ResourceBundle resourceBundle = this.childResources = cl != null ? ResourceBundle.getBundle(resourceBundleName, Locale.getDefault(), cl) : ResourceBundle.getBundle(resourceBundleName, Locale.getDefault());
            if (parentResources == null) {
                this.resources = this.childResources;
                return;
            }
            this.resources = new ResourceBundle(){

                @Override
                protected Object handleGetObject(String key) throws MissingResourceException {
                    try {
                        return SimulationEngineLogger.this.childResources.getObject(key);
                    }
                    catch (MissingResourceException e) {
                        MissingResourceException mre = e;
                        try {
                            return parentResources.getObject(key);
                        }
                        catch (MissingResourceException missingResourceException) {
                            throw mre;
                        }
                    }
                }

                @Override
                public Enumeration<String> getKeys() {
                    Enumeration<String> result = new Enumeration<String>(){
                        final Enumeration<String> childKeys;
                        final Enumeration<String> parentKeys;
                        String temp;
                        {
                            this.childKeys = SimulationEngineLogger.this.childResources.getKeys();
                            this.parentKeys = parentResources.getKeys();
                            this.temp = null;
                        }

                        @Override
                        public boolean hasMoreElements() {
                            if (this.temp == null) {
                                this.nextElement();
                            }
                            return this.temp != null;
                        }

                        @Override
                        public String nextElement() {
                            String returnVal = this.temp;
                            if (this.childKeys.hasMoreElements()) {
                                this.temp = this.childKeys.nextElement();
                                return returnVal;
                            }
                            this.temp = null;
                            while (this.temp == null && this.parentKeys.hasMoreElements()) {
                                this.temp = this.parentKeys.nextElement();
                                try {
                                    SimulationEngineLogger.this.childResources.getObject(this.temp);
                                    this.temp = null;
                                }
                                catch (MissingResourceException missingResourceException) {}
                            }
                            return returnVal;
                        }
                    };
                    return result;
                }
            };
        }
        catch (MissingResourceException mre) {
            this.log.log(Level.SEVERE, "Resource '" + resourceBundleName + "' can not be initilized", mre);
        }
    }

    public static String getCurrentTime() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("[ HH:mm:ss ] ");
        return sdf.format(cal.getTime());
    }

    public void info(String message) {
        this.log.info(SimulationEngineLogger.getCurrentTime() + message);
    }

    public void warn(String message) {
        this.log.warning(SimulationEngineLogger.getCurrentTime() + message);
    }

    public void error(String message, Exception ex) {
        this.log.log(Level.SEVERE, SimulationEngineLogger.getCurrentTime() + message, ex);
    }

    public void error(String message) {
        this.log.log(Level.SEVERE, SimulationEngineLogger.getCurrentTime() + message);
    }

    public void error(String messageBundleKey, String[] params) {
        String message = this.getResourceString(messageBundleKey);
        message = MessageFormat.format(message, params);
        this.log.log(Level.SEVERE, message);
    }

    public void error(String messageBundleKey, String[] params, Throwable t) {
        String message = this.getResourceString(messageBundleKey);
        message = MessageFormat.format(message, params);
        this.log.log(Level.SEVERE, message, t);
    }

    public void warn(String messageBundleKey, String[] params) {
        String message = this.getResourceString(messageBundleKey);
        message = MessageFormat.format(message, params);
        this.log.warning(message);
    }
}

