/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Diagram;
import biouml.model.SubDiagram;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.plot.Curve;
import biouml.model.dynamics.plot.PlotInfo;
import biouml.model.dynamics.plot.PlotVariable;
import biouml.model.dynamics.plot.PlotsInfo;
import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.Options;
import biouml.plugins.simulation.Preprocessor;
import biouml.plugins.simulation.ResultWriter;
import biouml.plugins.simulation.SimulationEngineLogger;
import biouml.plugins.simulation.Simulator;
import biouml.plugins.simulation.SimulatorRegistry;
import biouml.plugins.simulation.Span;
import biouml.plugins.simulation.UniformSpan;
import biouml.plugins.simulation.java.RunTimeCompiler;
import biouml.standard.diagram.Util;
import biouml.standard.simulation.ResultListener;
import biouml.standard.simulation.SimulationResult;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.PropertyChangeObservable;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import one.util.streamex.StreamEx;
import org.jfree.data.general.Series;
import org.jfree.data.xy.XYSeries;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.PluginEntry;
import ru.biosoft.access.exception.BiosoftParseException;
import ru.biosoft.graphics.Pen;
import ru.biosoft.jobcontrol.FunctionJobControl;
import ru.biosoft.util.WeakPropertyChangeForwarder;
import ru.biosoft.util.bean.JSONBean;

public abstract class SimulationEngine
extends Option
implements PropertyChangeListener,
JSONBean {
    public static int DETERMINISTIC_TYPE = 0;
    public static int STOCHASTIC_TYPE = 1;
    public static String VAR_PATH_DELIMITER = "/";
    protected SimulationEngineLogger log = new SimulationEngineLogger();
    private String srcDir = ".";
    protected boolean diagramModified = false;
    protected WeakPropertyChangeForwarder diagramListener;
    private final List<Preprocessor> additionalPreprocessors = new ArrayList<Preprocessor>();
    private final List<Preprocessor> additionalPreprocessors2 = new ArrayList<Preprocessor>();
    private double initialTime = 0.0;
    private double timeIncrement = 1.0;
    private double completionTime = 100.0;
    protected FunctionJobControl jobControl;
    protected String simulatorType = "NONE";
    protected String solverName;
    protected Simulator simulator;
    protected Diagram diagram;
    protected Model model;
    protected Diagram originalDiagram;
    protected EModel executableModel;
    protected boolean terminated = false;
    public boolean needToShowPlot = true;
    protected int modelType;
    protected SimulationResult result;
    protected List<ResultListener> listeners = new ArrayList<ResultListener>();

    public String getSimulatorType() {
        return this.simulatorType;
    }

    public FunctionJobControl getJobControl() {
        return this.jobControl;
    }

    public void setJobControl(FunctionJobControl jobControl) {
        this.jobControl = jobControl;
    }

    public int getModelType() {
        return this.modelType;
    }

    public void setNeedToShowPlot(boolean value) {
        this.needToShowPlot = value;
    }

    @PropertyName(value="Show plot")
    public boolean getNeedToShowPlot() {
        return this.needToShowPlot;
    }

    public boolean hasVariablesToPlot() {
        Object plotObj = this.executableModel.getParent().getAttributes().getValue("Plots");
        if (!(plotObj instanceof PlotsInfo)) {
            return false;
        }
        PlotsInfo plots = (PlotsInfo)plotObj;
        for (PlotInfo plot : plots.getActivePlots()) {
            if (plot.getYVariables().length <= 0) continue;
            return true;
        }
        return false;
    }

    public List<String> getIncorrectPlotVariables() throws Exception {
        ArrayList<String> incorrect = new ArrayList<String>();
        Object plotObj = this.executableModel.getParent().getAttributes().getValue("Plots");
        if (plotObj == null) {
            return incorrect;
        }
        PlotsInfo plots = (PlotsInfo)plotObj;
        for (PlotInfo plot : plots.getActivePlots()) {
            EModel emodel;
            PlotVariable xVar = plot.getXVariable();
            String path = xVar.getPath();
            EModel eModel = emodel = path.isEmpty() ? this.executableModel : (EModel)Util.getSubDiagram((Diagram)this.originalDiagram, (String)path).getDiagram().getRole(EModel.class);
            if (!emodel.containsVariable(xVar.getName())) {
                incorrect.add(xVar.getTitle());
            }
            for (Curve curve : plot.getYVariables()) {
                path = curve.getPath();
                if (path.isEmpty()) {
                    emodel = this.executableModel;
                } else {
                    SubDiagram subDiagram = Util.getSubDiagram((Diagram)this.originalDiagram, (String)path);
                    if (subDiagram == null) {
                        throw new Exception("Can not find subdiagram" + path + " in diagram " + this.originalDiagram);
                    }
                    emodel = (EModel)subDiagram.getDiagram().getRole(EModel.class);
                }
                if (emodel.containsVariable(curve.getName())) continue;
                incorrect.add(curve.getTitle());
            }
        }
        return incorrect;
    }

    public SimulationEngine clone() {
        SimulationEngine simulationEngine = null;
        try {
            simulationEngine = (SimulationEngine)this.getClass().newInstance();
            Object solver = this.getSolver().getClass().newInstance();
            if (solver instanceof Simulator) {
                ((Simulator)solver).setOptions(((Simulator)this.getSolver()).getOptions());
                simulationEngine.setSolver(solver);
            }
            simulationEngine.setCompletionTime(this.completionTime);
            simulationEngine.setTimeIncrement(this.timeIncrement);
            simulationEngine.setDiagram(this.getDiagram());
        }
        catch (Exception e) {
            this.log.error("Can not clone simulation engine.", e);
        }
        return simulationEngine;
    }

    public abstract String getEngineDescription();

    public abstract String getVariableCodeName(String var1);

    public abstract String getVariableCodeName(String var1, String var2);

    public abstract Map<String, Integer> getVarIndexMapping();

    public abstract Map<String, Integer> getVarPathIndexMapping();

    public abstract Model createModel() throws Exception;

    public void setModel(Model model) {
        this.model = model;
    }

    public void setInitialValue(String varName, double value) throws IllegalArgumentException {
        if (!this.executableModel.containsVariable(varName)) {
            throw new IllegalArgumentException("Variable " + varName + " not found");
        }
        this.executableModel.getVariable(varName).setInitialValue(value);
    }

    public String[] getVariableNames() {
        try {
            DataCollection collection = this.executableModel.getVariables();
            return (String[])collection.names().toArray(String[]::new);
        }
        catch (Exception ex) {
            return new String[0];
        }
    }

    public void setOutputDir(String outputDir) {
    }

    public String getOutputDir() {
        return null;
    }

    public abstract Object getSolver();

    public abstract void setSolver(Object var1);

    public File[] generateModel(boolean forceRewrite) throws Exception {
        throw new Exception("Current engine does not support generating model into file");
    }

    public Object[] compileModel(File[] files, boolean compile, String outputDir) throws Exception {
        this.log.info("Model " + this.diagram.getName() + ": Java code compilation...");
        Object[] result = new Object[files.length];
        for (int i = 0; i < files.length; ++i) {
            String className = files[i].getName();
            className = className.substring(0, className.length() - 5);
            if (compile) {
                files[i] = new File(outputDir, className + ".java");
                StringBuilder classPath = new StringBuilder(outputDir);
                for (PluginEntry f : this.getClassPathEntries()) {
                    classPath.append(File.pathSeparator).append(f.extract().getAbsolutePath());
                }
                RunTimeCompiler comp = new RunTimeCompiler(classPath.toString(), outputDir, new String[]{outputDir + File.separator + files[i].getName()});
                if (!comp.execute()) {
                    throw new BiosoftParseException((Throwable)new Exception(comp.getMessages()), files[i].getName());
                }
            }
            File outDir = new File(outputDir);
            URL[] url = new URL[]{outDir.toURI().toURL()};
            try (URLClassLoader cl = new URLClassLoader(url, this.getClass().getClassLoader());){
                result[i] = cl.loadClass(className).newInstance();
                continue;
            }
            catch (Throwable t) {
                throw new Exception("Can not load model, name=" + className + ", error=" + t);
            }
        }
        return result;
    }

    public Object[] compileModel(File[] files, String classPath) throws Exception {
        this.log.info("Model " + this.diagram.getName() + ": Java code compilation...");
        Object[] result = new Object[files.length];
        String outDirName = files[0].getParentFile().getAbsolutePath();
        String[] fileNames = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            fileNames[i] = files[i].getAbsolutePath();
        }
        RunTimeCompiler comp = new RunTimeCompiler(classPath, outDirName, fileNames);
        if (!comp.execute()) {
            throw new BiosoftParseException((Throwable)new Exception(comp.getMessages()), files[0].getName());
        }
        URL[] url = new URL[]{new File(outDirName).toURI().toURL()};
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i].getName();
            String className = fileName.substring(0, fileName.lastIndexOf("."));
            try (URLClassLoader cl = new URLClassLoader(url, this.getClass().getClassLoader());){
                result[i] = cl.loadClass(className).newInstance();
                continue;
            }
            catch (Throwable t) {
                throw new Exception("Can not load model, name=" + className + ", error=" + t);
            }
        }
        return result;
    }

    protected List<PluginEntry> getClassPathEntries() {
        try {
            return Arrays.asList(ru.biosoft.util.ApplicationUtils.resolvePluginPath((String)"biouml.plugins.simulation:src.jar"));
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public String getSrcDir() {
        return this.srcDir;
    }

    public void setSrcDir(String dir) {
        this.srcDir = dir;
    }

    protected void writeFile(String source, boolean rewrite) throws Exception {
        InputStream is;
        File out = new File(this.getOutputDir(), source);
        if (out.exists() && !rewrite) {
            return;
        }
        out.getParentFile().mkdirs();
        File file = new File(source);
        if (!file.exists()) {
            file = new File(this.getSrcDir(), source);
        }
        if (file.exists()) {
            is = new FileInputStream(file);
        } else {
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource(source);
            if (url == null) {
                throw new FileNotFoundException("Can not find file: " + source);
            }
            is = url.openStream();
        }
        ApplicationUtils.copyStream((OutputStream)new FileOutputStream(out, false), (InputStream)is);
    }

    public String[] getAvailableSolvers() {
        return (String[])SimulatorRegistry.registry(this.getSimulatorType()).keys().toArray(String[]::new);
    }

    public abstract String simulate(Model var1, ResultListener[] var2) throws Exception;

    public String simulate(ResultListener[] resultListeners) throws Exception {
        return this.simulate(this.createModel(), resultListeners);
    }

    public String simulate(Model model) throws Exception {
        return this.simulate(model, this.getListeners());
    }

    public String simulate() throws Exception {
        return this.simulate(this.createModel());
    }

    public void addListeners(ResultListener ... resultListeners) {
        this.listeners.addAll(Arrays.asList(resultListeners));
    }

    public ResultListener[] getListeners() {
        return this.listeners.toArray(new ResultListener[this.listeners.size()]);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public String simulate(Model model, SimulationResult result) throws Exception {
        this.initSimulationResult(result);
        return this.simulate(model, new ResultListener[]{new ResultWriter(result)});
    }

    public String simulate(SimulationResult result) throws Exception {
        return this.simulate(this.createModel(), result);
    }

    public void stopSimulation() {
        this.setTerminated(true);
        if (this.simulator != null) {
            this.simulator.stop();
        }
    }

    @PropertyName(value="Simulator options")
    @PropertyDescription(value="Simulator options.")
    public Options getSimulatorOptions() {
        return this.simulator.getOptions();
    }

    public void setSimulatorOptions(Options options) {
        Options oldValue = this.simulator.getOptions();
        options.setParent(this);
        this.simulator.setOptions(options);
        this.firePropertyChange("simulatorOptions", (Object)oldValue, (Object)options);
        this.firePropertyChange("*", null, null);
    }

    public Simulator getSimulator() {
        return this.simulator;
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public Diagram getOriginalDiagram() {
        return this.originalDiagram;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.doNotAffectSimulation(evt)) {
            return;
        }
        this.diagramModified = true;
        this.restoreOriginalDiagram();
    }

    protected boolean doNotAffectSimulation(PropertyChangeEvent evt) {
        String propertyName;
        return evt != null && ("path".equals(propertyName = evt.getPropertyName()) || "location".equals(propertyName));
    }

    public void releaseDiagram() {
        if (this.diagram != null) {
            this.diagram.removePropertyChangeListener((PropertyChangeListener)this.diagramListener);
        }
    }

    public void setDiagram(Diagram diagram) {
        Diagram oldValue = this.diagram;
        this.originalDiagram = diagram;
        this.diagram = diagram;
        if (diagram != null && diagram.getRole() != null && diagram.getRole() instanceof EModel) {
            this.executableModel = (EModel)diagram.getRole(EModel.class);
        }
        this.firePropertyChange("diagram", oldValue, diagram);
        this.diagramModified = true;
        if (oldValue != null) {
            oldValue.removePropertyChangeListener((PropertyChangeListener)this.diagramListener);
        }
        this.diagramListener = diagram != null ? new WeakPropertyChangeForwarder((PropertyChangeListener)this, (PropertyChangeObservable)diagram) : null;
    }

    public EModel getExecutableModel() {
        return this.executableModel;
    }

    @PropertyName(value="Simulator name")
    @PropertyDescription(value="Simulator name.")
    public String getSolverName() {
        Object solver = this.getSolver();
        if (this.solverName == null && solver != null) {
            try {
                this.solverName = solver.getClass().getName();
                this.solverName = SimulatorRegistry.registry(this.getSimulatorType()).filterValues(this.solverName::equals).keys().findAny().orElse(this.solverName);
            }
            catch (Exception e) {
                this.log.error("Can not redefine solver name using SimualtorRegistry information.\r\n  Error: " + e, e);
            }
        }
        return this.solverName;
    }

    public void setSolverName(String solverName) {
        if (Objects.equals(this.solverName, solverName)) {
            return;
        }
        try {
            Simulator simulator = SimulatorRegistry.getSimulator(solverName);
            simulator.getOptions().setParent(this);
            this.setSolver(simulator);
            this.solverName = solverName;
        }
        catch (Exception e) {
            this.log.error("Can set solver name by name, error: " + e, e);
            return;
        }
    }

    public void setSpan(Span span) {
        this.setInitialTime(span.getTimeStart());
        this.setCompletionTime(span.getTimeFinal());
        if (span instanceof UniformSpan) {
            this.setTimeIncrement(((UniformSpan)span).getTimeIncrement());
        } else {
            this.setTimeIncrement(span.getTime(1) - span.getTimeStart());
        }
    }

    @PropertyName(value="Initial time")
    @PropertyDescription(value="Initial time.")
    public double getInitialTime() {
        return this.initialTime;
    }

    public void setInitialTime(double initialTime) {
        double oldValue = this.getInitialTime();
        this.initialTime = initialTime;
        this.firePropertyChange("initialTime", oldValue, initialTime);
    }

    @PropertyName(value="Completion time")
    @PropertyDescription(value="Completion time.")
    public double getCompletionTime() {
        return this.completionTime;
    }

    public void setCompletionTime(double completionTime) {
        double oldValue = this.getCompletionTime();
        this.completionTime = completionTime;
        this.firePropertyChange("completionTime", oldValue, completionTime);
    }

    @PropertyName(value="Time increment")
    @PropertyDescription(value="Time increment.")
    public double getTimeIncrement() {
        return this.timeIncrement;
    }

    public void setTimeIncrement(double timeIncrement) {
        double oldValue = this.getTimeIncrement();
        this.timeIncrement = timeIncrement;
        this.firePropertyChange("timeIncrement", oldValue, timeIncrement);
    }

    public void initSimulationResult(SimulationResult simuationResult) {
        simuationResult.setInitialTime(this.getInitialTime());
        simuationResult.setCompletionTime(this.getCompletionTime());
        if (this.diagram != null) {
            simuationResult.setDiagramPath(this.diagram.getCompletePath());
        }
        for (Variable var : this.executableModel.getVariables()) {
            if (Boolean.TRUE.equals(var.getAttributes().getValue("autogenerated"))) continue;
            simuationResult.addInitialValue(var);
        }
        simuationResult.setVariableMap(this.getVarPathIndexMapping());
        simuationResult.setVariablePathMap(this.getVarPathIndexMapping());
        this.result = simuationResult;
    }

    public Var getXVariable(PlotInfo plot) {
        PlotVariable xVariable = plot.getXVariable();
        String name = xVariable.getName();
        String title = xVariable.getTitle();
        String path = xVariable.getPath();
        SubDiagram subDiagram = Util.getSubDiagram((Diagram)this.originalDiagram, (String)path);
        EModel emodel = subDiagram != null ? (EModel)subDiagram.getDiagram().getRole(EModel.class) : (EModel)this.originalDiagram.getRole(EModel.class);
        Variable var = emodel.getVariable(name);
        double initialValue = var.getInitialValue();
        Integer index = this.getVarPathIndexMapping().get(path.isEmpty() ? name : path + VAR_PATH_DELIMITER + name);
        return new Var(name, title, initialValue, index, null);
    }

    public PlotInfo[] getPlots() {
        Object plotObj = this.executableModel.getParent().getAttributes().getValue("Plots");
        if (plotObj instanceof PlotsInfo) {
            return ((PlotsInfo)plotObj).getActivePlots();
        }
        return new PlotInfo[0];
    }

    public Map<Var, List<Series>> getVariablesToPlot(PlotInfo plot) {
        TreeMap<Var, List<Series>> variablesToPlot = new TreeMap<Var, List<Series>>();
        for (Curve curve : plot.getYVariables()) {
            String name = curve.getName();
            String title = curve.getTitle();
            String path = curve.getPath();
            SubDiagram subDiagram = Util.getSubDiagram((Diagram)this.originalDiagram, (String)path);
            EModel emodel = subDiagram != null ? (EModel)subDiagram.getDiagram().getRole(EModel.class) : (EModel)this.originalDiagram.getRole(EModel.class);
            double initialValue = emodel.getVariable(name).getInitialValue();
            Integer index = this.getVarPathIndexMapping().get(path.isEmpty() ? name : path + VAR_PATH_DELIMITER + name);
            ArrayList<XYSeries> list = new ArrayList<XYSeries>();
            list.add(new XYSeries((Comparable)((Object)title), false, true));
            if (variablesToPlot.keySet().stream().anyMatch(k -> k.title.equals(title))) continue;
            variablesToPlot.put(new Var(name, title, initialValue, index, curve.getPen()), list);
        }
        return variablesToPlot;
    }

    public void setStandalone(boolean standalone) {
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void setTerminated(boolean terminated) {
        this.terminated = terminated;
    }

    public void restoreOriginalDiagram() {
        this.diagram = this.originalDiagram;
        this.executableModel = (EModel)this.originalDiagram.getRole();
    }

    protected List<Preprocessor> getDiagramPreprocessors() {
        return new ArrayList<Preprocessor>();
    }

    public void preprocess(Diagram originalDiagram) throws Exception {
        this.executableModel = (EModel)this.diagram.getRole(EModel.class);
        boolean notify = this.executableModel.isNotificationEnabled();
        boolean notifyDiagram = this.diagram.isNotificationEnabled();
        this.executableModel.setNotificationEnabled(false);
        this.diagram.setNotificationEnabled(false);
        for (Preprocessor p2 : (StreamEx)StreamEx.of(this.additionalPreprocessors).append(this.getDiagramPreprocessors()).append(this.additionalPreprocessors2).filter(p -> p.accept(this.diagram))) {
            this.diagram = p2.preprocess(this.diagram);
        }
        this.executableModel.setNotificationEnabled(notify);
        this.diagram.setNotificationEnabled(notifyDiagram);
        this.executableModel = (EModel)this.diagram.getRole(EModel.class);
    }

    public void addPreprocessor(Preprocessor preprocessor) {
        this.additionalPreprocessors.add(preprocessor);
    }

    public void addPreprocessor2(Preprocessor preprocessor) {
        this.additionalPreprocessors2.add(preprocessor);
    }

    public void resetPreprocessors() {
        this.additionalPreprocessors.clear();
        this.additionalPreprocessors2.clear();
    }

    public static String escapeWrongSymbols(String str) {
        String wrongLetters = ": .,;|()[]{}+-*/%^!~&|$'\"";
        char[] data = str.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            if (wrongLetters.indexOf(data[i]) < 0) continue;
            data[i] = 95;
        }
        str = new String(data);
        if (Character.isDigit(str.charAt(0))) {
            str = "_" + str;
        }
        return str;
    }

    public String normalize(String name) {
        while (name.charAt(0) == '$') {
            name = name.substring(1);
        }
        int offset = name.lastIndexOf(".");
        if (offset > 0 && name.length() > offset + 3 && name.charAt(offset + 1) == 'x' && name.charAt(offset + 2) == 'm' && name.charAt(offset + 3) == 'l') {
            name = name.substring(0, offset);
        }
        name = SimulationEngine.escapeWrongSymbols(name);
        return name;
    }

    public void clearContext() {
    }

    public SimulationEngineLogger getLogger() {
        return this.log;
    }

    public void setLogLevel(Level level) {
        this.log.getLogger().setLevel(level);
    }

    public void checkVariables(double[] values, Map<Integer, String> names) {
        ArrayList<String> nan = new ArrayList<String>();
        ArrayList<String> inf = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            double val = values[i];
            if (Double.isNaN(val)) {
                nan.add(names.get(i));
                continue;
            }
            if (!Double.isInfinite(val)) continue;
            inf.add(names.get(i));
        }
        if (nan.isEmpty() && inf.isEmpty()) {
            return;
        }
        this.log.info("At time = " + this.getSimulator().getProfile().getTime() + ":");
        if (!nan.isEmpty()) {
            this.log.info("Next variables turned NaN: " + StreamEx.of(nan).joining((CharSequence)",\t"));
        }
        if (!inf.isEmpty()) {
            this.log.info("Next variables turned INFINITE: " + StreamEx.of(inf).joining((CharSequence)",\t"));
        }
    }

    public SimulationResult generateSimulationResult() {
        SimulationResult result = new SimulationResult(null, "tmp");
        this.initSimulationResult(result);
        return result;
    }

    public int getSimulationType() {
        return DETERMINISTIC_TYPE;
    }

    public static class Var
    implements Comparable<Var> {
        public String name;
        public double initialValue;
        public Integer index;
        public Pen pen;
        public Var mainVar = null;
        public String title;

        public Var(Var mainVar) {
            this(mainVar.name, mainVar.initialValue, mainVar.index, mainVar.pen);
            this.mainVar = mainVar;
        }

        public Var(String name, double initialValue, Integer index, Pen pen) {
            this(name, name, initialValue, index, pen);
        }

        public Var(String name, String title, double initialValue, Integer index, Pen pen) {
            this.name = name;
            this.title = title;
            this.initialValue = initialValue;
            this.index = index;
            this.pen = pen;
        }

        @Override
        public int compareTo(Var o) {
            int compareNames = this.name.compareTo(o.name);
            return compareNames == 0 ? this.title.compareTo(o.title) : 1;
        }
    }
}

