/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Diagram;
import biouml.model.dynamics.EModel;
import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.SimulationEngineRegistry;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.ComponentModel;
import com.developmentontheedge.beans.model.Property;
import java.util.Arrays;
import java.util.Objects;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.analysiscore.AbstractAnalysisParameters;

public class SimulationAnalysisParameters
extends AbstractAnalysisParameters {
    private DataElementPath modelPath;
    private Diagram diagram;
    private DataElementPath simulationResultPath;
    private int skipPoints = 0;
    private double outputStartTime = 0.0;
    private String simulationEngineName;
    private SimulationEngine simulationEngine;

    public SimulationAnalysisParameters() {
        String[] availableEngines = this.getAvailableEngines();
        if (availableEngines.length > 0) {
            this.setSimulationEngineName(availableEngines[0]);
        }
    }

    public DataElementPath getModelPath() {
        return this.modelPath;
    }

    public void setModelPath(DataElementPath modelPath) {
        if (modelPath == null) {
            return;
        }
        DataElement de = modelPath.optDataElement();
        if (!(de instanceof Diagram) || !(((Diagram)de).getRole() instanceof EModel)) {
            return;
        }
        this.diagram = (Diagram)de;
        String[] allowedEngines = SimulationEngineRegistry.getSimulationEngineNames((EModel)this.diagram.getRole(EModel.class));
        if (allowedEngines.length != 0 && !Arrays.asList(allowedEngines).contains(this.simulationEngineName)) {
            this.setSimulationEngineName(allowedEngines[0]);
        }
        this.setEngineDiagram();
        DataElementPath oldValue = this.modelPath;
        this.modelPath = modelPath;
        this.firePropertyChange("modelPath", oldValue, modelPath);
    }

    public SimulationEngine getSimulationEngine() {
        return this.simulationEngine;
    }

    public void setSimulationEngine(SimulationEngine engine) {
        this.setSimulationEngine(engine, false);
    }

    private void setSimulationEngine(SimulationEngine engine, boolean initFromModel) {
        SimulationEngine oldValue = this.simulationEngine;
        this.simulationEngine = engine;
        if (engine != null) {
            engine.setParent((Option)this);
            ComponentModel model = ComponentFactory.getModel((Object)((Object)this));
            ComponentFactory.recreateChildProperties((Property)model);
            this.setEngineDiagram();
        }
        this.firePropertyChange("simulationEngine", oldValue, engine);
    }

    private void setEngineDiagram() {
        if (this.diagram == null || this.simulationEngine == null) {
            return;
        }
        double initialTime = this.simulationEngine.getInitialTime();
        double completionTime = this.simulationEngine.getCompletionTime();
        double timeIncrement = this.simulationEngine.getTimeIncrement();
        this.simulationEngine.setDiagram(this.diagram);
        this.simulationEngine.setInitialTime(initialTime);
        this.simulationEngine.setCompletionTime(completionTime);
        this.simulationEngine.setTimeIncrement(timeIncrement);
    }

    public String getSimulationEngineName() {
        return this.simulationEngineName;
    }

    public void setSimulationEngineName(String engineName) {
        if (Objects.equals(engineName, this.simulationEngineName)) {
            return;
        }
        String oldValue = this.simulationEngineName;
        this.simulationEngineName = engineName;
        SimulationEngine engine = SimulationEngineRegistry.getSimulationEngine(engineName);
        this.setSimulationEngine(engine, false);
        this.firePropertyChange("simulationEngineName", oldValue, engineName);
    }

    public DataElementPath getSimulationResultPath() {
        return this.simulationResultPath;
    }

    public void setSimulationResultPath(DataElementPath simulationResultPath) {
        DataElementPath oldValue = this.simulationResultPath;
        this.simulationResultPath = simulationResultPath;
        this.firePropertyChange("simulationResultPath", oldValue, simulationResultPath);
    }

    public int getSkipPoints() {
        return this.skipPoints;
    }

    public void setSkipPoints(int skipPoints) {
        Integer oldValue = this.skipPoints;
        this.skipPoints = skipPoints;
        this.firePropertyChange("skipPoints", oldValue, skipPoints);
    }

    public double getOutputStartTime() {
        return this.outputStartTime;
    }

    public void setOutputStartTime(double outputStartTime) {
        Double oldValue = this.outputStartTime;
        this.outputStartTime = outputStartTime;
        this.firePropertyChange("outputStartTime", oldValue, outputStartTime);
    }

    public String[] getAvailableEngines() {
        if (this.diagram == null) {
            return new String[0];
        }
        EModel emodel = (EModel)this.diagram.getRole(EModel.class);
        return SimulationEngineRegistry.getSimulationEngineNames(emodel);
    }
}

