/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Diagram;
import biouml.model.dynamics.EModel;
import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.ResultWriter;
import biouml.plugins.simulation.SimulationAnalysisParameters;
import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.UniformSpan;
import biouml.plugins.simulation.java.JavaSimulationEngine;
import biouml.standard.simulation.ResultListener;
import biouml.standard.simulation.SimulationResult;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import ru.biosoft.access.core.ClassIcon;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.analysiscore.AnalysisJobControl;
import ru.biosoft.analysiscore.AnalysisMethodSupport;
import ru.biosoft.analysiscore.AnalysisParameters;

@ClassIcon(value="resources/simulation-analysis.gif")
public class SimulationAnalysis
extends AnalysisMethodSupport<SimulationAnalysisParameters> {
    private SimulationAnalysisJobControl jobControl;
    private List<PropertyChangeListener> listenersList;
    private List<ResultListener> resultListenerList;

    public SimulationAnalysis(DataCollection<?> origin, String name) {
        super(origin, name, (AnalysisParameters)new SimulationAnalysisParameters());
        this.log = Logger.getLogger(SimulationAnalysis.class.getName());
        this.jobControl = new SimulationAnalysisJobControl(Logger.getLogger(SimulationAnalysis.class.getName()));
        this.listenersList = new ArrayList<PropertyChangeListener>();
        this.resultListenerList = new ArrayList<ResultListener>();
    }

    public void validateParameters() throws IllegalArgumentException {
        SimulationEngine engine;
        SimulationAnalysisParameters params = (SimulationAnalysisParameters)this.getParameters();
        if (params.getModelPath() != null) {
            super.validateParameters();
            Diagram diagram = (Diagram)((SimulationAnalysisParameters)this.parameters).getModelPath().getDataElement(Diagram.class);
            if (diagram.getRole() == null || !(diagram.getRole() instanceof EModel)) {
                throw new IllegalArgumentException("Diagram does not contain a model. Please, select valid diagram.");
            }
        }
        if ((engine = ((SimulationAnalysisParameters)this.parameters).getSimulationEngine()) == null) {
            throw new IllegalArgumentException("Wrong simulation engine type");
        }
    }

    public SimulationAnalysisJobControl getJobControl() {
        return this.jobControl;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listenersList.add(l);
    }

    public void addResultListenerList(ResultListener resultListener) {
        this.resultListenerList.add(resultListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listenersList.remove(l);
    }

    public SimulationResult justAnalyzeAndPut() throws Exception {
        SimulationResult result;
        this.validateParameters();
        SimulationAnalysisParameters params = (SimulationAnalysisParameters)this.getParameters();
        SimulationEngine engine = params.getSimulationEngine();
        engine.setTerminated(false);
        Model model = engine.createModel();
        ArrayList<ResultListener> listeners = new ArrayList<ResultListener>();
        listeners.add(this.jobControl);
        DataElementPath resultPath = params.getSimulationResultPath();
        int skipPoints = params.getSkipPoints();
        if (params.getOutputStartTime() > engine.getInitialTime() && engine instanceof JavaSimulationEngine) {
            UniformSpan span = new UniformSpan(params.getOutputStartTime(), engine.getCompletionTime(), engine.getTimeIncrement());
            span.addPoints(new double[]{engine.getInitialTime()});
            ((JavaSimulationEngine)engine).setSpan(span);
            ++skipPoints;
        }
        ResultWriter writer = null;
        if (resultPath != null) {
            result = new SimulationResult(resultPath.optParentCollection(), resultPath.getName());
            writer = new ResultWriter(result);
            writer.setSkipPoints(skipPoints);
            engine.initSimulationResult(result);
            this.jobControl.setPreparedness(5);
            listeners.add(writer);
            writer.start(model);
            this.jobControl.pushProgress(10, 95);
            this.jobControl.setPercentStep(100.0 / (engine.getCompletionTime() - engine.getInitialTime()));
            for (PropertyChangeListener propertyChangeListener : this.listenersList) {
                listeners.add(new ResultListenerAdapter(propertyChangeListener, result));
            }
        }
        listeners.addAll(this.resultListenerList);
        try {
            if (!engine.isTerminated()) {
                engine.simulate(model, listeners.toArray(new ResultListener[listeners.size()]));
            }
        }
        catch (Exception e) {
            engine.log.error("ERROR_SIMULATION", new String[]{engine.getDiagram().getName(), e.toString()}, e);
            return null;
        }
        this.jobControl.popProgress();
        if (resultPath != null && writer != null) {
            result = writer.getResults();
            resultPath.save((DataElement)result);
            for (PropertyChangeListener propertyChangeListener : this.listenersList) {
                PropertyChangeEvent evt = new PropertyChangeEvent((Object)this, "end", null, result);
                propertyChangeListener.propertyChange(evt);
            }
            return result;
        }
        for (ResultListener resultListener : this.resultListenerList) {
            if (!(resultListener instanceof ResultWriter)) continue;
            return ((ResultWriter)resultListener).getResults();
        }
        return null;
    }

    public class SimulationAnalysisJobControl
    extends AnalysisJobControl
    implements ResultListener {
        private double percentStep;

        public SimulationAnalysisJobControl(Logger l) {
            super((AnalysisMethodSupport)SimulationAnalysis.this);
        }

        public void add(double t, double[] y) throws Exception {
            this.setPreparedness((int)(t * this.percentStep));
        }

        public void start(Object model) {
        }

        public void setPercentStep(double step) {
            this.percentStep = step;
        }

        protected void setTerminated(int status) {
            SimulationAnalysisParameters params = (SimulationAnalysisParameters)SimulationAnalysis.this.getParameters();
            SimulationEngine engine = params.getSimulationEngine();
            engine.stopSimulation();
            super.setTerminated(status);
        }
    }

    public static class ResultListenerAdapter
    implements ResultListener {
        PropertyChangeListener listener = null;
        private SimulationResult result;

        public ResultListenerAdapter(PropertyChangeListener pcl, SimulationResult result) {
            this.listener = pcl;
            this.result = result;
        }

        public void add(double t, double[] y) throws Exception {
            PropertyChangeEvent evt = new PropertyChangeEvent(this.result, "change", null, null);
            this.listener.propertyChange(evt);
        }

        public void start(Object model) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this.result, "start", null, null);
            this.listener.propertyChange(evt);
        }
    }
}

