/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Diagram;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.plugins.simulation.Preprocessor;
import java.util.ArrayList;
import one.util.streamex.StreamEx;

public class ScalarCyclesPreprocessor
extends Preprocessor {
    private static final int OUTPUT_LIMIT = 10;

    @Override
    public Diagram preprocess(Diagram diagram) throws Exception {
        ArrayList cycledEquations = new ArrayList();
        ((EModel)diagram.getRole(EModel.class)).orderScalarEquations(cycledEquations);
        if (cycledEquations.size() > 0) {
            this.log.info("Assignments for next variables form cycle and were transformed to algebraic equations:");
            this.log.info(((StreamEx)StreamEx.of(cycledEquations).limit(10L)).map(eq -> eq.getVariable()).joining((CharSequence)", "));
            if (cycledEquations.size() > 10) {
                this.log.info("and " + (cycledEquations.size() - 10) + " more...");
            }
            this.log.info("To avoid this message please transform equations manually.");
        }
        for (Equation eq2 : cycledEquations) {
            eq2.setFormula(eq2.getFormula() + " - " + eq2.getVariable());
            eq2.setType("algebraic");
        }
        return diagram;
    }
}

