/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.dynamics.plot.Experiment;
import biouml.model.dynamics.plot.PlotInfo;
import biouml.plugins.simulation.CycledResultListener;
import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.plot.PlotPane;
import biouml.standard.simulation.plot.Plot;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import one.util.streamex.StreamEx;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.AbstractSeriesDataset;
import org.jfree.data.general.Series;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import ru.biosoft.graphics.Pen;
import ru.biosoft.jobcontrol.FunctionJobControl;
import ru.biosoft.table.TableDataCollection;
import ru.biosoft.table.TableDataCollectionUtils;

public class ResultPlotPane
extends JPanel
implements CycledResultListener {
    private static final String DEFAULT_Y_AXIS_LABEL = "Quantity or concentration";
    public static final Paint[] POSSIBLE_COLORS = new Paint[]{new Color(255, 85, 85), new Color(85, 85, 255), new Color(0, 255, 0), Color.pink, ChartColor.DARK_RED, ChartColor.DARK_BLUE, ChartColor.DARK_GREEN, ChartColor.DARK_MAGENTA, ChartColor.DARK_CYAN, Color.darkGray, ChartColor.VERY_DARK_RED, ChartColor.VERY_DARK_BLUE, ChartColor.VERY_DARK_GREEN, ChartColor.VERY_DARK_YELLOW, ChartColor.VERY_DARK_MAGENTA, ChartColor.VERY_DARK_CYAN};
    protected XYSeriesCollection dataset;
    protected JFreeChart chart;
    protected List<Double> times;
    protected List<double[]> values;
    protected ChartPanel chartPanel;
    protected boolean doRepeats = false;
    protected PlotInfo plotInfo = null;
    protected SimulationEngine.Var xVariable;
    protected Map<SimulationEngine.Var, List<Series>> variableIndeces;
    protected FunctionJobControl jobControl;
    protected SimulationEngine simulationEngine;
    protected Dimension paneSize = new Dimension(500, 270);
    protected boolean notify = false;
    protected int cyclesNumber;
    protected int spanIndex;

    public ResultPlotPane(SimulationEngine simulationEngine, FunctionJobControl jobControl) {
        this.simulationEngine = simulationEngine;
        this.jobControl = jobControl;
    }

    public ResultPlotPane(SimulationEngine simulationEngine, FunctionJobControl jobControl, PlotInfo plotInfo) {
        this(simulationEngine, jobControl);
        this.plotInfo = plotInfo;
    }

    public SimulationEngine getSimulationEngine() {
        return this.simulationEngine;
    }

    protected void createChartPanel() {
        this.xVariable = this.simulationEngine.getXVariable(this.plotInfo);
        this.variableIndeces = this.getVariables();
        String yAxisLabel = this.variableIndeces.size() == 1 ? StreamEx.of(this.variableIndeces.keySet()).findFirst().map(v -> v.title).get() : DEFAULT_Y_AXIS_LABEL;
        this.chart = ChartFactory.createXYLineChart((String)(this.plotInfo != null ? this.plotInfo.getTitle() : "Simulation result"), (String)this.xVariable.title, (String)yAxisLabel, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chart.setBackgroundPaint((Paint)Color.white);
        this.chart.getLegend().setBorder(1.0, 1.0, 1.0, 1.0);
        this.chartPanel = new ChartPanel(this.chart);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setDrawSeriesLineAsPath(true);
        XYPlot plot = this.chart.getXYPlot();
        ValueAxis axis = PlotPane.generateAxis(Plot.AxisType.getAxisType((String)this.plotInfo.getXAxisType()));
        if (axis != null) {
            plot.setDomainAxis(axis);
        }
        if (this.plotInfo.getXFrom() != this.plotInfo.getXTo()) {
            plot.getDomainAxis().setLowerBound(this.plotInfo.getXFrom());
            plot.getDomainAxis().setUpperBound(this.plotInfo.getXTo());
        } else {
            plot.getDomainAxis().setLowerBound(this.simulationEngine.getInitialTime());
            plot.getDomainAxis().setUpperBound(this.simulationEngine.getCompletionTime());
        }
        plot.getDomainAxis().setAutoRange(this.plotInfo.isXAutoRange());
        axis = PlotPane.generateAxis(Plot.AxisType.getAxisType((String)this.plotInfo.getYAxisType()));
        if (axis != null) {
            plot.setRangeAxis(axis);
        }
        if (this.plotInfo.getYFrom() != this.plotInfo.getYTo()) {
            plot.getRangeAxis().setLowerBound(this.plotInfo.getYFrom());
            plot.getRangeAxis().setUpperBound(this.plotInfo.getYTo());
        }
        plot.getRangeAxis().setAutoRange(this.plotInfo.isYAutoRange());
        plot.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(POSSIBLE_COLORS, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
        this.dataset = new XYSeriesCollection();
        this.initSeries(renderer, this.dataset);
        if (this.plotInfo.getExperiments() != null) {
            ResultPlotPane.addExperiments(this.plotInfo.getExperiments(), renderer, (AbstractSeriesDataset)this.dataset, this.simulationEngine.getCompletionTime());
        }
        this.chart.getXYPlot().getRangeAxis().setLabel(this.plotInfo.getYAxisInfo().getTitle());
        this.chart.getXYPlot().getDomainAxis().setLabel(this.plotInfo.getXAxisInfo().getTitle());
        this.chart.getXYPlot().getRangeAxis().setLabelFont(new Font("Arial", 1, 18));
        this.chart.getXYPlot().getRangeAxis().setTickLabelFont(new Font("Arial", 0, 16));
        this.chart.getXYPlot().getDomainAxis().setLabelFont(new Font("Arial", 1, 18));
        this.chart.getXYPlot().getDomainAxis().setTickLabelFont(new Font("Arial", 0, 16));
        this.chart.getXYPlot().setBackgroundPaint((Paint)Color.white);
        this.chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
        this.chart.getXYPlot().setDataset((XYDataset)this.dataset);
    }

    protected void initSeries(XYLineAndShapeRenderer renderer, XYSeriesCollection dataset) {
        int counter = 0;
        for (Map.Entry<SimulationEngine.Var, List<Series>> e : this.variableIndeces.entrySet()) {
            SimulationEngine.Var var = e.getKey();
            List<Series> seriesList = e.getValue();
            if (seriesList == null) continue;
            if (seriesList.size() > 1) {
                this.doRepeats = true;
            }
            for (int i = 0; i < seriesList.size(); ++i) {
                XYSeries series = (XYSeries)seriesList.get(i);
                Pen spec = var.pen;
                if (spec != null) {
                    renderer.setSeriesPaint(counter, (Paint)spec.getColor());
                    renderer.setSeriesStroke(counter, (Stroke)spec.getStroke());
                    renderer.setSeriesVisibleInLegend(counter, Boolean.valueOf(i == 0));
                }
                renderer.setSeriesShapesVisible(counter, false);
                ++counter;
                dataset.addSeries(series);
            }
        }
    }

    protected Map<SimulationEngine.Var, List<Series>> getVariables() {
        return this.simulationEngine.getVariablesToPlot(this.plotInfo);
    }

    protected void createUI() {
        this.createChartPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbl.setConstraints(this, gbc);
        this.setLayout(gbl);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)this.chartPanel, new GridBagConstraints(0, 0, 1, 5, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        if (this.jobControl != null) {
            JPanel buttonPanel = new JPanel(new BorderLayout());
            this.add((Component)buttonPanel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            JButton stopButton = new JButton("Stop");
            buttonPanel.add((Component)stopButton, "East");
            buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            stopButton.addActionListener(ae -> {
                this.simulationEngine.stopSimulation();
                this.jobControl.terminate();
            });
        }
        JFrame frame = new JFrame(this.chartPanel.getChart().getTitle().getText());
        frame.setSize(700, 700);
        frame.getContentPane().setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        frame.getContentPane().add((Component)mainPanel, "Center");
        mainPanel.add((Component)this, "Center");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ResultPlotPane.this.simulationEngine.stopSimulation();
                if (ResultPlotPane.this.jobControl != null) {
                    ResultPlotPane.this.jobControl.terminate();
                }
            }
        });
    }

    public void add(double t, double[] y) {
        if (this.cyclesNumber == 1 || this.doRepeats) {
            this.addAsFirst(t, y);
        } else {
            this.update(t, y);
        }
        ++this.spanIndex;
    }

    public void start(Object model) {
        this.cyclesNumber = 1;
        this.spanIndex = 0;
        this.values = new ArrayList<double[]>();
        this.createUI();
    }

    @Override
    public final void startCycle() {
        ++this.cyclesNumber;
        this.spanIndex = 0;
    }

    @Override
    public void addAsFirst(double t, double[] y) {
        for (Map.Entry<SimulationEngine.Var, List<Series>> e : this.variableIndeces.entrySet()) {
            ((XYSeries)e.getValue().get(this.cyclesNumber - 1)).add(y[this.xVariable.index], y[e.getKey().index], true);
        }
        this.values.add(this.spanIndex, y);
    }

    @Override
    public void update(double t, double[] y) {
        double[] newY = this.values.get(this.spanIndex);
        for (Map.Entry<SimulationEngine.Var, List<Series>> e : this.variableIndeces.entrySet()) {
            int index;
            int n = index = e.getKey().index.intValue();
            newY[n] = newY[n] + y[index];
            double time = ((XYSeries)e.getValue().get(0)).getX(this.spanIndex).doubleValue();
            ((XYSeries)e.getValue().get(0)).update((Number)time, (Number)(newY[index] / (double)this.cyclesNumber));
        }
    }

    @Override
    public void finish() {
    }

    public static void addExperiments(Experiment[] experiments, XYLineAndShapeRenderer renderer, AbstractSeriesDataset dataset, double timeLimit) {
        int counter = dataset.getSeriesCount();
        for (Experiment experiment : experiments) {
            int i;
            YIntervalSeries series;
            TableDataCollection tdc = (TableDataCollection)experiment.getPath().getDataElement(TableDataCollection.class);
            String columnNameX = experiment.getNameX();
            String columnNameY = experiment.getNameY();
            String title = experiment.getTitle();
            double[] valuesY = TableDataCollectionUtils.getColumn((TableDataCollection)tdc, (String)columnNameY);
            double[] valuesX = TableDataCollectionUtils.getColumn((TableDataCollection)tdc, (String)columnNameX);
            Pen spec = experiment.getPen();
            if (spec != null) {
                renderer.setSeriesPaint(counter, (Paint)spec.getColor());
                renderer.setSeriesStroke(counter, (Stroke)spec.getStroke());
                renderer.setSeriesVisibleInLegend(counter, Boolean.valueOf(true));
            }
            renderer.setSeriesShapesVisible(counter, true);
            renderer.setSeriesLinesVisible(counter, false);
            renderer.setSeriesShape(counter, (Shape)new Ellipse2D.Float(0.0f, 0.0f, 5.0f, 5.0f));
            ++counter;
            if (dataset instanceof YIntervalSeriesCollection) {
                series = new YIntervalSeries((Comparable)((Object)title), false, true);
                for (i = 0; i < valuesX.length && valuesX[i] <= timeLimit; ++i) {
                    series.add(valuesX[i], valuesY[i], 0.0, 0.0);
                }
                ((YIntervalSeriesCollection)dataset).addSeries(series);
                continue;
            }
            if (!(dataset instanceof XYSeriesCollection)) continue;
            series = new XYSeries((Comparable)((Object)title), false, true);
            for (i = 0; i < valuesX.length && valuesX[i] <= timeLimit; ++i) {
                series.add(valuesX[i], valuesY[i]);
            }
            ((XYSeriesCollection)dataset).addSeries((XYSeries)series);
        }
    }
}

