/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Diagram;
import biouml.plugins.simulation.document.OpenInteractiveSimulationAction;
import biouml.plugins.simulation.plot.OpenPlotAction;
import biouml.plugins.simulation.resources.MessageBundle;
import biouml.plugins.state.ApplyStateAction;
import biouml.standard.simulation.SimulationResult;
import biouml.standard.simulation.plot.Plot;
import biouml.standard.state.State;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.action.ActionInitializer;
import com.developmentontheedge.application.action.ActionManager;
import com.developmentontheedge.beans.ActionsProvider;
import javax.swing.Action;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.repository.RepositoryListener;
import ru.biosoft.gui.DocumentManager;
import ru.biosoft.gui.GUI;

public class RepositoryActionsProvider
implements ActionsProvider,
RepositoryListener {
    private boolean initialized = false;

    public Action[] getActions(Object obj) {
        ActionManager actionManager = Application.getActionManager();
        if (!this.initialized) {
            this.initialized = true;
            OpenPlotAction openPlotAction = new OpenPlotAction();
            actionManager.addAction("Open plot", (Action)openPlotAction);
            OpenPlotAction newPlotAction = new OpenPlotAction();
            actionManager.addAction("New plot", (Action)newPlotAction);
            OpenInteractiveSimulationAction newInteractiveSimulationAction = new OpenInteractiveSimulationAction();
            actionManager.addAction("Open interactive simulation", (Action)newInteractiveSimulationAction);
            ApplyStateAction applyStateActon = new ApplyStateAction();
            actionManager.addAction("Apply state", (Action)applyStateActon);
            ActionInitializer initializer = new ActionInitializer(new Class[]{MessageBundle.class});
            initializer.initAction((Action)openPlotAction, "Open plot");
            initializer.initAction((Action)newPlotAction, "New plot");
            initializer.initAction((Action)applyStateActon, "Apply state");
            initializer.initAction((Action)newInteractiveSimulationAction, "Open interactive simulation");
            this.initListeners();
        }
        if (obj instanceof SimulationResult || obj instanceof Plot) {
            Action[] actionArray;
            Action newPlotAction = actionManager.getAction("New plot");
            Action openPlotAction = actionManager.getAction("Open plot");
            Action removeDataElementAction = actionManager.getAction("Remove Data Element");
            removeDataElementAction.putValue("Data element", obj);
            if (obj instanceof SimulationResult) {
                Action[] actionArray2 = new Action[2];
                actionArray2[0] = newPlotAction;
                actionArray = actionArray2;
                actionArray2[1] = removeDataElementAction;
            } else {
                Action[] actionArray3 = new Action[2];
                actionArray3[0] = openPlotAction;
                actionArray = actionArray3;
                actionArray3[1] = removeDataElementAction;
            }
            return actionArray;
        }
        if (obj instanceof State) {
            return new Action[]{actionManager.getAction("Apply state")};
        }
        if (obj instanceof Diagram) {
            return new Action[]{actionManager.getAction("Open interactive simulation")};
        }
        return null;
    }

    protected void initListeners() {
        GUI.getManager().getRepositoryTabs().addListener((RepositoryListener)this);
    }

    public void nodeClicked(DataElement node, int clickCount) {
        if (clickCount > 1 && node instanceof Plot) {
            DocumentManager.getDocumentManager().openDocument(node);
        }
    }

    public void selectionChanged(DataElement node) {
    }
}

