/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.ExpressionOwner;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.model.dynamics.util.EModelHelper;
import biouml.plugins.simulation.Preprocessor;
import biouml.standard.diagram.Util;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.awt.Point;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.LinearFormatter;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.Utils;

public class RateOfPreprocessor
extends Preprocessor {
    private static final String RATE_OF_PREFIX = "RATE_OF_";

    @Override
    public boolean accept(Diagram diagram) {
        return diagram.getRole() instanceof EModel;
    }

    @Override
    public Diagram preprocess(Diagram diagram) throws Exception {
        EModel emodel = (EModel)diagram.getRole(EModel.class);
        for (Map.Entry entry : EModelHelper.findDefiningEquations((EModel)emodel).entrySet()) {
            Equation eq22;
            List rateEqs = ((StreamEx)StreamEx.of((Collection)((Collection)entry.getValue())).filter(eq -> "rate".equals(eq.getType()) || "rate_by_rule".equals(eq.getType()))).toList();
            if (rateEqs.isEmpty()) continue;
            String varName = this.generateRateName((String)entry.getKey());
            emodel.declareVariable(varName, (Object)0.0);
            DynamicPropertySet rateOfAttrs = emodel.getVariable(varName).getAttributes();
            rateOfAttrs.add(new DynamicProperty("isRate", Boolean.TYPE, (Object)true));
            rateOfAttrs.add(new DynamicProperty("autogenerated", Boolean.TYPE, (Object)true));
            StringBuilder newFormula = new StringBuilder();
            Variable var = emodel.getVariable((String)entry.getKey());
            boolean reaction = false;
            for (Equation eq22 : rateEqs) {
                reaction = Util.isSpecieReference((DiagramElement)eq22.getDiagramElement());
                String formula = eq22.getFormula();
                if (!formula.startsWith("-")) {
                    newFormula.append("+");
                }
                newFormula.append(formula);
            }
            String formula = newFormula.toString();
            if (var instanceof VariableRole) {
                String factor = emodel.getConversionFactor(var);
                if (reaction) {
                    Role role;
                    if (factor != null) {
                        formula = "(" + formula + ")*" + factor;
                    }
                    if (((VariableRole)var).getQuantityType() == 1 && (role = ((VariableRole)var).getDiagramElement().getCompartment().getRole()) instanceof VariableRole) {
                        formula = "(" + formula + ")/" + ((VariableRole)role).getName();
                    }
                }
            }
            eq22 = new Equation(null, "scalar", varName, formula);
            DiagramElement de2 = diagram.getType().getSemanticController().createInstance((Compartment)diagram, Equation.class, new Point(), (Object)eq22).getElement();
            diagram.put(de2);
        }
        for (ExpressionOwner owner : diagram.recursiveStream().map(de -> de.getRole()).select(ExpressionOwner.class)) {
            String[] expressions = owner.getExpressions();
            for (int i = 0; i < expressions.length; ++i) {
                if (expressions[i] == null || !expressions[i].contains("rateOf")) continue;
                AstStart start = emodel.readMath(expressions[i], owner.getRole());
                this.replaceRateOf((Node)start);
                expressions[i] = new LinearFormatter().format(start)[1];
            }
            owner.setExpressions(expressions);
        }
        return diagram;
    }

    private String generateRateName(String varName) {
        return RATE_OF_PREFIX + varName.replace(".", "_").replace("$", "");
    }

    private void replaceRateOf(Node start) {
        Node argNode;
        if (start instanceof AstFunNode && "rateOf".equals(((AstFunNode)start).getFunction().getName()) && (argNode = start.jjtGetChild(0)) instanceof AstVarNode) {
            String varName = ((AstVarNode)argNode).getName();
            start.jjtGetParent().jjtReplaceChild(start, (Node)Utils.createVariabl((String)this.generateRateName(varName)));
            return;
        }
        for (int i = 0; i < start.jjtGetNumChildren(); ++i) {
            this.replaceRateOf(start.jjtGetChild(i));
        }
    }
}

