/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Role;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.model.dynamics.util.EModelHelper;
import biouml.plugins.simulation.EquationTypePreprocessor;
import biouml.plugins.simulation.FastReactionPreprocessor;
import biouml.plugins.simulation.Preprocessor;
import biouml.standard.diagram.Util;
import biouml.standard.type.Compartment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.biosoft.math.model.ASTVisitor;
import ru.biosoft.math.model.ASTVisitorSupport;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.Function;
import ru.biosoft.math.model.LinearFormatter;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.Utils;

public class RateAssignmentRulePreprocessor
extends Preprocessor {
    private CompartmentDivisionASTVisitor visitor;
    private LinearFormatter formatter;
    private EModel emodel;
    private Map<String, List<Equation>> definingEquations;

    @Override
    public boolean accept(Diagram diagram) {
        return diagram.getRole() instanceof EModel;
    }

    @Override
    public Diagram preprocess(Diagram diagram) throws Exception {
        this.emodel = (EModel)diagram.getRole(EModel.class);
        this.formatter = new LinearFormatter();
        this.visitor = new CompartmentDivisionASTVisitor();
        this.definingEquations = EModelHelper.findDefiningEquations((EModel)this.emodel);
        HashMap<String, Equation> initialEquations = new HashMap<String, Equation>();
        for (Equation eq : this.emodel.getEquations()) {
            eq.unlinkKernel();
            if (!EquationTypePreprocessor.isInternal(eq) && ("initial assignment".equals(eq.getType()) || "scalar".equals(eq.getType()) || "rate_by_rule".equals(eq.getType()) || "rate".equals(eq.getType()))) {
                String newFormula = this.applyCompartmentRateRule(eq);
                if (newFormula == null) {
                    newFormula = RateAssignmentRulePreprocessor.applyCompartment(eq.getVariable(), eq.getFormula(), this.emodel);
                }
                if (newFormula != null) {
                    eq.setFormula(newFormula);
                }
                if ("initial assignment".equals(eq.getType()) || "scalar".equals(eq.getType())) {
                    initialEquations.put(eq.getVariable(), eq);
                }
            }
            this.applyConversionFactor(eq);
            eq.setFormula(this.divideByCompartment(eq.getMath()));
        }
        for (Event eq : this.emodel.getEvents()) {
            for (Assignment sa : eq.getEventAssignment()) {
                String newFormula = RateAssignmentRulePreprocessor.applyCompartment(sa.getVariable(), sa.getMath(), this.emodel);
                if (newFormula != null) {
                    sa.setMath(newFormula);
                }
                sa.setMath(this.divideByCompartment(this.emodel.readMath(sa.getMath(), (Role)eq)));
            }
            eq.setTrigger(this.divideByCompartment(this.emodel.readMath(eq.getTrigger(), (Role)eq)));
            if (eq.getPriority() == null || eq.getPriority().isEmpty()) continue;
            eq.setPriority(this.divideByCompartment(this.emodel.readMath(eq.getPriority(), (Role)eq)));
        }
        for (VariableRole var : this.emodel.getVariableRoles()) {
            biouml.model.Compartment compartment;
            int initialType = var.getInitialQuantityType();
            if (initialType != 1 || initialEquations.containsKey(var.getName()) || !((compartment = var.getDiagramElement().getCompartment()).getRole() instanceof VariableRole)) continue;
            FastReactionPreprocessor.createEquation(diagram, var.getName(), "(" + var.getInitialValue() + ")*" + ((VariableRole)compartment.getRole(VariableRole.class)).getName(), "initial value assignment");
        }
        return diagram;
    }

    public void applyConversionFactor(Equation eq) {
        String varName;
        Variable var;
        String conversionFactor;
        if ("rate".equals(eq.getType()) && Util.isSpecieReference((DiagramElement)eq.getParent()) && (conversionFactor = this.emodel.getConversionFactor(var = this.emodel.getVariable(varName = eq.getVariable()))) != null) {
            eq.setFormula("(" + eq.getFormula() + ") *" + conversionFactor);
        }
    }

    public String applyCompartmentRateRule(Equation eq) {
        if ("rate_by_rule".equals(eq.getType()) || "rate".equals(eq.getType())) {
            String variableName = eq.getVariable();
            Variable variable = this.emodel.getVariable(variableName);
            if (!(variable instanceof VariableRole)) {
                return null;
            }
            if (((VariableRole)variable).getQuantityType() == 0) {
                return null;
            }
            DiagramElement de = ((VariableRole)variable).getDiagramElement();
            if (!(de instanceof biouml.model.Node)) {
                return null;
            }
            biouml.model.Compartment compartment = ((biouml.model.Node)de).getCompartment();
            if (compartment instanceof Diagram) {
                return null;
            }
            VariableRole compartmentVariable = (VariableRole)compartment.getRole(VariableRole.class);
            if (compartmentVariable.isConstant() || !this.definingEquations.containsKey(compartmentVariable.getName())) {
                return null;
            }
            for (Equation compartmentEq : this.definingEquations.get(compartmentVariable.getName())) {
                if (!"rate_by_rule".equals(compartmentEq.getType()) && !"rate".equals(compartmentEq.getType())) continue;
                return "(" + eq.getFormula() + ")*" + compartmentEq.getVariable() + "+" + compartmentEq.getFormula() + "*" + eq.getVariable();
            }
        }
        return null;
    }

    private static String applyCompartment(String varName, String formula, EModel emodel) {
        if (varName.length() > 1 && varName.charAt(0) == '$' && varName.charAt(1) != '$') {
            Variable var = emodel.getVariable(varName);
            if (!(var instanceof VariableRole) || ((VariableRole)var).getQuantityType() == 0) {
                return null;
            }
            VariableRole varRole = (VariableRole)var;
            if (varRole.getDiagramElement().getKernel() instanceof Compartment) {
                return null;
            }
            biouml.model.Compartment compartment = varRole.getDiagramElement().getCompartment();
            Role compRole = compartment.getRole();
            if (!(compRole instanceof Variable)) {
                return null;
            }
            return "( " + formula + " ) * " + ((Variable)compRole).getName();
        }
        return null;
    }

    private String divideByCompartment(AstStart start) throws Exception {
        Utils.visitAST((Node)start, (ASTVisitor)this.visitor);
        return this.formatter.format(start)[1];
    }

    public class CompartmentDivisionASTVisitor
    extends ASTVisitorSupport {
        public void visitNode(Node node) throws Exception {
            if (node instanceof AstVarNode) {
                AstVarNode variable = (AstVarNode)node;
                String varName = variable.getName();
                Variable var = RateAssignmentRulePreprocessor.this.emodel.getVariable(varName);
                if (!(var instanceof VariableRole)) {
                    return;
                }
                if (((VariableRole)var).getQuantityType() == 0) {
                    return;
                }
                DiagramElement de = ((VariableRole)var).getDiagramElement();
                if (de.getKernel() instanceof Compartment) {
                    return;
                }
                biouml.model.Compartment compartment = (biouml.model.Compartment)de.getParent();
                if (compartment == null || compartment instanceof Diagram) {
                    return;
                }
                Role role = compartment.getRole();
                if (role == null || !(role instanceof VariableRole)) {
                    return;
                }
                AstVarNode compartmentNode = Utils.createVariabl((String)((VariableRole)compartment.getRole(VariableRole.class)).getName());
                Node parent = variable.jjtGetParent();
                if (parent instanceof AstFunNode && "delay".equals(((AstFunNode)parent).getFunction().getName())) {
                    Function f = ((AstFunNode)parent).getFunction();
                    Node delayValue = parent.jjtGetChild(1);
                    node = parent;
                    parent = parent.jjtGetParent();
                    compartmentNode = Utils.applyFunction((Node)compartmentNode, (Node)delayValue.cloneAST(), (Function)f);
                }
                parent.jjtReplaceChild(node, (Node)Utils.applyDivide((Node)node, (Node)compartmentNode));
            }
        }
    }
}

