/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Diagram;
import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.SimulationTask;
import biouml.plugins.simulation.SimulationTaskParameters;
import com.developmentontheedge.application.ApplicationUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import ru.biosoft.access.security.CodePrivilege;
import ru.biosoft.access.security.CodePrivilegeType;
import ru.biosoft.access.task.ExceptionalConsumer;
import ru.biosoft.access.task.TaskPool;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.jobcontrol.FunctionJobControl;
import ru.biosoft.jobcontrol.JobControl;
import ru.biosoft.jobcontrol.SubFunctionJobControl;
import ru.biosoft.util.ObjectPool;

@CodePrivilege(value={CodePrivilegeType.THREAD})
public class ParallelSimulationEngine {
    private final SimulationTaskFactory factory;
    private final EnginePool engines = new EnginePool();
    private final Diagram diagram;
    private final SimulationTaskParameters simulationParameters;
    private final Model model;
    private List<SimulationTask> tasks;
    private SimulationTask singleTask;

    public ParallelSimulationEngine(Diagram diagram, SimulationTaskParameters simulationParameters, SimulationTaskFactory factory) throws Exception {
        this.factory = factory;
        this.diagram = diagram;
        this.simulationParameters = simulationParameters;
        SimulationEngine engine = SimulationTask.initEngine(this.getDiagram(), this.getEngineSettings(), null);
        this.model = engine.createModel();
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public SimulationTaskParameters getEngineSettings() {
        return this.simulationParameters;
    }

    public Model getModel() {
        return this.model;
    }

    public double[][] simulate(double[][] values, String[] names, JobControl jobControl) {
        return this.simulate(values, names, jobControl, false);
    }

    public double[][] simulate(double[][] values, String[] names, JobControl jobControl, boolean returnIncomplete) {
        try {
            if (this.init(values, names)) {
                for (int i = 0; i < values.length; ++i) {
                    this.tasks.get(i).setValues(values[i]);
                }
                SubFunctionJobControl fjc = jobControl == null ? null : new SubFunctionJobControl(jobControl, jobControl.getPreparedness(), jobControl.getPreparedness());
                ExceptionalConsumer iteration = arg_0 -> ParallelSimulationEngine.lambda$simulate$0((FunctionJobControl)fjc, arg_0);
                if (jobControl == null) {
                    TaskPool.getInstance().iterate(this.tasks, iteration);
                } else {
                    TaskPool.getInstance().iterate(this.tasks, iteration, (JobControl)fjc);
                    if (jobControl.getStatus() == 4 && !returnIncomplete) {
                        return null;
                    }
                }
                return (double[][])this.tasks.stream().map(SimulationTask::getResult).toArray(x$0 -> new double[x$0][]);
            }
        }
        catch (Exception e) {
            throw ExceptionRegistry.translateException((Throwable)e);
        }
        return null;
    }

    public double[] simulate(double[] values, String[] names, JobControl jobControl) {
        Object sr = this.getResult(values, names, jobControl);
        return this.processResult(sr);
    }

    private boolean init(double[][] values, String[] names) {
        if (this.diagram == null) {
            return false;
        }
        if (values != null && names != null) {
            if (this.tasks == null) {
                this.tasks = new ArrayList<SimulationTask>();
            }
            if (values.length != this.tasks.size()) {
                this.tasks.clear();
                for (double[] value : values) {
                    SimulationTask task = this.factory.createSimulationTask(names);
                    task.setParameters(this.simulationParameters);
                    this.tasks.add(task);
                }
            }
        } else if (this.singleTask == null) {
            this.singleTask = this.factory.createSimulationTask(names);
            this.singleTask.setParameters(this.simulationParameters);
        }
        return true;
    }

    private boolean init() {
        return this.init(null, null);
    }

    public Object getResult(double[] values, String[] names) {
        return this.getResult(values, names, null);
    }

    public Object getResult(double[] values, String[] names, JobControl jobControl) {
        if (this.init()) {
            Object sr;
            this.singleTask.setValues(values);
            try {
                sr = this.singleTask.getResult(values, names, (FunctionJobControl)(jobControl == null ? null : new SubFunctionJobControl(jobControl, jobControl.getPreparedness(), jobControl.getPreparedness())));
            }
            catch (Exception e) {
                throw ExceptionRegistry.translateException((Throwable)e);
            }
            return sr;
        }
        return null;
    }

    public ObjectPool.PooledObject<ModelEngine> allocModelEngine() throws Exception {
        return this.engines.get();
    }

    public double[] processResult(Object sr) {
        return this.factory.processResult(sr);
    }

    private static /* synthetic */ void lambda$simulate$0(FunctionJobControl fjc, SimulationTask element) throws Exception {
        element.run(fjc);
    }

    public class EnginePool
    extends ObjectPool<ModelEngine> {
        protected ModelEngine createObject() throws Exception {
            return new ModelEngine(SimulationTask.initEngine(ParallelSimulationEngine.this.getDiagram(), ParallelSimulationEngine.this.getEngineSettings(), ParallelSimulationEngine.this.getModel()));
        }
    }

    public static class ModelEngine {
        private final SimulationEngine engine;
        private final Model baseModel;

        public ModelEngine(SimulationEngine engine) throws Exception {
            this.engine = engine;
            this.baseModel = engine.createModel();
            this.baseModel.init();
            ApplicationUtils.removeDir((File)new File(engine.getOutputDir()));
        }

        public SimulationEngine getEngine() {
            return this.engine;
        }

        public Model getBaseModel() {
            return this.baseModel;
        }
    }

    public static interface SimulationTaskFactory {
        public SimulationTask createSimulationTask(String[] var1);

        public double[] processResult(Object var1);
    }
}

