/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Compartment;
import biouml.model.Edge;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.plugins.simulation.BooleanPreprocessor;
import biouml.plugins.simulation.ConstraintPreprocessor;
import biouml.plugins.simulation.DelayPreprocessor;
import biouml.plugins.simulation.EmptyMathPreprocessor;
import biouml.plugins.simulation.EquationTypePreprocessor;
import biouml.plugins.simulation.EventPreprocessor;
import biouml.plugins.simulation.FastReactionPreprocessor;
import biouml.plugins.simulation.Preprocessor;
import biouml.plugins.simulation.RateAssignmentRulePreprocessor;
import biouml.plugins.simulation.RateOfPreprocessor;
import biouml.plugins.simulation.ResultWriter;
import biouml.plugins.simulation.ScalarCyclesPreprocessor;
import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.StateTransitionPreprocessor;
import biouml.plugins.simulation.StaticModelPreprocessor;
import biouml.plugins.simulation.TableElementPreprocessor;
import biouml.standard.diagram.CompositeModelPreprocessor;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.simulation.ResultListener;
import biouml.standard.simulation.SimulationResult;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import ru.biosoft.math.model.ASTVisitor;
import ru.biosoft.math.model.ASTVisitorSupport;
import ru.biosoft.math.model.AstConstant;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.Formatter;
import ru.biosoft.math.model.LinearFormatter;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.Utils;
import ru.biosoft.math.model.VariableResolver;
import ru.biosoft.util.TempFiles;

public abstract class OdeSimulationEngine
extends SimulationEngine {
    public static final String ARRAY_MODE_AUTO = "array_auto";
    public static final String ARRAY_MODE_ON = "array_on";
    public static final String ARRAY_MODE_OFF = "array_off";
    public static final int ARRAY_MODE_THRESHOLD = 100;
    public static final double DEFAULT_RELATIVE_TOLERANCE = 1.0E-11;
    public static final double DEFAULT_ABSOLUTE_TOLERANCE = 1.0E-10;
    protected String arrayMode = "array_off";
    public static final String ALGEBRAIC_SYSTEM = "Algebraic system";
    public static final String ODE_SYSTEM = "ODE system";
    protected String fastReactions = "ODE system";
    protected String constraintsViolation = "Stop simulation";
    protected Map<String, String> varNameMapping;
    protected Set<String> functionNames;
    protected Set<String> varNames;
    protected Map<String, List<Equation>> definingEquations;
    private boolean reactionVariables = false;
    private Map<String, Double> varInitialMapping = new HashMap<String, Double>();
    protected int variableArraySize;
    protected Map<String, Integer> varIndexMapping;
    protected Map<String, Integer> varPathIndexMapping;
    protected Map<String, String> varPathMapping;
    protected Map<String, Integer> varHistoricalIndexMapping;
    protected Map<String, Integer> varNameHistoryIndexMapping;
    protected Map<String, Integer> varNameRateIndexMapping;
    private Map<String, Map<String, String>> codeVariableNames;
    protected String outputDir = TempFiles.path((String)"simulation").getAbsolutePath();

    protected void init() throws Exception {
        boolean autodetect = this.executableModel.isAutodetectTypes();
        this.executableModel.setAutodetectTypes(false);
        try {
            this.log.info("Model " + this.diagram.getName() + ": preprocessing...");
            new File(this.getOutputDir()).mkdirs();
            this.diagram = this.originalDiagram.clone(this.originalDiagram.getOrigin(), this.originalDiagram.getName());
            if (DiagramUtility.containModules((Compartment)this.diagram)) {
                CompositeModelPreprocessor preprocessor = new CompositeModelPreprocessor();
                this.diagram = preprocessor.preprocess(this.diagram, this.diagram.getOrigin());
                this.executableModel = (EModel)this.diagram.getRole();
                this.codeVariableNames = preprocessor.getCodeVariableNames();
                this.varPathMapping = preprocessor.getVarPathMapping("");
            }
            Logger.getLogger(EModel.class.getName()).setLevel(this.log.getLogger().getLevel());
            this.preprocess(this.diagram);
            this.modelType = this.executableModel.getModelType();
            this.executableModel.detectVariableTypes();
            this.initDefiningEquations();
            this.initVariableMappings();
            this.initDelayedEquations();
            this.initFunctions();
            Logger.getLogger(EModel.class.getName()).setLevel(Level.ALL);
        }
        finally {
            this.executableModel.setAutodetectTypes(autodetect);
        }
    }

    public String simulate(File[] files, SimulationResult result) throws Exception {
        this.initSimulationResult(result);
        return this.simulate(files, new ResultListener[]{new ResultWriter(result)});
    }

    public abstract String generateVariableCodeName(int var1);

    public abstract String simulate(File[] var1, ResultListener[] var2) throws Exception;

    public abstract double getAbsTolerance();

    public abstract void setAbsTolerance(double var1);

    public abstract double getRelTolerance();

    public abstract void setRelTolerance(double var1);

    protected abstract String getAsArrayName(int var1);

    public abstract Formatter getFormatter();

    @Override
    public List<Preprocessor> getDiagramPreprocessors() {
        ArrayList<Preprocessor> preprocessors = new ArrayList<Preprocessor>();
        preprocessors.add(new EmptyMathPreprocessor());
        preprocessors.add(new ConstraintPreprocessor(this.constraintsViolation));
        preprocessors.add(new BooleanPreprocessor());
        preprocessors.add(new RateOfPreprocessor());
        preprocessors.add(new StateTransitionPreprocessor());
        preprocessors.add(new EventPreprocessor());
        preprocessors.add(new EquationTypePreprocessor());
        preprocessors.add(new StaticModelPreprocessor());
        preprocessors.add(new FastReactionPreprocessor(this.fastReactions));
        preprocessors.add(new DelayPreprocessor());
        preprocessors.add(new TableElementPreprocessor());
        preprocessors.add(new RateAssignmentRulePreprocessor());
        preprocessors.add(new ScalarCyclesPreprocessor());
        return preprocessors;
    }

    private void initFunctions() {
        for (Function function : this.executableModel.getFunctions()) {
            String normalized = this.normalizeFunction(function.getName());
            function.setName(normalized);
            this.functionNames.add(normalized);
            this.normalizeFunction(function);
        }
    }

    public void normalizeFunction(Function function) {
        Set args = StreamEx.of((Object[])function.getArguments()).toSet();
        Map replacements = ((StreamEx)StreamEx.of((Object[])function.getArguments()).filter(arg -> this.isForbidden((String)arg))).toMap(n -> this.normalizeAndUpdate((String)n, args));
        AstStart start = this.getMath(function.getFormula(), (Role)function);
        Utils.renameVariableInAST((Node)start, (Map)replacements);
        String newFormula = new LinearFormatter().format(start)[1];
        function.setFormula(newFormula);
    }

    private void initVariableMappings() {
        this.varNames = new HashSet<String>();
        this.varNameMapping = new HashMap<String, String>();
        this.varIndexMapping = new HashMap<String, Integer>();
        this.varNameRateIndexMapping = new HashMap<String, Integer>();
        this.varInitialMapping = new HashMap<String, Double>();
        this.variableArraySize = 0;
        this.functionNames = new HashSet<String>();
        boolean generateAsArray = this.isArrayModeOn();
        int index = 0;
        int rateEquationNumber = 0;
        for (Variable v : this.executableModel.getVariables()) {
            String codeName;
            boolean arrayModeVariable = this.isArrayModeVariable(v);
            String name = v.getName();
            if (name == null) continue;
            if (arrayModeVariable) {
                codeName = this.generateVariableCodeName(rateEquationNumber);
                this.varNameRateIndexMapping.put(name, rateEquationNumber++);
            } else {
                codeName = generateAsArray && !"time".equals(name) ? this.getAsArrayName(this.variableArraySize++) : this.normalize(name);
            }
            this.varNameMapping.put(name, codeName);
            this.varNames.add(codeName);
            if (this.isAutogenerated(v)) continue;
            this.varInitialMapping.put(name, v.getInitialValue());
            this.varIndexMapping.put(name, index++);
        }
        this.varPathIndexMapping = new HashMap<String, Integer>();
        if (this.varPathMapping != null) {
            HashSet usedVariables = new HashSet();
            for (Map.Entry e : EntryStream.of(this.varPathMapping)) {
                usedVariables.add(e.getValue());
                this.varPathIndexMapping.put((String)e.getKey(), this.varIndexMapping.get(e.getValue()));
            }
            for (Map.Entry<String, Integer> e : this.varIndexMapping.entrySet()) {
                if (usedVariables.contains(e.getKey())) continue;
                this.varPathIndexMapping.put(e.getKey(), e.getValue());
            }
            if (this.result != null) {
                this.result.setVariableMap(this.varIndexMapping);
            }
        } else {
            this.varPathIndexMapping.putAll(this.varIndexMapping);
        }
        if (this.result != null) {
            this.result.setVariablePathMap(this.varPathIndexMapping);
            this.result.setVariableMap(this.getVarPathIndexMapping());
        }
    }

    private void initDelayedEquations() {
        this.varHistoricalIndexMapping = new HashMap<String, Integer>();
        this.varNameHistoryIndexMapping = new HashMap<String, Integer>();
        int historicalVariableNumber = 0;
        if (this.containsDelays()) {
            List delayedExpressions = this.executableModel.getDelayedExpressionsList();
            for (EModel.DelayedExpression expression : delayedExpressions) {
                AstVarNode delayedExpression = expression.node;
                String varName = delayedExpression.getName();
                String codeName = this.varNameMapping.get(varName);
                Variable var = this.executableModel.getVariable(varName);
                if (codeName == null || varName == null || this.varHistoricalIndexMapping.containsKey(codeName)) continue;
                this.varHistoricalIndexMapping.put(codeName, historicalVariableNumber);
                this.varNameHistoryIndexMapping.put(var.getName(), historicalVariableNumber);
                ++historicalVariableNumber;
            }
        }
    }

    public int getRateEquationNumber() {
        return this.varNameRateIndexMapping.size();
    }

    public Integer getVariableRateIndex(String name) {
        if (!this.varNameRateIndexMapping.containsKey(name)) {
            this.log.error("WARNING_UNDEFINED_VARIABLE", new String[]{this.diagram.getName(), name});
            return null;
        }
        return this.varNameRateIndexMapping.get(name);
    }

    public String[] getSpeciesNames() {
        Set<String> keys = this.varNameRateIndexMapping.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public synchronized String generateUniqueLocalVariable(String base) {
        int index = 1;
        String v = base;
        while (this.executableModel.getVariable(v) != null) {
            v = base + index++;
        }
        return v;
    }

    public AstStart getMath(String expression, Role role) {
        return this.executableModel.readMath(expression, role, (VariableResolver)this.executableModel.getVariableResolver(0));
    }

    public String[] formatMath(String expression, Role role) throws Exception {
        List<ASTVisitor> visitors = this.getGenericASTVisitors();
        return this.formatMath(this.getMath(expression, role), visitors);
    }

    public String[] formatMath(String expression, Role role, Collection<ASTVisitor> astVisitors) throws Exception {
        return this.formatMath(this.getMath(expression, role), astVisitors);
    }

    public String[] formatMath(AstStart start) throws Exception {
        return this.formatMath(start, this.getGenericASTVisitors());
    }

    public String[] formatMath(AstStart start, Collection<ASTVisitor> astVisitors) throws Exception {
        if (start == null) {
            return new String[]{"", ""};
        }
        AstStart cloneAST = (AstStart)Utils.cloneAST((Node)start);
        for (ASTVisitor visitor : astVisitors) {
            Utils.visitAST((Node)cloneAST, (ASTVisitor)visitor);
        }
        return this.getFormatter().format(cloneAST);
    }

    protected List<ASTVisitor> getGenericASTVisitors() {
        ArrayList<ASTVisitor> visitors = new ArrayList<ASTVisitor>();
        visitors.add((ASTVisitor)new VariableSubstituteASTVisitor());
        visitors.add((ASTVisitor)new OptimizerASTVisitor());
        return visitors;
    }

    public static List<ASTVisitor> getFunctionDeclarationASTVisitors() {
        ArrayList<ASTVisitor> visitors = new ArrayList<ASTVisitor>();
        visitors.add((ASTVisitor)new OptimizerASTVisitor());
        return visitors;
    }

    public List<ASTVisitor> getInitialValuesASTVisitors(String varName) {
        ArrayList<ASTVisitor> visitors = new ArrayList<ASTVisitor>();
        visitors.add((ASTVisitor)new InitialValueCalculationSubstituteASTVisitor(varName));
        visitors.add((ASTVisitor)new VariableSubstituteASTVisitor());
        visitors.add((ASTVisitor)new OptimizerASTVisitor());
        return visitors;
    }

    public List<ASTVisitor> getInitialEquationASTVisitors() {
        ArrayList<ASTVisitor> visitors = new ArrayList<ASTVisitor>();
        visitors.add((ASTVisitor)new InitialValuesSubstituteMathProcessor());
        visitors.add((ASTVisitor)new VariableSubstituteASTVisitor());
        visitors.add((ASTVisitor)new OptimizerASTVisitor());
        return visitors;
    }

    public List<ASTVisitor> getPrehistoryASTVisitors() {
        ArrayList<ASTVisitor> visitors = new ArrayList<ASTVisitor>();
        visitors.add((ASTVisitor)new AssignmentSubstitutionVisitor());
        visitors.add((ASTVisitor)new VariableSubstituteASTVisitor());
        visitors.add((ASTVisitor)new OptimizerASTVisitor());
        return visitors;
    }

    @Override
    public Map<String, Integer> getVarIndexMapping() {
        return this.varIndexMapping;
    }

    @Override
    public Map<String, Integer> getVarPathIndexMapping() {
        return this.varPathIndexMapping;
    }

    public int getVarIndex(String name) throws Exception {
        return this.varIndexMapping.get(name);
    }

    public Map<String, Double> getVarInitialMapping() {
        return this.varInitialMapping;
    }

    @Override
    public SimulationEngine clone() {
        OdeSimulationEngine clone = (OdeSimulationEngine)super.clone();
        clone.setOutputDir(this.outputDir);
        return clone;
    }

    public void initDefiningEquations() {
        this.definingEquations = new HashMap<String, List<Equation>>();
        for (Equation eq : this.executableModel.getEquations()) {
            String varName;
            Variable variable;
            if ("algebraic".equals(eq.getType()) || "scalar_internal".equals(eq.getType()) || (variable = this.executableModel.getVariable(varName = eq.getVariable())).isConstant() && !"initial assignment".equals(eq.getType()) || variable instanceof VariableRole && ((VariableRole)variable).isBoundaryCondition() && "rate".equals(eq.getType()) && eq.getParent() instanceof Edge) continue;
            this.definingEquations.computeIfAbsent(varName, k -> new ArrayList()).add(eq);
        }
    }

    public List<Equation> getDefiningEquations(String varName) {
        ArrayList result = this.definingEquations.get(varName);
        return result != null ? result : new ArrayList();
    }

    @Override
    public String getOutputDir() {
        return this.outputDir;
    }

    @Override
    public void setOutputDir(String outputDir) {
        String oldValue = this.outputDir;
        this.outputDir = outputDir;
        this.firePropertyChange("outputDir", oldValue, outputDir);
    }

    public Map<String, Integer> getvarHistoricalIndexMapping() {
        return this.varHistoricalIndexMapping;
    }

    public Map<String, Integer> getVarNameHistoryIndexMapping() {
        return this.varNameHistoryIndexMapping;
    }

    public String getArrayMode() {
        return this.arrayMode;
    }

    public void setGenerateVariableAsArray(String arrayMode) {
        this.arrayMode = arrayMode;
    }

    protected boolean isArrayModeOn() {
        return this.arrayMode == null ? false : this.arrayMode.equals(ARRAY_MODE_ON) || this.arrayMode.equals(ARRAY_MODE_AUTO);
    }

    public boolean containsDelays() {
        return EModel.isOfType((int)this.modelType, (int)4);
    }

    public boolean isInternal(String variable) {
        return !this.isReactionVariables() || variable.startsWith("$$");
    }

    public static boolean isReactionEquation(Equation eq) {
        return eq.getParent() instanceof Edge;
    }

    public boolean isSignificant(Variable variable) {
        return !this.isTemp(variable) && !this.isAutogenerated(variable);
    }

    public boolean isTemp(Variable variable) {
        return Boolean.TRUE.equals(variable.getAttributes().getValue("temp"));
    }

    public boolean isAutogenerated(Variable variable) {
        return Boolean.TRUE.equals(variable.getAttributes().getValue("autogenerated"));
    }

    public boolean isAlgebraic(String variable) {
        return this.executableModel.getVariable(variable).getType().equals("Algebraic");
    }

    @PropertyName(value="Reaction rate variables")
    @PropertyDescription(value="If true then reaction rate variables will appear in simulation result (e.g. $$rate_reactionName)")
    public boolean isReactionVariables() {
        return this.reactionVariables;
    }

    public void setReactionVariables(boolean reactionVariables) {
        this.reactionVariables = reactionVariables;
    }

    public boolean isArrayModeVariable(Variable v) {
        return v.getType().equals("Differential");
    }

    public int getHistoricalVariableNumber() {
        return this.varHistoricalIndexMapping.size();
    }

    @Override
    public String getVariableCodeName(String varName) {
        String codeName = this.varNameMapping.get(varName);
        if (codeName == null) {
            this.log.error("ERROR_UNDEFINED_VARIABLE", new String[]{this.diagram.getName(), varName});
            return varName;
        }
        return codeName;
    }

    @Override
    public String getVariableCodeName(String diagramName, String varName) {
        if (this.codeVariableNames != null && this.codeVariableNames.containsKey(diagramName) && this.codeVariableNames.get(diagramName).containsKey(varName)) {
            return this.codeVariableNames.get(diagramName).get(varName);
        }
        return varName;
    }

    @Override
    public String normalize(String name) {
        return this.changeToUniqueName(super.normalize(name));
    }

    public String normalizeFunction(String name) {
        return name;
    }

    protected String changeToUniqueName(String name) {
        if (this.varNames.contains(name)) {
            name = name + "_";
            return this.changeToUniqueName(name);
        }
        return name;
    }

    public boolean isForbidden(String name) {
        return false;
    }

    public String normalizeAndUpdate(String name, Set<String> existing) {
        while (this.isForbidden(name) || existing.contains(name)) {
            name = name + "_";
        }
        existing.add(name);
        return name;
    }

    @PropertyName(value="Constraints violation")
    @PropertyDescription(value="How to handle constraints violation in the model.")
    public String getConstraintsViolation() {
        return this.constraintsViolation;
    }

    public void setConstraintsViolation(String constraintsViolation) {
        this.constraintsViolation = constraintsViolation;
        this.diagramModified = true;
    }

    public static String[] getFastReactionsMethods() {
        return new String[]{ODE_SYSTEM, ALGEBRAIC_SYSTEM};
    }

    public static class OptimizerASTVisitor
    extends ASTVisitorSupport {
        public void visitStart(AstStart start) throws Exception {
            Utils.pruneFunctions((Node)start);
            Utils.optimizeDummyExpressions((Node)start);
        }
    }

    private class AssignmentSubstitutionVisitor
    extends ASTVisitorSupport {
        private AssignmentSubstitutionVisitor() {
        }

        public void visitNode(Node node) throws Exception {
            Node parent = node.jjtGetParent();
            if (parent instanceof AstFunNode && "delay".equals(((AstFunNode)parent).getFunction().getName())) {
                return;
            }
            if (node instanceof AstFunNode) {
                AstFunNode funNode = (AstFunNode)node;
                if (!"delay".equals(funNode.getFunction().getName())) {
                    for (int i = 0; i < funNode.jjtGetNumChildren(); ++i) {
                        this.visitNode(funNode.jjtGetChild(i));
                    }
                    return;
                }
            } else if (node instanceof AstVarNode) {
                AstVarNode varNode = (AstVarNode)node;
                String name = varNode.getName();
                Variable var = OdeSimulationEngine.this.executableModel.getVariable(name);
                if (var.isConstant()) {
                    AstConstant constant = new AstConstant(7);
                    constant.setValue((Object)var.getInitialValue());
                    constant.jjtSetParent(parent);
                    parent.jjtReplaceChild(node, (Node)constant);
                } else {
                    List<Equation> equations = OdeSimulationEngine.this.definingEquations.get(name);
                    if (equations == null) {
                        return;
                    }
                    for (Equation simpleEquation : equations) {
                        if (!simpleEquation.getType().equals("initial assignment") && !simpleEquation.getType().equals("scalar") && !simpleEquation.getType().equals("scalar_delayed")) continue;
                        AstStart start = simpleEquation.getMath();
                        Node replacement = start.jjtGetChild(0);
                        replacement.jjtSetParent(parent);
                        parent.jjtReplaceChild(node, replacement);
                        this.visitNode(replacement);
                    }
                }
            }
        }
    }

    private class InitialValuesSubstituteMathProcessor
    extends ASTVisitorSupport {
        private InitialValuesSubstituteMathProcessor() {
        }

        public void visitStart(AstStart start) throws Exception {
            Utils.calculateVariables((Node)start, (Map)OdeSimulationEngine.this.varInitialMapping);
        }
    }

    private class InitialValueCalculationSubstituteASTVisitor
    extends ASTVisitorSupport {
        String replacement = null;

        public InitialValueCalculationSubstituteASTVisitor(String varName) {
            Integer index;
            Variable var = OdeSimulationEngine.this.executableModel.getVariable(varName);
            if (var instanceof VariableRole && ((VariableRole)var).getInitialQuantityType() == 1 && (index = OdeSimulationEngine.this.getVariableRateIndex(varName)) != null) {
                this.replacement = "initialValues[" + index + "]";
            }
        }

        public void visitNode(Node node) throws Exception {
            if (node instanceof AstConstant) {
                if (this.replacement == null) {
                    return;
                }
                AstConstant varNode = (AstConstant)node;
                String name = varNode.getName();
                if (name.equals("__INITIAL_VALUE__")) {
                    varNode.setName(this.replacement);
                }
            }
        }
    }

    private class VariableSubstituteASTVisitor
    extends ASTVisitorSupport {
        private VariableSubstituteASTVisitor() {
        }

        public void visitNode(Node node) throws Exception {
            if (node instanceof AstVarNode) {
                AstVarNode varNode = (AstVarNode)node;
                varNode.setName(OdeSimulationEngine.this.getVariableCodeName(varNode.getName()));
            }
        }
    }
}

