/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.plugins.simulation.ResultListenerFilter;
import biouml.standard.simulation.ResultListener;

public class OdeResultListenerFilter
extends ResultListenerFilter {
    private double minimalTimeStep = 1.0E-5;
    private double minimalSolutionDifference = Double.MIN_VALUE;
    double recentProcessedTime = 0.0;
    double[] recentProcessedSolution = null;

    public OdeResultListenerFilter(ResultListener[] outputListener) {
        super(outputListener);
    }

    public double getMinimalTimeStep() {
        return this.minimalTimeStep;
    }

    public void setMinimalTimeStep(double minimalTimeStep) {
        this.minimalTimeStep = minimalTimeStep;
    }

    public double getMinimalSolutionDifference() {
        return this.minimalSolutionDifference;
    }

    public void setMinimalSolutionDifference(double minimalSolutionDifference) {
        this.minimalSolutionDifference = minimalSolutionDifference;
    }

    @Override
    public void add(double t, double[] x) throws Exception {
        if (this.recentProcessedSolution == null) {
            this.recentProcessedSolution = x;
            this.recentProcessedTime = t;
            super.add(t, x);
            return;
        }
        int n = x.length;
        if (n != this.recentProcessedSolution.length) {
            throw new Exception("Solution dimensions do not agree: " + x.length + " != " + this.recentProcessedSolution.length);
        }
        if (Math.abs(t - this.recentProcessedTime) < this.minimalTimeStep) {
            boolean soluitionChanged = false;
            for (int i = 0; i < n; ++i) {
                if (!(Math.abs(x[i] - this.recentProcessedSolution[i]) > this.minimalSolutionDifference)) continue;
                soluitionChanged = true;
            }
            if (!soluitionChanged) {
                return;
            }
        }
        this.recentProcessedSolution = x;
        this.recentProcessedTime = t;
        super.add(t, x);
    }
}

