/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Diagram;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Variable;
import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.ModelRunnerListener;
import biouml.plugins.simulation.OdeSimulationEngine;
import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.Simulator;
import biouml.plugins.simulation.SimulatorProfile;
import biouml.standard.simulation.SimulationResult;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.security.SessionThread;
import ru.biosoft.jobcontrol.FunctionJobControl;
import ru.biosoft.jobcontrol.JobControl;
import ru.biosoft.jobcontrol.JobControlEvent;
import ru.biosoft.jobcontrol.JobControlListener;
import ru.biosoft.jobcontrol.JobControlListenerAdapter;

public class ModelRunner {
    protected static final Logger log = Logger.getLogger(ModelRunner.class.getName());
    protected int threadsNumber = 1;
    protected ThreadTask[] threads;
    protected Semaphore[] semaphores;
    protected ModelRunnerListener modelRunnerListener;
    private JobControlListener jobControlListener;
    protected DataGenerator dataGenerator;

    public ModelRunner(SimulationEngine simulationEngine, DataGenerator generator, int threadsNum) {
        if (threadsNum > 1) {
            this.threadsNumber = threadsNum;
        }
        this.dataGenerator = generator;
        this.semaphores = new Semaphore[this.threadsNumber];
        this.threads = new ThreadTask[this.threadsNumber];
        for (int i = 0; i < this.threadsNumber; ++i) {
            this.threads[i] = new ThreadTask(simulationEngine, i);
            this.threads[i].setDaemon(true);
        }
        this.initListeners();
    }

    public void addModelRunnerListener(ModelRunnerListener l) {
        this.modelRunnerListener = l;
    }

    private void initListeners() {
        this.jobControlListener = new JobControlListenerAdapter(){

            public void jobTerminated(JobControlEvent event) {
                for (int i = 0; i < ModelRunner.this.threadsNumber; ++i) {
                    ModelRunner.this.threads[i].terminate();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulate(JobControl jobControl) throws Exception {
        if (jobControl != null) {
            jobControl.addListener(this.jobControlListener);
        }
        for (int i = 0; i < this.threadsNumber; ++i) {
            this.semaphores[i] = new Semaphore();
        }
        Class<ThreadTask> i = ThreadTask.class;
        synchronized (ThreadTask.class) {
            Semaphore[] semaphoreArray = this.semaphores;
            synchronized (this.semaphores) {
                for (int i2 = 0; i2 < this.threadsNumber; ++i2) {
                    this.threads[i2].start();
                }
                boolean isAllStarted = false;
                block12: while (!isAllStarted) {
                    try {
                        this.semaphores.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    isAllStarted = true;
                    for (int i3 = 0; i3 < this.threadsNumber; ++i3) {
                        if (this.semaphores[i3].isStarted) continue;
                        isAllStarted = false;
                        continue block12;
                    }
                }
                // ** MonitorExit[var3_5] (shouldn't be in output)
            }
            {
                for (int i4 = 0; i4 < this.threadsNumber; ++i4) {
                    try {
                        this.threads[i4].join();
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        return;
                    }
                }
                if (jobControl != null) {
                    jobControl.removeListener(this.jobControlListener);
                }
                return;
            }
        }
    }

    protected class ThreadTask
    extends SessionThread {
        protected SimulationEngine simulationEngine;
        protected int threadNumber;
        protected Model model;

        ThreadTask(SimulationEngine simulationEngine, int threadNumber) {
            this.setName("Thread N" + threadNumber);
            this.threadNumber = threadNumber;
            this.simulationEngine = simulationEngine.clone();
            this.simulationEngine.setJobControl(new FunctionJobControl(log));
            Diagram diagram = simulationEngine.getDiagram();
            if (diagram != null) {
                try {
                    Diagram cloneDiagram = diagram.clone(diagram.getOrigin(), diagram.getName());
                    this.simulationEngine.setDiagram(cloneDiagram);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Model runner: can not process diagram '" + diagram.getName() + "'", e);
                }
            }
            this.generateModel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Semaphore[] semaphoreArray = ModelRunner.this.semaphores;
            synchronized (ModelRunner.this.semaphores) {
                ModelRunner.this.semaphores[this.threadNumber].isStarted = true;
                ModelRunner.this.semaphores.notify();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                try {
                    double[] values = ModelRunner.this.dataGenerator.getValues();
                    while (values != null) {
                        SimulationResult simulationResult = new SimulationResult(null, "Simulation Result");
                        this.setVariables(values, ModelRunner.this.dataGenerator.getNames());
                        this.simulationEngine.setInitialTime(ModelRunner.this.dataGenerator.getInitialTime());
                        this.simulationEngine.setCompletionTime(ModelRunner.this.dataGenerator.getCompletionTime());
                        String status = this.simulationEngine.simulate(this.model, simulationResult);
                        if (ModelRunner.this.modelRunnerListener != null) {
                            SimulatorProfile profile = ((Simulator)this.simulationEngine.getSolver()).getProfile();
                            if (!(status != null && status.length() != 0 || profile.isStiff() || profile.isUnstable())) {
                                ModelRunner.this.modelRunnerListener.resultReady(simulationResult, values, ModelRunner.this.dataGenerator.getNames());
                            }
                        }
                        values = ModelRunner.this.dataGenerator.getValues();
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "ModelRunner: error during the diagram simulation.", e);
                }
                return;
            }
        }

        public void terminate() {
            this.simulationEngine.getJobControl().terminate();
        }

        private void generateModel() {
            try {
                this.model = this.simulationEngine.createModel();
                HashMap<String, Double> parameterValues = new HashMap<String, Double>();
                double[] variableValues = this.initVariables(parameterValues);
                this.model.init(variableValues, parameterValues);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "ModelRunner: base models generation error, error=" + t);
            }
        }

        private double[] initVariables(Map<String, Double> parameterValues) {
            double[] variableValues = null;
            Map<String, Integer> varMapping = null;
            if (this.simulationEngine instanceof OdeSimulationEngine) {
                varMapping = ((OdeSimulationEngine)this.simulationEngine).varNameRateIndexMapping;
                variableValues = new double[varMapping.size()];
            }
            EModel emodel = (EModel)this.simulationEngine.getDiagram().getRole(EModel.class);
            DataCollection variables = emodel.getVariables();
            for (Variable var : variables) {
                String name = var.getName();
                if (varMapping != null && varMapping.containsKey(name)) {
                    int index = varMapping.get(name);
                    variableValues[index] = var.getInitialValue();
                    continue;
                }
                String codeName = this.simulationEngine.getVariableCodeName(name);
                parameterValues.put(codeName, var.getInitialValue());
            }
            return variableValues;
        }

        public void setVariables(double[] values, String[] names) throws Exception {
            HashMap<String, Double> parameterValues = new HashMap<String, Double>();
            double[] variableValues = this.initVariables(parameterValues);
            Map<String, Integer> varMapping = null;
            if (this.simulationEngine instanceof OdeSimulationEngine) {
                varMapping = ((OdeSimulationEngine)this.simulationEngine).varNameRateIndexMapping;
            }
            for (int j = 0; j < values.length; ++j) {
                if (varMapping != null && varMapping.containsKey(names[j])) {
                    int index = varMapping.get(names[j]);
                    variableValues[index] = values[j];
                    continue;
                }
                String codeName = this.simulationEngine.getVariableCodeName(names[j]);
                parameterValues.put(codeName, values[j]);
            }
            this.model.init(variableValues, parameterValues);
        }
    }

    protected static class Semaphore {
        public boolean isStarted = false;

        protected Semaphore() {
        }
    }

    public static abstract class DataGenerator {
        public abstract double[] getValues();

        public abstract String[] getNames();

        public abstract double getInitialTime();

        public abstract double getCompletionTime();
    }
}

