/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Diagram;
import biouml.model.dynamics.EModel;
import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.SimulationEngineRegistry;
import biouml.plugins.simulation.java.JavaSimulationEngine;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyName;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.ComponentModel;
import com.developmentontheedge.beans.model.Property;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.analysiscore.AbstractAnalysisParameters;

@PropertyName(value="Model analysis")
public class ModelAnalysisParameters
extends AbstractAnalysisParameters {
    private DataElementPath modelPath;
    private DataElementPath reportPath;
    private SimulationEngine simulationEngine;

    @PropertyName(value="Diagram path")
    public DataElementPath getModelPath() {
        return this.modelPath;
    }

    public void setModelPath(DataElementPath modelPath) {
        if (modelPath == null) {
            return;
        }
        DataElement de = modelPath.optDataElement();
        if (!(de instanceof Diagram) || !(((Diagram)de).getRole() instanceof EModel)) {
            return;
        }
        SimulationEngine engine = SimulationEngineRegistry.getSimulationEngine((Diagram)de);
        if (!(engine instanceof JavaSimulationEngine)) {
            return;
        }
        engine.setDiagram((Diagram)de);
        DataElementPath oldValue = this.modelPath;
        this.modelPath = modelPath;
        this.setSimulationEngine(engine);
        this.firePropertyChange("modelPath", oldValue, modelPath);
    }

    public SimulationEngine getSimulationEngine() {
        return this.simulationEngine;
    }

    public void setSimulationEngine(SimulationEngine engine) {
        SimulationEngine oldValue = this.simulationEngine;
        this.simulationEngine = engine;
        if (engine != null) {
            engine.setParent((Option)this);
            ComponentModel model = ComponentFactory.getModel((Object)((Object)this));
            ComponentFactory.recreateChildProperties((Property)model);
        }
        this.firePropertyChange("simulationEngine", oldValue, engine);
    }

    @PropertyName(value="Report path")
    public DataElementPath getReportPath() {
        return this.reportPath;
    }

    public void setReportPath(DataElementPath reportPath) {
        DataElementPath oldValue = this.reportPath;
        this.reportPath = reportPath;
        this.firePropertyChange("reportPath", oldValue, reportPath);
    }
}

