/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Diagram;
import biouml.model.dynamics.EModel;
import biouml.plugins.simulation.ModelAnalysisParameters;
import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.java.JavaBaseModel;
import biouml.plugins.simulation.java.JavaSimulationEngine;
import biouml.standard.simulation.ResultListener;
import com.developmentontheedge.application.ApplicationUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import one.util.streamex.DoubleStreamEx;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import ru.biosoft.access.HtmlDataElement;
import ru.biosoft.access.core.ClassIcon;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.analysis.Util;
import ru.biosoft.analysiscore.AnalysisJobControl;
import ru.biosoft.analysiscore.AnalysisMethodSupport;
import ru.biosoft.analysiscore.AnalysisParameters;
import ru.biosoft.util.TempFile;
import ru.biosoft.util.TempFiles;

@ClassIcon(value="resources/simulation-analysis.gif")
public class ModelAnalysis
extends AnalysisMethodSupport<ModelAnalysisParameters> {
    private ModelAnalysisJobControl jobControl;

    public ModelAnalysis(DataCollection<?> origin, String name) {
        super(origin, name, (AnalysisParameters)new ModelAnalysisParameters());
        this.log = Logger.getLogger(ModelAnalysis.class.getName());
        this.jobControl = new ModelAnalysisJobControl(Logger.getLogger(ModelAnalysis.class.getName()));
    }

    public void validateParameters() throws IllegalArgumentException {
        SimulationEngine engine;
        ModelAnalysisParameters params = (ModelAnalysisParameters)this.getParameters();
        if (params.getModelPath() != null) {
            super.validateParameters();
            Diagram diagram = (Diagram)((ModelAnalysisParameters)this.parameters).getModelPath().getDataElement(Diagram.class);
            if (diagram.getRole() == null || !(diagram.getRole() instanceof EModel)) {
                throw new IllegalArgumentException("Diagram does not contain a model. Please, select valid diagram.");
            }
        }
        if ((engine = ((ModelAnalysisParameters)this.parameters).getSimulationEngine()) == null) {
            throw new IllegalArgumentException("Simulation engine was not set.");
        }
        if (!(engine instanceof JavaSimulationEngine)) {
            throw new IllegalArgumentException("Only Java Simulation Engine is supported.");
        }
    }

    public ModelAnalysisJobControl getJobControl() {
        return this.jobControl;
    }

    public HtmlDataElement justAnalyzeAndPut() throws Exception {
        int i;
        this.validateParameters();
        ModelAnalysisParameters params = (ModelAnalysisParameters)this.getParameters();
        JavaSimulationEngine engine = (JavaSimulationEngine)params.getSimulationEngine();
        engine.setTerminated(false);
        JavaBaseModel model = (JavaBaseModel)engine.createModel();
        model.init();
        Map rateMapping = EntryStream.of((Map)engine.varNameRateIndexMapping).invert().toMap();
        double[] x_values = model.getY();
        double[] dydt = model.dy_dt(0.0, x_values);
        double[] abs = DoubleStreamEx.of((double[])dydt).map(d -> Math.abs(d)).toArray();
        int[] oldIndices = Util.sort((double[])abs);
        int rateNumber = Math.min(5, dydt.length);
        String[] rateVariables = new String[rateNumber];
        double[] rates = new double[rateNumber];
        for (i = 0; i < rateNumber; ++i) {
            int oldIndex = oldIndices[dydt.length - 1 - i];
            rateVariables[i] = (String)rateMapping.get(oldIndex);
            rates[i] = dydt[oldIndex];
        }
        this.log.info("Variables with largest rate:");
        for (i = 0; i < rateNumber; ++i) {
            this.log.info(rateVariables[i] + ":\t" + rates[i]);
        }
        ModelReport report = new ModelReport();
        report.setRates(rates);
        report.setRateVariables(rateVariables);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("report", report);
        context.put("name", engine.getDiagram().getName());
        String name = params.getReportPath().getName();
        DataCollection resultCollection = params.getReportPath().getParentCollection();
        return ModelAnalysis.generateReport(name, resultCollection, ((Object)((Object)this)).getClass().getResourceAsStream("resources/modelReport.vm"), context);
    }

    private static HtmlDataElement generateReport(String name, DataCollection parent, InputStream template, Map<String, Object> contextMap) throws Exception {
        Properties p = new Properties();
        TempFile templateFile = TempFiles.file((String)"template");
        try (BufferedWriter bw = ApplicationUtils.utfWriter((File)templateFile);
             BufferedReader reader = new BufferedReader(new InputStreamReader(template, StandardCharsets.UTF_8));){
            bw.write(StreamEx.of(reader.lines()).joining((CharSequence)"\n"));
        }
        p.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
        p.setProperty("file.resource.loader.path", templateFile.getParentFile().getAbsolutePath());
        VelocityEngine engine = new VelocityEngine(p);
        engine.init();
        Template velocityTemplate = engine.getTemplate(templateFile.getName(), "UTF-8");
        VelocityContext context = new VelocityContext();
        contextMap.entrySet().forEach(e -> context.put((String)e.getKey(), e.getValue()));
        TempFile resultFile = TempFiles.file((String)name);
        try (BufferedWriter bw = ApplicationUtils.utfWriter((File)resultFile);){
            velocityTemplate.merge((Context)context, (Writer)bw);
        }
        HtmlDataElement html = new HtmlDataElement(name, parent, ApplicationUtils.readAsString((File)resultFile));
        parent.put((DataElement)html);
        return html;
    }

    public class ModelAnalysisJobControl
    extends AnalysisJobControl
    implements ResultListener {
        private double percentStep;

        public ModelAnalysisJobControl(Logger l) {
            super((AnalysisMethodSupport)ModelAnalysis.this);
        }

        public void add(double t, double[] y) throws Exception {
            this.setPreparedness((int)(t * this.percentStep));
        }

        public void start(Object model) {
        }

        public void setPercentStep(double step) {
            this.percentStep = step;
        }

        protected void setTerminated(int status) {
            ModelAnalysisParameters params = (ModelAnalysisParameters)ModelAnalysis.this.getParameters();
            SimulationEngine engine = params.getSimulationEngine();
            engine.stopSimulation();
            super.setTerminated(status);
        }
    }

    public static class ModelReport {
        private String[] rateVariables;
        private double[] rates;

        public String[] getRateVariables() {
            return this.rateVariables;
        }

        public void setRateVariables(String[] rateVariables) {
            this.rateVariables = rateVariables;
        }

        public double[] getRates() {
            return this.rates;
        }

        public void setRates(double[] rates) {
            this.rates = rates;
        }

        public String getSt() {
            return "sa";
        }

        public String toString() {
            return "a" + this.rates[0];
        }
    }
}

