/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.Function;
import ru.biosoft.math.model.LinearFormatter;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.Utils;

public class FunctionAnalyzer {
    private Map<String, FunRef> references;
    private EModel emodel;

    public void init(EModel emodel) {
        this.emodel = emodel;
        this.references = this.initFunctionReferences();
    }

    public Map<String, Set<Integer>> findDelayedArguments() {
        HashMap<String, Set<Integer>> result = new HashMap<String, Set<Integer>>();
        FunRef delayFunction = this.references.get("delay");
        result.put("delay", Collections.singleton(0));
        this.findDelayedArguments(delayFunction, StreamEx.of((Object[])new Integer[]{0}).toSet(), result);
        return result;
    }

    private Map<String, FunRef> initFunctionReferences() {
        HashMap<String, FunRef> result = new HashMap<String, FunRef>();
        for (biouml.model.dynamics.Function function : this.emodel.getFunctions()) {
            result.put(function.getName(), new FunRef(function));
        }
        result.put("delay", new FunRef(new biouml.model.dynamics.Function(null, "function delay(x,y) = x+y")));
        for (FunRef caller : result.values()) {
            AstStart math = this.emodel.readMath(caller.getFunction().getRightHandSide(), (Role)caller.getFunction());
            this.getFunctionReferences((Node)math, caller, result);
        }
        return result;
    }

    private void getFunctionReferences(Node node, FunRef caller, Map<String, FunRef> references) {
        if (node instanceof AstFunNode) {
            AstFunNode funNode = (AstFunNode)node;
            String name = funNode.getFunction().getName();
            FunRef callee = references.get(name);
            if (callee == null) {
                return;
            }
            block0: for (int j = 0; j < funNode.jjtGetNumChildren(); ++j) {
                Node PassedFromCallerArg = funNode.jjtGetChild(j);
                if (!(PassedFromCallerArg instanceof AstVarNode)) continue;
                String passedFromCallerName = ((AstVarNode)PassedFromCallerArg).getName();
                String[] callerArguments = caller.getFunction().getArguments();
                for (int i = 0; i < callerArguments.length; ++i) {
                    if (!callerArguments[i].equals(passedFromCallerName)) continue;
                    callee.addCaller(caller, j, i);
                    continue block0;
                }
            }
        } else {
            for (int j = 0; j < node.jjtGetNumChildren(); ++j) {
                this.getFunctionReferences(node.jjtGetChild(j), caller, references);
            }
        }
    }

    private void findDelayedArguments(FunRef callee, Set<Integer> args, Map<String, Set<Integer>> result) {
        for (FunRef caller : callee.getCallers()) {
            for (Integer i : args) {
                Set<Integer> callerArguments = callee.getCallerArguments(caller, i);
                result.computeIfAbsent(caller.getName(), k -> new HashSet()).addAll(callerArguments);
                this.findDelayedArguments(caller, callerArguments, result);
            }
        }
    }

    public void substituteDelaysEquations() {
        for (Equation eq : this.emodel.getEquations()) {
            AstStart math = eq.getMath();
            for (AstFunNode child : Utils.deepChildren((Node)math).select(AstFunNode.class)) {
                biouml.model.dynamics.Function f = this.references.get(child.getFunction().getName()).getFunction();
                AstStart replacement = this.emodel.readMath(f.getRightHandSide(), (Role)f);
                this.substitute(math, f.getName(), replacement.jjtGetChild(0));
            }
            eq.setFormula(new LinearFormatter().format(math)[1]);
        }
    }

    public void substituteDelays() {
        FunRef delay = this.references.get("delay");
        for (FunRef caller : delay.getCallers()) {
            this.substituteDelays(caller);
        }
    }

    private void substituteDelays(FunRef callee) {
        for (FunRef caller : callee.getCallers()) {
            this.substitute(caller.getFunction(), callee.getFunction());
            this.substituteDelays(caller);
        }
    }

    public void substitute(biouml.model.dynamics.Function parent, biouml.model.dynamics.Function child) {
        AstStart parentMath = this.emodel.readMath(parent.getRightHandSide(), (Role)parent);
        AstStart childMath = this.emodel.readMath(parent.getRightHandSide(), (Role)parent);
        this.substitute(parentMath, child.getName(), childMath.jjtGetChild(0));
        parent.setRightHandSide(new LinearFormatter().format(parentMath)[1]);
    }

    public void substitute(AstStart parent, String toReplace, Node replacement) {
        for (AstFunNode node : (StreamEx)Utils.deepChildren((Node)parent).select(AstFunNode.class).filter(n -> n.getFunction().getName().equals(toReplace))) {
            Function f = node.getFunction();
            FunRef funRef = this.references.get(f.getName());
            biouml.model.dynamics.Function function = funRef.getFunction();
            String[] args = function.getArguments();
            HashMap<String, Node> mapping = new HashMap<String, Node>();
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                mapping.put(args[i], node.jjtGetChild(i));
            }
            Node formula = this.emodel.readMath(function.getRightHandSide(), (Role)function).jjtGetChild(0);
            this.substituteArgs(formula, mapping);
            parent.jjtReplaceChild((Node)node, formula);
        }
    }

    public void substituteArgs(Node node, Map<String, Node> mapping) {
        for (AstVarNode child : Utils.deepChildren((Node)node).select(AstVarNode.class)) {
            Node replacement = mapping.get(child.getName());
            if (replacement == null) continue;
            child.jjtGetParent().jjtReplaceChild((Node)child, replacement.cloneAST());
        }
    }

    private class FunRef {
        private biouml.model.dynamics.Function function;
        private Map<FunRef, ArgRef> callers = new HashMap<FunRef, ArgRef>();

        public FunRef(biouml.model.dynamics.Function function) {
            this.function = function;
        }

        public biouml.model.dynamics.Function getFunction() {
            return this.function;
        }

        public void addCaller(FunRef caller, Integer argCallee, Integer argCaller) {
            this.callers.computeIfAbsent(caller, k -> new ArgRef()).addArgument(argCallee, argCaller);
        }

        public Set<FunRef> getCallers() {
            return this.callers.keySet();
        }

        public Set<Integer> getCallerArguments(FunRef caller, Integer argument) {
            return this.callers.get(caller).getCallerArguments(argument);
        }

        public String getName() {
            return this.function.getName();
        }

        public int hashCode() {
            return this.function.getName().hashCode();
        }

        public String toString() {
            return this.function.getFormula();
        }

        private class ArgRef {
            Map<Integer, Set<Integer>> argumentReplacement = new HashMap<Integer, Set<Integer>>();

            private ArgRef() {
            }

            public Set<Integer> getCallerArguments(Integer argCallee) {
                return this.argumentReplacement.get(argCallee);
            }

            public void addArgument(Integer argCallee, Integer argCaller) {
                this.argumentReplacement.computeIfAbsent(argCallee, k -> new HashSet()).add(argCaller);
            }
        }
    }
}

