/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Role;
import biouml.model.SemanticController;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.plugins.simulation.Preprocessor;
import biouml.standard.diagram.Util;
import biouml.standard.type.Base;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.math.model.AstConstant;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.LinearFormatter;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.Utils;

public class FastReactionPreprocessor
extends Preprocessor {
    private static final double FAST_REACTION_RATE_MULTIPLIER = 1.0E8;
    private Map<String, List<Equation>> varToEquations;
    private final Set<String> reactantProduct = new HashSet<String>();
    private List<biouml.model.Node> reactions;
    private List<biouml.model.Node> fastReactions;
    private List<AstStart> newAlgebraicEquations = new ArrayList<AstStart>();
    private EModel emodel;
    private Diagram diagram;
    private String method;

    public FastReactionPreprocessor(String method) {
        this.method = method;
    }

    @Override
    public boolean accept(Diagram diagram) {
        return diagram.getRole() instanceof EModel && this.hasFastReactions((Compartment)diagram);
    }

    public boolean hasFastReactions(Compartment compartment) {
        for (DiagramElement de : compartment) {
            if (de instanceof biouml.model.Node && de.getKernel() instanceof Reaction && ((Reaction)de.getKernel()).isFast()) {
                return true;
            }
            if (!(de instanceof Compartment) || !this.hasFastReactions((Compartment)de)) continue;
            return true;
        }
        return false;
    }

    public Diagram simplePreprocess(Diagram diagram) {
        for (biouml.model.Node node : this.fastReactions) {
            if (!(node.getRole() instanceof Equation)) continue;
            Equation eq = (Equation)node.getRole(Equation.class);
            eq.unlinkKernel();
            eq.setFormula(" ( " + eq.getFormula() + " ) * " + 1.0E8);
        }
        return diagram;
    }

    public static Map<String, List<Equation>> initDefiningEquations(EModel emodel) {
        HashMap<String, List<Equation>> varToEquations = new HashMap<String, List<Equation>>();
        emodel.getEquations().forEach(eq -> varToEquations.computeIfAbsent(eq.getVariable(), k -> new ArrayList()).add(eq));
        return varToEquations;
    }

    public void initReactions(Diagram diagram) throws Exception {
        this.reactions = new ArrayList<biouml.model.Node>();
        this.fastReactions = new ArrayList<biouml.model.Node>();
        for (biouml.model.Node n2 : (StreamEx)diagram.recursiveStream().select(biouml.model.Node.class).filter(n -> n.getKernel() instanceof Reaction)) {
            this.reactions.add(n2);
            Reaction r = (Reaction)n2.getKernel();
            if (!r.isFast()) continue;
            for (SpecieReference ref : r.getSpecieReferences()) {
                this.reactantProduct.add(ref.getSpecieVariableRole(diagram).getName());
            }
            this.fastReactions.add(n2);
        }
    }

    @Override
    public Diagram preprocess(Diagram diagram) throws Exception {
        int i;
        int j;
        this.diagram = diagram;
        this.emodel = (EModel)diagram.getRole(EModel.class);
        this.newAlgebraicEquations = new ArrayList<AstStart>();
        this.varToEquations = FastReactionPreprocessor.initDefiningEquations(this.emodel);
        this.initReactions(diagram);
        List<String> species = this.getSpecies();
        List<String> rates = this.getRates();
        double[][] stoichiometry = this.getStoichiometry(this.emodel, species, rates);
        int fastReactionsNumber = this.fastReactions.size();
        int slowReactionsNumber = stoichiometry[0].length - fastReactionsNumber;
        List<String> fastRates = rates.subList(0, fastReactionsNumber);
        List<String> slowRates = rates.subList(fastReactionsNumber, rates.size());
        double[][] fastRateMatrix = new double[stoichiometry.length][fastReactionsNumber];
        double[][] slowRateMatrix = new double[stoichiometry.length][slowReactionsNumber];
        for (j = 0; j < fastReactionsNumber; ++j) {
            for (i = 0; i < stoichiometry.length; ++i) {
                fastRateMatrix[i][j] = stoichiometry[i][j];
            }
        }
        for (j = 0; j < slowReactionsNumber; ++j) {
            for (i = 0; i < stoichiometry.length; ++i) {
                slowRateMatrix[i][j] = stoichiometry[i][fastReactionsNumber + j];
            }
        }
        double[][] leftNullSpaceOfFast = ru.biosoft.analysis.Util.matrixConjugate((double[][])ru.biosoft.analysis.Util.getLeftNullSpace((double[][])fastRateMatrix));
        if (this.reactions.size() == fastReactionsNumber) {
            this.generateFastReactionsSystem(species, fastRates, leftNullSpaceOfFast);
        }
        if (this.method.equals("ODE system")) {
            return this.simplePreprocess(diagram);
        }
        double[][] newSlowRateMatrix = ru.biosoft.analysis.Util.matrixMultiply((double[][])leftNullSpaceOfFast, (double[][])slowRateMatrix);
        if (FastReactionPreprocessor.isZero(newSlowRateMatrix)) {
            this.log.warning("Couldn't handle fast reactions with Quasi-steady state approximation.");
            this.log.warning("Reactions will be handled by significant rate increasing.");
            return this.simplePreprocess(diagram);
        }
        this.generateFastReactionsSystem(species, slowRates, fastRates, leftNullSpaceOfFast, newSlowRateMatrix);
        SemanticController controller = diagram.getType().getSemanticController();
        for (biouml.model.Node node : this.reactions) {
            controller.remove((DiagramElement)node);
            if (((Reaction)node.getKernel()).isFast()) continue;
            Equation eq = (Equation)node.getRole(Equation.class);
            this.createEquation(eq.getVariable(), eq.getFormula(), "scalar_internal");
        }
        for (AstStart start : this.newAlgebraicEquations) {
            this.createEquation(null, start, "algebraic");
        }
        return diagram;
    }

    private void transformMath(AstStart math, EModel emodel) {
        int childCount = math.jjtGetNumChildren();
        for (int i = 0; i < childCount; ++i) {
            Node child = math.jjtGetChild(i);
            child = this.boundaryConditionParser(child, emodel);
            math.jjtReplaceChild(math.jjtGetChild(i), child);
        }
    }

    private Node boundaryConditionParser(Node child, EModel emodel) {
        if (child instanceof AstVarNode) {
            AstVarNode tempChild = (AstVarNode)child;
            Variable sv = emodel.getVariable(tempChild.getName());
            if (sv instanceof VariableRole && ((VariableRole)sv).isBoundaryCondition()) {
                AstConstant tempVar = Utils.createConstant((Object)sv.getInitialValue());
                tempVar.jjtSetParent(child.jjtGetParent());
                return tempVar;
            }
        } else {
            int childCount = child.jjtGetNumChildren();
            for (int i = 0; i < childCount; ++i) {
                Node newChild = child.jjtGetChild(i);
                newChild = this.boundaryConditionParser(newChild, emodel);
                child.jjtReplaceChild(child.jjtGetChild(i), newChild);
            }
        }
        return child;
    }

    private List<String> getSpecies() {
        ArrayList<String> species = new ArrayList<String>();
        for (biouml.model.Node node : this.reactions) {
            for (Edge e : node.getEdges()) {
                String varName;
                biouml.model.Node specieNode = e.getOtherEnd(node);
                if (!(specieNode.getRole() instanceof VariableRole) || ((VariableRole)specieNode.getRole(VariableRole.class)).isBoundaryCondition() || species.contains(varName = ((VariableRole)specieNode.getRole(VariableRole.class)).getName())) continue;
                species.add(varName);
            }
        }
        return species;
    }

    private List<String> getRates() {
        ArrayList<String> result = new ArrayList<String>();
        for (biouml.model.Node node : this.reactions) {
            String varName = ((Equation)node.getRole(Equation.class)).getVariable();
            if (((Reaction)node.getKernel()).isFast()) {
                result.add(0, varName);
                continue;
            }
            result.add(varName);
        }
        return result;
    }

    private double[][] getStoichiometry(EModel emodel, List<String> species, List<String> rates) {
        double[][] rateMatrix = new double[species.size()][this.reactions.size()];
        for (String varName : species) {
            List<Equation> equations = this.varToEquations.get(varName);
            if (equations == null) continue;
            for (Equation eq : equations) {
                double stoichiometry;
                SpecieReference ref;
                String rate;
                block5: {
                    Edge e = (Edge)eq.getParent();
                    biouml.model.Node reactionNode = Util.isReaction((DiagramElement)e.getInput()) ? e.getInput() : e.getOutput();
                    rate = ((Equation)reactionNode.getRole(Equation.class)).getVariable();
                    ref = (SpecieReference)e.getKernel();
                    String stoichiometryStr = ref.getStoichiometry();
                    stoichiometry = 1.0;
                    try {
                        stoichiometry = Double.parseDouble(stoichiometryStr);
                    }
                    catch (NumberFormatException ex) {
                        Variable var = emodel.getVariable(stoichiometryStr);
                        if (var == null) break block5;
                        stoichiometry = var.getInitialValue();
                    }
                }
                if (ref.isReactant()) {
                    stoichiometry *= -1.0;
                }
                if (!rates.contains(rate)) continue;
                rateMatrix[species.indexOf((Object)varName)][rates.indexOf((Object)rate)] = stoichiometry;
            }
        }
        return rateMatrix;
    }

    private void generateFastReactionsSystem(List<String> species, List<String> fastRates, double[][] leftNullSpaceOfFast) throws Exception {
        this.formNewLeftPartOfODE(species, leftNullSpaceOfFast);
        this.formFastReactionEquilibration(fastRates);
    }

    private void generateFastReactionsSystem(List<String> species, List<String> slowRates, List<String> fastRates, double[][] leftNullSpaceOfFast, double[][] newSlowRateMatrix) throws Exception {
        List<String> newLeftPart = this.formNewLeftPartOfODE(species, leftNullSpaceOfFast);
        List<AstStart> newRightPart = this.formNewRightPartOfODE(slowRates, newSlowRateMatrix);
        EntryStream.zip(newLeftPart, newRightPart).forKeyValue((left, right) -> this.createEquation((String)left, (AstStart)right, "rate"));
        this.formFastReactionEquilibration(fastRates);
    }

    private void formFastReactionEquilibration(List<String> fastRateVector) throws Exception {
        for (String fastRateVariableName : fastRateVector) {
            AstStart math = this.varToEquations.get(fastRateVariableName).get(0).getMath();
            this.transformMath(math, this.emodel);
            this.newAlgebraicEquations.add(math);
        }
    }

    private List<String> formNewLeftPartOfODE(List<String> diffVector, double[][] leftNullSpace) throws Exception {
        ArrayList<String> newLeftPart = new ArrayList<String>();
        for (double[] row : leftNullSpace) {
            ArrayList<String> vars = new ArrayList<String>();
            ArrayList<Double> coeffs = new ArrayList<Double>();
            for (int j = 0; j < leftNullSpace[0].length; ++j) {
                if (row[j] == 0.0) continue;
                vars.add(diffVector.get(j));
                coeffs.add(row[j]);
            }
            if (vars.size() > 1) {
                String name = this.generateUniqueVariable("newRate");
                this.emodel.declareVariable(name, (Object)0.0);
                this.generateBoundaryValue(name, vars, coeffs);
                newLeftPart.add(name);
                Node fun = Utils.applyPlus((Node[])((Node[])EntryStream.zip(vars, coeffs).append((Object)name, (Object)-1.0).mapKeyValue((v, c) -> this.createNode((String)v, (double)c)).toArray(Node[]::new)));
                this.newAlgebraicEquations.add(Utils.createStart((Node)fun));
                continue;
            }
            newLeftPart.add((String)vars.get(0));
        }
        return newLeftPart;
    }

    private AstVarNode createConversionFactor(String varName) {
        Variable var = this.emodel.getVariable(varName);
        if (var instanceof VariableRole) {
            String factor = ((VariableRole)var).getConversionFactor();
            if (factor == null || factor.isEmpty()) {
                factor = this.emodel.getConversionFactor();
            }
            if (factor != null && !factor.isEmpty()) {
                return Utils.createVariabl((String)factor);
            }
        }
        return null;
    }

    private Node createNode(String var, double coeff) {
        AstVarNode varNode = Utils.createVariabl((String)var);
        AstConstant constant = Utils.createConstant((Object)coeff);
        AstFunNode result = Utils.applyTimes((Node)varNode, (Node)constant);
        AstVarNode conversion = this.createConversionFactor(var);
        if (conversion != null) {
            result = Utils.applyDivide((Node)result, (Node)conversion);
        }
        return result;
    }

    private void generateBoundaryValue(String name, List<String> variables, List<Double> coeffs) {
        Node[] termsLeft = new Node[variables.size()];
        for (int i = 0; i < variables.size(); ++i) {
            String varName = variables.get(i);
            Variable variable = this.emodel.getVariable(varName);
            termsLeft[i] = Utils.applyTimes((Node)Utils.createConstant((Object)variable.getInitialValue()), (Node)Utils.createConstant((Object)coeffs.get(i)));
            AstVarNode conversionNode = this.createConversionFactor(varName);
            if (conversionNode == null) continue;
            termsLeft[i] = Utils.applyDivide((Node)termsLeft[i], (Node)conversionNode);
        }
        this.createEquation(name, Utils.createStart((Node)Utils.applyPlus((Node[])termsLeft)), "initial assignment");
    }

    public String generateUniqueVariable(String base) {
        String v = base;
        int index = 1;
        while (this.emodel.getVariable(v) != null) {
            v = base + index++;
        }
        return v;
    }

    private List<AstStart> formNewRightPartOfODE(List<String> slowRateVector, double[][] newSlowRateMatrix) {
        ArrayList<AstStart> newRightPartMath = new ArrayList<AstStart>();
        for (double[] row : newSlowRateMatrix) {
            ArrayList<String> vars = new ArrayList<String>();
            ArrayList<Double> coeffs = new ArrayList<Double>();
            for (int j = 0; j < newSlowRateMatrix[0].length; ++j) {
                if (row[j] == 0.0) continue;
                vars.add(slowRateVector.get(j));
                coeffs.add(row[j]);
            }
            Object funNode = vars.size() >= 2 ? Utils.applyPlus((Node[])((Node[])EntryStream.zip(vars, coeffs).mapKeyValue((v, c) -> this.createNode((String)v, (double)c)).toArray(Node[]::new))) : (vars.size() == 1 ? this.createNode((String)vars.get(0), (Double)coeffs.get(0)) : Utils.createConstant((Object)0.0));
            newRightPartMath.add(Utils.createStart((Node)funNode));
        }
        return newRightPartMath;
    }

    public static boolean isZero(double[][] matrix) {
        return !StreamEx.of((Object[])matrix).flatMapToDouble(Arrays::stream).anyMatch(val -> val != 0.0);
    }

    private void createEquation(String variable, AstStart formula, String type) {
        this.createEquation(variable, new LinearFormatter().format(formula)[1], type);
    }

    private void createEquation(String variable, String formula, String type) {
        Equation eq = FastReactionPreprocessor.createEquation(this.diagram, variable, formula, type);
        if (variable == null) {
            return;
        }
        this.varToEquations.computeIfAbsent(variable, k -> new ArrayList()).add(eq);
    }

    public static Equation createEquation(Diagram diagram, String variable, String formula, String type) {
        String name = DefaultSemanticController.generateUniqueNodeName((Compartment)diagram, (String)"equation");
        biouml.model.Node node = new biouml.model.Node((DataCollection)diagram, (Base)new Stub(null, name, "math-equation"));
        Equation eq = new Equation((DiagramElement)node, type, variable, formula);
        node.setRole((Role)eq);
        diagram.put((DiagramElement)node);
        return eq;
    }
}

