/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.plugins.simulation.Preprocessor;
import biouml.standard.type.Base;
import biouml.standard.type.Compartment;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;

public class EventPreprocessor
extends Preprocessor {
    public static final String DELAY_TRIGGER_TYPE = "trigger";
    public static final String DELAY_ASSIGNMENT_TYPE = "assignment";
    public static final String EVENT_TYPE = "eventType";
    private EModel emodel;
    private Diagram diagram;
    private String assignmentVar;

    private void init(Diagram diagram) {
        this.emodel = (EModel)diagram.getRole();
        this.diagram = diagram;
    }

    @Override
    public Diagram preprocess(Diagram diagram) throws Exception {
        this.init(diagram);
        this.assignmentVar = this.generateUniqueVariable(DELAY_ASSIGNMENT_TYPE, this.emodel);
        this.emodel.declareVariable(this.assignmentVar, (Object)0.0);
        this.emodel.getVariable(this.assignmentVar).getAttributes().add(new DynamicProperty("autogenerated", Boolean.TYPE, (Object)true));
        for (Event event : this.emodel.getEvents()) {
            this.processDelayedEvent(event);
        }
        return diagram;
    }

    protected void processDelayedEvent(Event event) throws Exception {
        if (Boolean.TRUE.equals(event.getDiagramElement().getAttributes().getValue("Terminal"))) {
            return;
        }
        ArrayList<Assignment> calculateAssignments = new ArrayList<Assignment>();
        ArrayList<Assignment> executeAssignments = new ArrayList<Assignment>();
        this.generateAssignments(event, calculateAssignments, executeAssignments);
        this.createTriggerEvent(event, calculateAssignments);
        this.createExecutionEvent(event, executeAssignments);
        this.diagram.getType().getSemanticController().remove(event.getDiagramElement());
    }

    private void generateAssignments(Event event, List<Assignment> calculateAssignments, List<Assignment> executeAssignments) throws Exception {
        calculateAssignments.clear();
        executeAssignments.clear();
        List<Assignment> newAssignments = ((StreamEx)StreamEx.of((Object[])event.getEventAssignment()).filter(sa -> !this.emodel.getVariable(sa.getVariable()).isConstant())).map(sa -> sa.clone(null)).toList();
        newAssignments = this.reorderAssignments(newAssignments);
        if (!event.isUseValuesFromTriggerTime()) {
            executeAssignments.addAll(newAssignments);
            return;
        }
        StreamEx.of(newAssignments).map(sa -> new Assignment(this.assignmentVar, sa.getMath())).forEach(calculateAssignments::add);
        StreamEx.of(newAssignments).map(sa -> new Assignment(sa.getVariable(), "1.0")).forEach(executeAssignments::add);
    }

    public String generateUniqueVariable(String base, EModel emodel) throws Exception {
        int index = 1;
        String result = base;
        while (emodel.getVariable(result) != null) {
            result = base + index++;
        }
        Variable var = new Variable(result, emodel, null);
        var.getAttributes().add(new DynamicProperty("temp", Boolean.class, (Object)true));
        emodel.getVariables().put((DataElement)var);
        return result;
    }

    private void createTriggerEvent(Event baseEvent, List<Assignment> assignments) throws Exception {
        assignments.add(0, new Assignment("time", "time + " + baseEvent.getDelay()));
        Event event = this.createEvent(baseEvent.getDiagramElement().getName() + " part1", baseEvent.getDiagramElement().getTitle() + " part1", baseEvent.getTrigger(), null, "Infinity", assignments, baseEvent);
        event.setTriggerMessage(baseEvent.getTriggerMessage());
        event.getDiagramElement().getAttributes().add(new DynamicProperty(EVENT_TYPE, String.class, (Object)DELAY_TRIGGER_TYPE));
    }

    private void createExecutionEvent(Event baseEvent, List<Assignment> assignments) throws Exception {
        String trigger = null;
        if (!baseEvent.isTriggerPersistent() || "0".equals(baseEvent.getDelay())) {
            trigger = baseEvent.getTrigger();
        }
        Event event = this.createEvent(baseEvent.getDiagramElement().getName() + " part2", baseEvent.getDiagramElement().getTitle() + " part2", trigger, baseEvent.getDelay(), baseEvent.getPriority(), assignments, baseEvent);
        event.getDiagramElement().getAttributes().add(new DynamicProperty(EVENT_TYPE, String.class, (Object)DELAY_ASSIGNMENT_TYPE));
    }

    private Event createEvent(String name, String title, String trigger, String delay, String priority, List<Assignment> assignments, Event baseEvent) {
        Node node = new Node((DataCollection)this.diagram, (Base)new Stub(null, name, "math-event"));
        node.setTitle(title);
        Event event = new Event((DiagramElement)node, trigger, delay, assignments.toArray(new Assignment[assignments.size()]));
        event.setPriority(priority);
        event.setTriggerInitialValue(baseEvent.isTriggerInitialValue());
        event.setTriggerPersistent(baseEvent.isTriggerPersistent());
        event.setUseValuesFromTriggerTime(baseEvent.isUseValuesFromTriggerTime());
        event.setDelay(delay);
        node.setRole((Role)event);
        this.diagram.put((DiagramElement)node);
        return event;
    }

    private List<Assignment> reorderAssignments(List<Assignment> assignments) {
        ArrayList<Assignment> reordered = new ArrayList<Assignment>();
        for (Assignment assignment : assignments) {
            Variable var = this.emodel.getVariable(assignment.getVariable());
            if (var instanceof VariableRole && ((VariableRole)var).getDiagramElement().getKernel() instanceof Compartment) {
                reordered.add(assignment);
                continue;
            }
            reordered.add(0, assignment);
        }
        return reordered;
    }
}

