/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation;

import biouml.model.Diagram;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.ExpressionOwner;
import biouml.plugins.simulation.Preprocessor;
import java.util.HashSet;
import java.util.Set;
import one.util.streamex.StreamEx;

public class EmptyMathPreprocessor
extends Preprocessor {
    @Override
    public boolean accept(Diagram diagram) {
        return diagram.getRole() instanceof EModel;
    }

    @Override
    public Diagram preprocess(Diagram diagram) throws Exception {
        for (ExpressionOwner owner : diagram.recursiveStream().map(de -> de.getRole()).select(ExpressionOwner.class)) {
            String[] expressions = owner.getExpressions();
            if (owner.getRole() instanceof Event) {
                Event event = (Event)owner.getRole();
                if (event.getTrigger().isEmpty()) {
                    diagram.remove(event.getDiagramElement().getName());
                    continue;
                }
                HashSet<Assignment> toRemove = new HashSet<Assignment>();
                Assignment[] assignments = event.getEventAssignment();
                for (int i = 0; i < assignments.length; ++i) {
                    if (!assignments[i].getMath().isEmpty()) continue;
                    toRemove.add(assignments[i]);
                }
                EmptyMathPreprocessor.removeAssignments(event, toRemove);
                continue;
            }
            for (int i = 0; i < expressions.length; ++i) {
                if (expressions[i] == null || !expressions[i].isEmpty()) continue;
                diagram.remove(owner.getRole().getDiagramElement().getName());
            }
            owner.setExpressions(expressions);
        }
        return diagram;
    }

    private static void removeAssignments(Event event, Set<Assignment> toRemove) {
        event.setEventAssignment((Assignment[])((StreamEx)StreamEx.of((Object[])event.getEventAssignment()).remove(a -> toRemove.contains(a))).toArray(Assignment[]::new));
    }
}

